/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.serializing.utils;

import com.stimulsoft.base.serializing.utils.XMLChar;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StiXMLConvert {
    private static final Pattern ENCODE_PATTERN = Pattern.compile("_x\\p{XDigit}{4}_");
    private static final char[] PADDING = new char[]{'0', '0', '0'};
    private static final String HEX_DIGITS = "0123456789abcdefABCDEF";
    private static final String PATTERN_STRING = "(?<=_)[Xx]([0-9a-fA-F]{4})_";
    private static final String LINE = "_";

    private StiXMLConvert() {
    }

    public static Object encodeName(Object value) {
        return StiXMLConvert.encodeName(value.toString());
    }

    public static Object encodeName(Enum<?> value) {
        return StiXMLConvert.encodeName(value.name());
    }

    public static String encodeName(String name) {
        return StiXMLConvert.encodeName(name, true);
    }

    public static String encodeName(String name, boolean trim) {
        if (StiValidationUtil.isEmpty((String)name)) {
            return name;
        }
        if (trim) {
            name = name.trim();
        }
        if (StiValidationUtil.isBlank((String)name) && trim) {
            return "";
        }
        StringBuilder newName = new StringBuilder();
        int position = 0;
        int startIndex = 0;
        Pattern pattern = Pattern.compile(PATTERN_STRING);
        Matcher matcher = pattern.matcher(name);
        boolean result = matcher.matches();
        while (result) {
            newName.append(name.substring(startIndex, matcher.start()));
            newName.append("_x005F_x");
            startIndex = matcher.start() + 2;
            matcher = pattern.matcher(name);
            result = matcher.matches();
        }
        newName.append(name.substring(startIndex, name.length()));
        name = newName.toString();
        newName = new StringBuilder();
        if (name.codePointAt(0) >= 48 && name.codePointAt(0) <= 57) {
            newName.append(LINE);
            newName.append(StiXMLConvert.toHex(name));
            newName.append(LINE);
            ++position;
        }
        while (position < name.length()) {
            int charCode = name.codePointAt(position);
            if (charCode < 48 || charCode > 57 && charCode < 65 || charCode > 90 && charCode < 95 || charCode > 122 && charCode < 160) {
                newName.append(LINE);
                newName.append(StiXMLConvert.toHex(charCode));
                newName.append(LINE);
            } else {
                newName.append(name.substring(position, position + 1));
            }
            ++position;
        }
        return newName.toString();
    }

    public static String decodeName(String name) {
        if (StiValidationUtil.isBlank((String)name)) {
            return "";
        }
        if (name.indexOf(LINE) < 0) {
            return name;
        }
        name = name.replace("_x005F_x", "_x");
        int length = name.length();
        int startIndex = 0;
        Pattern pattern = Pattern.compile(PATTERN_STRING);
        Matcher matcher = pattern.matcher(name);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            sb.append(name.substring(startIndex, matcher.start() - 1));
            sb.append(StiXMLConvert.fromHex(matcher.group(1)));
            startIndex = matcher.start() + 6;
        }
        sb.append(name.substring(startIndex, length));
        return sb.toString();
    }

    private static char fromHex(String digit) {
        int decimal = Integer.parseInt(digit, 16);
        return (char)decimal;
    }

    private static String toHex(String digit) {
        return StiXMLConvert.toHex(digit.codePointAt(0));
    }

    private static String toHex(int charCode) {
        String hexValue = Integer.toHexString(charCode);
        StringBuilder value = new StringBuilder();
        switch (hexValue.length()) {
            case 1: {
                value.append("x000").append(hexValue);
                break;
            }
            case 2: {
                value.append("x00").append(hexValue);
                break;
            }
            case 3: {
                value.append("x0").append(hexValue);
                break;
            }
            case 4: {
                value.append("x").append(hexValue);
                break;
            }
            default: {
                throw new RuntimeException("\u043d\u0435\u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u044c \u0441\u0438\u043c\u0432\u043e\u043b \u0432 Hex");
            }
        }
        return value.toString();
    }

    public static void main(String[] args) {
        String encodeName = "_x0035__x002F_8_x002F_1997_x0020_12:00:00_x0020_AM";
        System.out.println("\u0437\u0430\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e  '" + encodeName + "'");
        String decodeName = StiXMLConvert.decodeName(encodeName);
        System.out.println("\u0440\u0430\u0437\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e '" + decodeName + "'");
    }

    public static String DecodeName(String name) {
        return StiXMLConvert.decodeName(name);
    }

    public static String EncodeName(String value) {
        return StiXMLConvert.encodeName(value);
    }

    public static String encode(String name) {
        if (name.length() == 0) {
            return name;
        }
        if (XMLChar.isValidName(name) && name.indexOf("_x") < 0) {
            return name;
        }
        StringBuffer encoded = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            if (i == 0) {
                if (XMLChar.isNameStart(name.charAt(i))) {
                    if (StiXMLConvert.needsEscaping(name, i)) {
                        StiXMLConvert.encode('_', encoded);
                        continue;
                    }
                    encoded.append(name.charAt(i));
                    continue;
                }
                StiXMLConvert.encode(name.charAt(i), encoded);
                continue;
            }
            if (!XMLChar.isName(name.charAt(i))) {
                StiXMLConvert.encode(name.charAt(i), encoded);
                continue;
            }
            if (StiXMLConvert.needsEscaping(name, i)) {
                StiXMLConvert.encode('_', encoded);
                continue;
            }
            encoded.append(name.charAt(i));
        }
        return encoded.toString();
    }

    public static String decode(String name) {
        if (name.indexOf("_x") < 0) {
            return name;
        }
        StringBuffer decoded = new StringBuffer();
        Matcher m = ENCODE_PATTERN.matcher(name);
        while (m.find()) {
            char ch = (char)Integer.parseInt(m.group().substring(2, 6), 16);
            if (ch == '$' || ch == '\\') {
                m.appendReplacement(decoded, "\\" + ch);
                continue;
            }
            m.appendReplacement(decoded, Character.toString(ch));
        }
        m.appendTail(decoded);
        return decoded.toString();
    }

    private static void encode(char c, StringBuffer b) {
        b.append("_x");
        String hex = Integer.toHexString(c);
        b.append(PADDING, 0, 4 - hex.length());
        b.append(hex);
        b.append(LINE);
    }

    private static boolean needsEscaping(String name, int location) throws ArrayIndexOutOfBoundsException {
        if (name.charAt(location) == '_' && name.length() >= location + 6) {
            return name.charAt(location + 1) == 'x' && HEX_DIGITS.indexOf(name.charAt(location + 2)) != -1 && HEX_DIGITS.indexOf(name.charAt(location + 3)) != -1 && HEX_DIGITS.indexOf(name.charAt(location + 4)) != -1 && HEX_DIGITS.indexOf(name.charAt(location + 5)) != -1;
        }
        return false;
    }
}

