/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.system;

import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.system.StiConverterDateFormatToJava;
import com.stimulsoft.base.system.StiTimeSpan;
import com.stimulsoft.lib.utils.StiCalendarUtil;
import com.stimulsoft.lib.utils.StiDateUtil;
import com.stimulsoft.lib.utils.StiTypeConverter;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.xml.bind.DatatypeConverter;

public class StiDateTime
implements Cloneable,
Comparable<Object> {
    public static final String EN_DATE_TIME_FORMAT = "MM/dd/yyyy hh:mm:ss a";
    public static final String DATE_TIME_FORMAT = "MM/dd/yyyy hh:mm:ss a";
    public static final String TIME_FORMAT = "HH:mm:ss";
    private static final String[] DATE_FORMATS = new String[]{"dd0MM0yyyy", "yyyy0MM0dd", "MM0dd0yyyy", "MM0yyyy", "yyyy0MM", "yyyy0dd0MM", "dd0MM0yy", "yy0MM0dd", "MM0dd0yy", "MM0yy", "yy0MM", "yy0dd0MM"};
    private static final String[] TIME_FORMATS = new String[]{"HH:mm:ss", "HH:mm", "HH", ""};
    private static final Character[] DELIMITERS = new Character[]{Character.valueOf('-'), Character.valueOf('/'), Character.valueOf('.'), Character.valueOf(':')};
    private static final long[] DaysToMonth365 = new long[]{0L, 31L, 59L, 90L, 120L, 151L, 181L, 212L, 243L, 273L, 304L, 334L, 365L};
    private static final long[] DaysToMonth366 = new long[]{0L, 31L, 60L, 91L, 121L, 152L, 182L, 213L, 244L, 274L, 305L, 335L, 366L};
    private static int DatePartYear = 0;
    private static int DatePartDayOfYear = 1;
    private static int DatePartMonth = 2;
    private static int DatePartDay = 3;
    private static long TicksPerMillisecond = 1L;
    private static long TicksPerSecond = TicksPerMillisecond * 1000L;
    private static long TicksPerMinute = TicksPerSecond * 60L;
    private static long TicksPerHour = TicksPerMinute * 60L;
    private static long TicksPerDay = TicksPerHour * 24L;
    private static long MillisPerSecond = 1000L;
    private static long MillisPerMinute = MillisPerSecond * 60L;
    private static long MillisPerHour = MillisPerMinute * 60L;
    private static long MillisPerDay = MillisPerHour * 24L;
    private static long DaysPerYear = 365L;
    private static long DaysPer4Years = DaysPerYear * 4L + 1L;
    private static long DaysPer100Years = DaysPer4Years * 25L - 1L;
    private static long DaysPer400Years = DaysPer100Years * 4L + 1L;
    private static long DaysTo10000 = DaysPer400Years * 25L - 366L;
    private static long MaxMillis = DaysTo10000 * MillisPerDay;
    static long MinTicks = 0L;
    static long MaxTicks = DaysTo10000 * TicksPerDay - 1L;
    public static StiDateTime ZERO = new StiDateTime();
    public static StiDateTime minValue = new StiDateTime();
    public static StiDateTime MinValue = new StiDateTime();
    public static StiDateTime MaxValue = new StiDateTime(new Date(Long.MAX_VALUE));
    private Calendar calendar;

    public StiDateTime() {
        this.calendar = new GregorianCalendar(0, 0, 0, 0, 0, 0);
    }

    public StiDateTime(Calendar date) {
        this.calendar = date;
    }

    public StiDateTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.calendar = calendar;
    }

    public StiDateTime(StiTimeSpan value) {
        this.setTimeSpan(value);
    }

    public static StiDateTime currentDate() {
        return new StiDateTime(Calendar.getInstance());
    }

    public static StiDateTime currentDateOnly() {
        StiDateTime result = new StiDateTime(Calendar.getInstance());
        result.set(11, 0);
        result.set(12, 0);
        result.set(13, 0);
        result.set(14, 0);
        return result;
    }

    public String toNetJsonString() {
        return "\\/Date(" + this.calendar.getTimeInMillis() + ")\\/";
    }

    public static StiDateTime fromNetJsonString(String jsonDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(Long.parseLong(jsonDate.replaceAll("\\D+", "")));
        return new StiDateTime(calendar);
    }

    public Calendar calendar() {
        return this.calendar;
    }

    public long getValue() {
        return this.getTicks();
    }

    public long getTicks() {
        return this.calendar.getTimeInMillis();
    }

    public static StiDateTime Parse(String from) {
        return StiDateTime.fromString(from);
    }

    public static StiDateTime fromString(String strFrom) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss a", Locale.ENGLISH);
            Date date = sdf.parse(strFrom);
            return new StiDateTime(date);
        }
        catch (Exception e) {
            try {
                Date date = StiDateTime.parseISO8601(strFrom);
                return new StiDateTime(date);
            }
            catch (Exception e2) {
                if (strFrom.contains("Date")) {
                    try {
                        int index;
                        Calendar cal = Calendar.getInstance();
                        String stValue = strFrom.toString();
                        stValue = stValue.substring(6, stValue.length() - 2);
                        long coeff = 1L;
                        if (stValue.startsWith("-")) {
                            stValue = stValue.substring(1);
                            coeff = -1L;
                        }
                        if ((index = stValue.indexOf("-") + stValue.indexOf("+")) == -2) {
                            cal.setTimeInMillis(Long.parseLong(stValue) + 21600000L);
                        } else {
                            cal.setTimeInMillis(Long.parseLong(stValue.substring(0, (index == -2 ? stValue.length() - 1 : index) + 1)) * coeff);
                            cal.set(15, (Integer.parseInt(stValue.substring(index + 3, index + 4)) * 60 + Integer.parseInt(stValue.substring(index + 4, index + 5))) * 60 * 1000);
                        }
                        JSONObject.dateFormat.format(cal.getTime());
                        return new StiDateTime(cal);
                    }
                    catch (Exception e22) {
                        // empty catch block
                    }
                }
                for (String timeFormat : TIME_FORMATS) {
                    for (Character delimiter : DELIMITERS) {
                        for (String dateFormat : DATE_FORMATS) {
                            try {
                                String fmt = dateFormat.replace('0', delimiter.charValue()) + (strFrom.indexOf("T") >= 0 ? "'T'" : "") + (timeFormat.length() > 0 && strFrom.indexOf("T") < 0 ? " " : "") + timeFormat;
                                if (fmt.length() != strFrom.length()) continue;
                                SimpleDateFormat sdf = new SimpleDateFormat(fmt);
                                sdf.setLenient(false);
                                Date date = sdf.parse(strFrom);
                                return new StiDateTime(date);
                            }
                            catch (Exception e23) {
                                // empty catch block
                            }
                        }
                    }
                }
                for (Locale locale : Locale.getAvailableLocales()) {
                    try {
                        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss a", locale);
                        Date date = sdf.parse(strFrom);
                        return new StiDateTime(date);
                    }
                    catch (Exception e24) {
                    }
                }
                throw new RuntimeException(e);
            }
        }
    }

    public static Date parseISO8601(String input) throws ParseException {
        String input2;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
        if (input.endsWith("Z")) {
            input2 = input.substring(0, input.length() - 1) + "GMT-00:00";
        } else {
            int inset = 6;
            String s0 = input.substring(0, input.length() - inset);
            String s1 = input.substring(input.length() - inset, input.length());
            input2 = s0 + "GMT" + s1;
        }
        try {
            return df.parse(input2);
        }
        catch (Exception exception) {
            return DatatypeConverter.parseDateTime((String)input).getTime();
        }
    }

    public String toString() {
        return this.toString("MM/dd/yyyy hh:mm:ss a");
    }

    public String toString(String format) {
        return this.toString(format, null);
    }

    public String toString(String format, Locale locale) {
        return this.format(format, locale);
    }

    public String format(String format) {
        return this.format(format, null);
    }

    public String format(String format, Locale locale) {
        if (StiValidationUtil.isNotEmpty((String)format)) {
            DateFormat df = StiConverterDateFormatToJava.getDateFormat(format, locale);
            return this.format(df);
        }
        return this.toString();
    }

    public String format(DateFormat df) {
        String result = df.format(this.calendar.getTime());
        if (result != null) {
            result = result.replaceAll("\\\\", "");
        }
        return result;
    }

    public String formatEN() {
        return StiDateUtil.format((Date)this.calendar.getTime(), (String)StiDateUtil.DEFAULT_DATE_PATTERN_EN);
    }

    public String formatEnDateTime() {
        return StiDateUtil.format((Date)this.calendar.getTime(), (String)"MM/dd/yyyy hh:mm:ss a");
    }

    public Date getTime() {
        return this.calendar.getTime();
    }

    public long getTimeInMillis() {
        return this.calendar.getTimeInMillis();
    }

    public void set(int field, int value) {
        this.calendar.set(field, value);
    }

    public void set(int year, int month, int date) {
        this.calendar.set(year, month, date);
    }

    public void setTimeSpan(StiTimeSpan value) {
        this.calendar = Calendar.getInstance();
        this.calendar.set(11, value.getHours());
        this.calendar.set(12, value.getMinutes());
        this.calendar.set(13, value.getSeconds());
    }

    public void setTime(Date date) {
        this.calendar.setTime(date);
    }

    public void setTime(Calendar calendar) {
        this.calendar = calendar;
    }

    public void add(int field, int amount) {
        this.calendar.add(field, amount);
    }

    private StiDateTime add(double value, long scale) {
        long millis = (long)(value * (double)scale + (value >= 0.0 ? 0.5 : -0.5));
        if (millis <= -MaxMillis || millis >= MaxMillis) {
            throw new IndexOutOfBoundsException("ArgumentOutOfRange_AddValue");
        }
        return this.addTicks(millis * TicksPerMillisecond);
    }

    public StiDateTime addTicks(long value) {
        long val;
        Calendar cal = (Calendar)this.calendar.clone();
        for (val = value; val >= 1000000000L; val -= 1000000000L) {
            cal.add(14, 1000000000);
        }
        while (val <= -1000000000L) {
            cal.add(14, -1000000000);
            val += 1000000000L;
        }
        cal.add(14, (int)val);
        return new StiDateTime(cal);
    }

    public StiDateTime addDays(double value) {
        return this.add(value, MillisPerDay);
    }

    public StiDateTime addHours(double value) {
        return this.add(value, MillisPerHour);
    }

    public StiDateTime addMilliseconds(double value) {
        return this.add(value, 1L);
    }

    public StiDateTime addMinutes(double value) {
        return this.add(value, MillisPerMinute);
    }

    public StiDateTime addMonths(int months) {
        if (months < -120000 || months > 120000) {
            throw new IndexOutOfBoundsException("months ArgumentOutOfRange_DateTimeBadMonths: " + months);
        }
        long y = this.getDatePart(DatePartYear);
        long m = this.getDatePart(DatePartMonth);
        long d = this.getDatePart(DatePartDay);
        long i = m - 1L + (long)months;
        if (i >= 0L) {
            m = i % 12L + 1L;
            y += i / 12L;
        } else {
            m = 12L + (i + 1L) % 12L;
            y += (i - 11L) / 12L;
        }
        if (y < 1L || y > 9999L) {
            throw new IndexOutOfBoundsException("months ArgumentOutOfRange_DateArithmetic");
        }
        long days = StiDateTime.daysInMonth((int)y, (int)m);
        if (d > days) {
            d = days;
        }
        return new StiDateTime(new Date(StiDateTime.dateToTicks((int)y, (int)m, (int)d) + this.calendar.getTime().getTime() % TicksPerDay));
    }

    public StiDateTime addSeconds(double value) {
        return this.add(value, MillisPerSecond);
    }

    public StiDateTime addYears(int value) {
        if (value < -10000 || value > 10000) {
            throw new IndexOutOfBoundsException("years ArgumentOutOfRange_DateTimeBadYears: " + value);
        }
        Calendar cal = (Calendar)this.calendar.clone();
        cal.add(1, value);
        return new StiDateTime(cal);
    }

    public static int daysInMonth(long year, long month) {
        if (month < 1L || month > 12L) {
            throw new IndexOutOfBoundsException("month ArgumentOutOfRange_Month: " + month);
        }
        long[] days = StiDateTime.isLeapYear(year) ? DaysToMonth366 : DaysToMonth365;
        return (int)days[(int)month] - (int)days[(int)month - 1];
    }

    public static boolean isLeapYear(long year) {
        if (year < 1L || year > 9999L) {
            throw new IndexOutOfBoundsException("year ArgumentOutOfRange_Year: " + year);
        }
        return year % 4L == 0L && (year % 100L != 0L || year % 400L == 0L);
    }

    private static long dateToTicks(int year, int month, int day) {
        if (year >= 1 && year <= 9999 && month >= 1 && month <= 12) {
            long[] days;
            long[] lArray = days = StiDateTime.isLeapYear(year) ? DaysToMonth366 : DaysToMonth365;
            if (day >= 1 && (long)day <= days[month] - days[month - 1]) {
                int y = year - 1;
                int n = y * 365 + y / 4 - y / 100 + y / 400 + (int)days[month - 1] + day - 1;
                return (long)n * TicksPerDay;
            }
        }
        throw new IndexOutOfBoundsException("ArgumentOutOfRange_BadYearMonthDay");
    }

    private long getDatePart(long part) {
        long y4;
        long y1;
        long y400;
        long y100;
        long ticks = this.calendar.getTime().getTime();
        long n = ticks / TicksPerDay;
        if ((y100 = (n -= (y400 = n / DaysPer400Years) * DaysPer400Years) / DaysPer100Years) == 4L) {
            y100 = 3L;
        }
        n -= y100 * DaysPer100Years;
        if ((y1 = (n -= (y4 = n / DaysPer4Years) * DaysPer4Years) / DaysPerYear) == 4L) {
            y1 = 3L;
        }
        if (part == (long)DatePartYear) {
            return y400 * 400L + y100 * 100L + y4 * 4L + y1 + 1L;
        }
        n -= y1 * DaysPerYear;
        if (part == (long)DatePartDayOfYear) {
            return n + 1L;
        }
        boolean leapYear = y1 == 3L && (y4 != 24L || y100 == 3L);
        long[] days = leapYear ? DaysToMonth366 : DaysToMonth365;
        long m = n >> 6;
        while (n >= days[(int)m]) {
            ++m;
        }
        if (part == (long)DatePartMonth) {
            return m;
        }
        return n - days[(int)m - 1] + 1L;
    }

    public int get(int field) {
        return this.calendar.get(field);
    }

    public int getActualMaximum(int field) {
        return this.calendar.getActualMaximum(field);
    }

    public StiDateTime clone() {
        try {
            StiDateTime result = (StiDateTime)super.clone();
            result.setTime((Calendar)this.calendar.clone());
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String format() {
        return StiTypeConverter.calendarToString((Object)this.calendar);
    }

    public StiTimeSpan subtract(StiDateTime subtrahend) {
        return new StiTimeSpan(StiCalendarUtil.subtract((Calendar)this.calendar, (Calendar)subtrahend.calendar));
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof Calendar) {
            return this.calendar.compareTo((Calendar)o);
        }
        if (o instanceof StiDateTime) {
            return this.calendar.compareTo(((StiDateTime)o).calendar);
        }
        if (o instanceof String) {
            return this.calendar.compareTo(this.tryParse((String)((String)o)).calendar);
        }
        throw new IllegalArgumentException("Illegal class " + o.getClass());
    }

    private StiDateTime tryParse(String value) {
        ArrayList<String> formats = new ArrayList<String>();
        formats.add("MM/dd/yyyy hh:mm:ss a");
        formats.add(StiDateUtil.DEFAULT_DATE_TIME_PATTERN);
        formats.add(StiDateUtil.DEFAULT_DATE_PATTERN);
        formats.add(StiDateUtil.DEFAULT_DATE_PATTERN_EN);
        formats.add(TIME_FORMAT);
        formats.add(TIME_FORMAT);
        for (String format : formats) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                Date date = sdf.parse(value);
                return new StiDateTime(date);
            }
            catch (Exception e) {
            }
        }
        throw new IllegalArgumentException("Illegal datetime format " + value);
    }

    public static StiDateTime valueOf(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Object is null ");
        }
        if (o instanceof StiDateTime) {
            return (StiDateTime)o;
        }
        if (o instanceof Calendar) {
            return new StiDateTime((Calendar)o);
        }
        if (o instanceof Date) {
            return new StiDateTime((Date)o);
        }
        throw new IllegalArgumentException("Illegal class " + o.getClass());
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof StiDateTime && ((StiDateTime)obj).calendar.equals(this.calendar);
    }

    public int year() {
        return this.calendar.get(1);
    }

    public int month() {
        return this.calendar.get(2) + 1;
    }

    public int day() {
        return this.calendar.get(5);
    }
}

