/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.utils;

import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import sun.font.CompositeFont;
import sun.font.Font2D;
import sun.font.FontManager;
import sun.font.PhysicalFont;

public class StiFontHelper {
    public static byte[] getFontData(Font font) throws IOException, IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException {
        File file = StiFontHelper.getFontFile(font);
        FileInputStream fin = new FileInputStream(file);
        byte[] result = new byte[(int)file.length()];
        fin.read(result);
        return result;
    }

    public static File getFontFile(Font font) throws IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException {
        Object fontManager;
        Object f2d = null;
        Class[] argTypes = new Class[]{String.class, Integer.TYPE, Integer.TYPE};
        try {
            Class<?> manager = Class.forName("sun.font.FontManagerFactory");
            Method managerInstance = manager.getDeclaredMethod("getInstance", new Class[0]);
            managerInstance.setAccessible(true);
            fontManager = managerInstance.invoke(null, new Object[0]);
            Method findFont2D = fontManager.getClass().getMethod("findFont2D", argTypes);
            findFont2D.setAccessible(true);
            Font2D font2D = (Font2D)findFont2D.invoke(fontManager, font.getFontName(), font.getStyle(), 2);
            f2d = font2D.handle.font2D;
        }
        catch (Exception e) {
            try {
                Class<?> manager = Class.forName("sun.font.FontManager");
                fontManager = (FontManager)manager.newInstance();
                f2d = fontManager.findFont2D((String)font.getFontName(), (int)font.getStyle(), (int)2).handle.font2D;
            }
            catch (Exception e2) {
            }
            catch (IncompatibleClassChangeError i1) {
                try {
                    Class<?> manager = Class.forName("sun.font.FontManager");
                    Method findMethod = manager.getMethod("findFont2D", argTypes);
                    Font2D font2D = (Font2D)findMethod.invoke(null, font.getFontName(), font.getStyle(), 2);
                    f2d = font2D.handle.font2D;
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        try {
            return new File(StiFontHelper.getPlatName(f2d));
        }
        catch (Exception e) {
            if (f2d.getClass().getName().equalsIgnoreCase("sun.font.CFont")) {
                String platName = StiFontHelper.getPlatName((Font2D)f2d);
                return new File(platName);
            }
            CompositeFont pf = (CompositeFont)f2d;
            String platName = StiFontHelper.getPlatName(pf.getSlotFont(pf.getNumSlots() - 1));
            return new File(platName);
        }
    }

    private static String getPlatName(Font2D f2d) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field platName = PhysicalFont.class.getDeclaredField("platName");
        platName.setAccessible(true);
        String fontPath = (String)platName.get(f2d);
        platName.setAccessible(false);
        return fontPath;
    }
}

