/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.utils;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class StiMath {
    private static DecimalFormat DF = new DecimalFormat("#.##", new DecimalFormatSymbols(Locale.US));

    private StiMath() {
    }

    public static double round(Double value, Double digits) {
        Integer minus = value < 0.0 ? -1 : 1;
        if (minus < 0) {
            value = Math.abs(value);
        }
        digits = Math.pow(10.0, digits);
        return (double)Math.round(value * digits) / digits * (double)minus.intValue();
    }

    public static double round(double value, int digits) {
        return StiMath.round((Double)value, Double.valueOf(digits));
    }

    public static String roundS(double value, int digits) {
        return DF.format(StiMath.round((Double)value, Double.valueOf(digits)));
    }

    public static double round(float value, int digits) {
        return StiMath.round(Double.valueOf(value), Double.valueOf(digits));
    }

    public static int roundUp(Double value) {
        return (double)value.intValue() == value ? value.intValue() : value.intValue() + 1;
    }

    public static int roundDown(Double value) {
        return value.intValue();
    }

    public static double inscribe(double value, double min, double max) {
        return Math.max(min, Math.min(value, max));
    }
}

