/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.base.utils;

import com.stimulsoft.base.utils.StiOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public class StiOutputStreamWriter
extends OutputStreamWriter {
    private long position;
    private long lastFilePos;
    private StiOutputStream fileOutputStream;

    public StiOutputStreamWriter(OutputStream out, Charset cs) {
        super(out, cs);
        if (out instanceof StiOutputStream) {
            this.fileOutputStream = (StiOutputStream)out;
        }
    }

    public StiOutputStreamWriter(OutputStream out, CharsetEncoder enc) {
        super(out, enc);
    }

    public StiOutputStreamWriter(OutputStream out, String charsetName) throws UnsupportedEncodingException {
        super(out, charsetName);
    }

    public StiOutputStreamWriter(OutputStream out) {
        super(out);
    }

    public void writeLine(String st) throws IOException {
        this.write(st + "\r\n");
    }

    public void writeLine(String st, Object ... args) throws IOException {
        this.write(String.format(st, args) + "\r\n");
    }

    public void write(String st, Object ... args) throws IOException {
        this.write(this.getStr(String.format(st, args)));
    }

    @Override
    public void write(int c) throws IOException {
        super.write(c);
        this.position += 3L;
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        super.write(str, off, len);
        this.position += (long)len;
    }

    @Override
    public void write(String str) throws IOException {
        super.write(str);
    }

    private String getStr(String str) {
        this.position += (long)str.getBytes().length;
        return str;
    }

    public long getPosition() {
        return this.position;
    }

    public void incPosition(int value) {
        this.position += (long)value;
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        if (this.fileOutputStream != null) {
            this.position += this.fileOutputStream.getPosition() - this.lastFilePos;
            this.lastFilePos = this.fileOutputStream.getPosition();
        }
    }
}

