/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.lib.io;

import com.stimulsoft.lib.io.StiCloseUtil;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.lib.io.StiLineIterator;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class StiFileUtil {
    private static final String FILE_COULD_NOT_BE_CREATED = "File ''{0}'' could not be created";
    private static final String FILE_CANNOT_WRITTEN = "File ''{0}'' cannot be written to";
    private static final String FILE_IS_DIRECTORY = "File ''{0}'' exists but is a directory";
    private static final String FILE_CANNOT_READ = "File ''{0}'' cannot be read";
    private static final String FILE_DOES_NOT_EXIST = "File ''{0}'' does not exist";

    private StiFileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(File file, String data) throws IOException {
        FileOutputStream out = null;
        try {
            out = StiFileUtil.openOutputStream(file);
            StiIOUtil.write(data, out);
        }
        finally {
            StiCloseUtil.close((Closeable)out);
        }
    }

    public static FileOutputStream openOutputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException(MessageFormat.format(FILE_IS_DIRECTORY, file));
            }
            if (StiValidationUtil.isFalse(file.canWrite())) {
                throw new IOException(MessageFormat.format(FILE_CANNOT_WRITTEN, file));
            }
        } else {
            File parent = file.getParentFile();
            if (parent != null && StiValidationUtil.isFalse(parent.exists()) && StiValidationUtil.isFalse(parent.mkdirs())) {
                throw new IOException(MessageFormat.format(FILE_COULD_NOT_BE_CREATED, file));
            }
        }
        return new FileOutputStream(file);
    }

    public static InputStream openInputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException(MessageFormat.format(FILE_IS_DIRECTORY, file));
            }
            if (StiValidationUtil.isFalse(file.canRead())) {
                throw new IOException(MessageFormat.format(FILE_CANNOT_READ, file));
            }
        } else {
            throw new FileNotFoundException(MessageFormat.format(FILE_DOES_NOT_EXIST, file));
        }
        return new BufferedInputStream(new FileInputStream(file));
    }

    public static Iterator<File> iterateFiles(File directory, String[] extensions, boolean recursive) {
        return StiFileUtil.listFiles(directory, extensions, recursive).iterator();
    }

    private static Collection<File> listFiles(File directory, final String[] extensions, boolean recursive) {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                for (int i = 0; i < extensions.length; ++i) {
                    if (!StiStringUtil.checkEndsWith(name, "." + extensions[i])) continue;
                    return true;
                }
                return false;
            }
        };
        Object[] listFiles = directory.listFiles(filter);
        return StiValidationUtil.isNotEmpty(listFiles) ? Arrays.asList(listFiles) : new ArrayList<File>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyInputStreamToFile(InputStream source, File destination) throws IOException {
        try {
            FileOutputStream output = StiFileUtil.openOutputStream(destination);
            try {
                StiIOUtil.copy(source, output);
            }
            finally {
                StiCloseUtil.close((Closeable)output);
            }
        }
        finally {
            StiCloseUtil.close((Closeable)source);
        }
    }

    public static StiLineIterator lineIterator(File file) throws IOException {
        InputStream input = null;
        try {
            input = StiFileUtil.openInputStream(file);
            return StiIOUtil.lineIterator(input);
        }
        catch (IOException e) {
            StiCloseUtil.close((Closeable)input);
            throw e;
        }
        catch (RuntimeException e) {
            StiCloseUtil.close((Closeable)input);
            throw e;
        }
    }

    public static InputStream removeUtf8BOM(InputStream inputStream) {
        try {
            PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 3);
            byte[] bom = new byte[3];
            if (pushbackInputStream.read(bom) != -1 && (bom[0] != -17 || bom[1] != -69 || bom[2] != -65)) {
                pushbackInputStream.unread(bom);
            }
            return pushbackInputStream;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(File file) throws IOException {
        InputStream in = null;
        try {
            in = StiFileUtil.openInputStream(file);
            String string = StiIOUtil.toString(in);
            return string;
        }
        finally {
            StiCloseUtil.close((Closeable)in);
        }
    }

    public static void checkReadFile(File file) throws IOException {
        StiFileUtil.checkFile(file, true, false);
    }

    public static void checkWrittenFile(File file) throws IOException {
        StiFileUtil.checkFile(file, false, true);
    }

    public static void checkFile(File file, boolean needRead, boolean needWritten) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException(MessageFormat.format(FILE_IS_DIRECTORY, file));
            }
            if (needRead && StiValidationUtil.isFalse(file.canRead())) {
                throw new IOException(MessageFormat.format(FILE_CANNOT_READ, file));
            }
            if (needWritten && StiValidationUtil.isFalse(file.canWrite())) {
                throw new IOException(MessageFormat.format(FILE_CANNOT_WRITTEN, file));
            }
        } else {
            throw new FileNotFoundException(MessageFormat.format(FILE_DOES_NOT_EXIST, file));
        }
    }

    public static void copyFolder(File src, File dest) throws IOException {
        if (src.isDirectory()) {
            String[] files;
            if (!dest.exists()) {
                dest.mkdir();
            }
            for (String file : files = src.list()) {
                File srcFile = new File(src, file);
                File destFile = new File(dest, file);
                StiFileUtil.copyFolder(srcFile, destFile);
            }
        } else {
            StiFileUtil.copyFileToFile(src, dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFileToFile(File src, File dest) throws IOException {
        FileInputStream source = null;
        FileOutputStream output = null;
        try {
            source = new FileInputStream(src);
            output = new FileOutputStream(dest);
            try {
                StiIOUtil.copy(source, output);
            }
            finally {
                StiCloseUtil.close((Closeable)output);
            }
        }
        catch (Throwable throwable) {
            StiCloseUtil.close(source);
            StiCloseUtil.close(output);
            throw throwable;
        }
        StiCloseUtil.close((Closeable)source);
        StiCloseUtil.close((Closeable)output);
    }
}

