/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.lib.utils;

import com.stimulsoft.lib.commoninterface.IStiName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Logger;

public class StiCollectionsUtil {
    private static final Logger LOG = Logger.getLogger(StiCollectionsUtil.class.getName());
    private static final Comparator<IStiName> BY_NAME = new Comparator<IStiName>(){

        @Override
        public int compare(IStiName value1, IStiName value2) {
            return value1.getName().compareTo(value2.getName());
        }
    };

    public static <T extends IStiName> T getElement(ArrayList<T> collection, String name, Class<? extends T> classElement) {
        return StiCollectionsUtil.getElement(collection, name, classElement, true);
    }

    public static <T extends IStiName> T getElement(ArrayList<T> collection, String name, Class<? extends T> classElement, boolean showWarning) {
        ArrayList collectionForFind = (ArrayList)collection.clone();
        int index = StiCollectionsUtil.getIndex(collectionForFind, name, classElement);
        if (index > -1) {
            return (T)((IStiName)collectionForFind.get(index));
        }
        if (showWarning) {
            LOG.warning("Element named '" + name + "' missing");
        }
        return null;
    }

    public static <T extends IStiName> T getElementOrNull(ArrayList<T> collection, String name, Class<? extends T> classElement) {
        ArrayList collectionForFind = (ArrayList)collection.clone();
        int index = StiCollectionsUtil.getIndex(collectionForFind, name, classElement);
        if (index > -1) {
            return (T)((IStiName)collectionForFind.get(index));
        }
        return null;
    }

    public static <T extends IStiName> int getIndex(ArrayList<T> collection, String name, Class<? extends T> classElement) {
        IStiName keyInstance;
        StiCollectionsUtil.sortByName(collection);
        try {
            keyInstance = (IStiName)classElement.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create element '" + classElement + "' maybe no constructor or class abstract");
        }
        keyInstance.setName(name);
        return Collections.binarySearch(collection, keyInstance, BY_NAME);
    }

    public static <T extends IStiName> boolean contains(ArrayList<T> collection, String name, Class<? extends T> classElement) {
        ArrayList collectionForFind = (ArrayList)collection.clone();
        int index = StiCollectionsUtil.getIndex(collectionForFind, name, classElement);
        return index > -1;
    }

    public static <T extends IStiName> void sortByName(ArrayList<T> collection) {
        Collections.sort(collection, BY_NAME);
    }
}

