/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.lib.utils;

import com.stimulsoft.lib.utils.StiDateUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public final class StiCalendarUtil {
    private StiCalendarUtil() {
    }

    public static Calendar now() {
        return Calendar.getInstance();
    }

    public static Calendar calendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static Calendar parseQuietly(String date, String pattern) {
        try {
            return StiCalendarUtil.calendar(StiDateUtil.parse(date, pattern));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Calendar parseQuietly(String date) {
        try {
            return StiCalendarUtil.calendar(StiDateUtil.parse(date));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Calendar parseTimeQuietly(String date) {
        return StiCalendarUtil.parseQuietly(date, "HH:mm:ss");
    }

    public static String format(Calendar calendar, String pattern) {
        return StiCalendarUtil.format(calendar, pattern, Locale.ENGLISH);
    }

    public static String format(Calendar calendar, String pattern, Locale locale) {
        return StiDateUtil.format(calendar.getTime(), pattern, locale);
    }

    public static String formatEN(Calendar calendar) {
        return StiDateUtil.format(calendar.getTime(), StiDateUtil.DEFAULT_DATE_PATTERN_EN, Locale.ENGLISH);
    }

    public static String format(Calendar calendar) {
        return StiDateUtil.format(calendar.getTime());
    }

    public static String formatTime(Calendar date) {
        return StiDateUtil.formatTime(date.getTime());
    }

    public static Calendar dateLo(String date) {
        return StiCalendarUtil.parseQuietly(date);
    }

    public static Calendar dateHi(String date) {
        Calendar calendar = StiCalendarUtil.parseQuietly(date);
        calendar.add(5, 1);
        return calendar;
    }

    public static void synchronizeByFields(Calendar date1, Calendar date2, int ... fields) {
        if (date1 == null || date2 == null) {
            return;
        }
        for (int field : fields) {
            date1.set(field, date2.get(field));
        }
    }

    public static long getTimeIntervalInMillis(Calendar dateFrom, Calendar dateTo) {
        return dateTo.getTimeInMillis() - dateFrom.getTimeInMillis();
    }

    public static long subtract(Calendar dateTime1, Calendar dateTime2) {
        return dateTime1.getTimeInMillis() - dateTime2.getTimeInMillis();
    }

    public static Calendar create(int year, int month, int date) {
        return new GregorianCalendar(year, month - 1, date);
    }
}

