/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.lib.utils;

import com.stimulsoft.lib.utils.StiValidationUtil;
import java.lang.ref.SoftReference;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class StiDateUtil {
    public static String DEFAULT_DATE_PATTERN = "dd.MM.yyyy";
    public static String DEFAULT_DATE_PATTERN_EN = "yyyy:MM:dd";
    public static String DEFAULT_DATE_TIME_PATTERN = "dd.MM.yyyy HH:mm:ss";
    public static final String DEFAULT_TIME_PATTERN = "HH:mm:ss";
    private static final Locale LOCALE = Locale.ENGLISH;

    private StiDateUtil() {
    }

    public static Date now() {
        return new Date();
    }

    public static Date parse(String date) throws ParseException {
        return StiDateUtil.parse(date, DEFAULT_DATE_PATTERN);
    }

    public static Date parseQuietly(String date) {
        try {
            return StiDateUtil.parse(date, DEFAULT_DATE_PATTERN);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date parse(String date, String pattern) throws ParseException {
        return StiDateUtil.parse(date, DateFormatHolder.getFormat(pattern));
    }

    public static Date parseQuietly(String date, String pattern) {
        try {
            return StiDateUtil.parse(date, pattern);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Date parse(String date, DateFormat format) throws ParseException {
        return format.parse(date);
    }

    public static String convert(String date, String patternFrom, String patternTo) {
        String result = StiDateUtil.convertQuietly(date, patternFrom, patternTo);
        if (result == null) {
            throw new IllegalArgumentException("Can't convert date: " + date + " from pattern: " + patternFrom + " to pattern: " + patternTo);
        }
        return result;
    }

    public static String convertQuietly(String date, String patternFrom, String patternTo) {
        if (StiValidationUtil.isEmpty(date) || StiValidationUtil.isEmpty(patternFrom) || StiValidationUtil.isEmpty(patternTo)) {
            return null;
        }
        try {
            SimpleDateFormat formatFrom = new SimpleDateFormat(patternFrom, LOCALE);
            formatFrom.setLenient(false);
            SimpleDateFormat formatTo = new SimpleDateFormat(patternTo, LOCALE);
            formatTo.setLenient(false);
            return formatTo.format(formatFrom.parse(date));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String format(Date date) {
        return StiDateUtil.format(date, DEFAULT_DATE_PATTERN);
    }

    public static String formatTime(Date date) {
        return StiDateUtil.format(date, DEFAULT_TIME_PATTERN);
    }

    public static String formatDateTime(Date date) {
        return StiDateUtil.format(date, DEFAULT_DATE_TIME_PATTERN);
    }

    public static String format(Date date, String pattern) {
        return StiDateUtil.format(date, pattern, Locale.ENGLISH);
    }

    public static String format(Date date, String pattern, Locale locale) {
        String result = StiDateUtil.format(date, DateFormatHolder.getFormat(pattern, locale));
        if (result != null) {
            result = result.replaceAll("\\\\", "");
        }
        return result;
    }

    private static String format(Date date, DateFormat format) {
        return format.format(date);
    }

    public static boolean isDateValid(String date, String pattern) {
        if (date == null || pattern == null || pattern.length() <= 0) {
            return false;
        }
        try {
            StiDateUtil.parse(date, pattern);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    public static boolean isDateValid(String date, String pattern, boolean strict) {
        if (date == null || pattern == null || pattern.length() <= 0) {
            return false;
        }
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(pattern, LOCALE);
            formatter.setLenient(!strict);
            formatter.parse(date);
        }
        catch (ParseException e) {
            return false;
        }
        return !strict || strict && date.length() == pattern.length();
    }

    static final class DateFormatHolder {
        private static final ThreadLocal<SoftReference<Map<String, SimpleDateFormat>>> FORMATS = new ThreadLocal<SoftReference<Map<String, SimpleDateFormat>>>(){

            @Override
            protected SoftReference<Map<String, SimpleDateFormat>> initialValue() {
                return new SoftReference<Map<String, SimpleDateFormat>>(new HashMap());
            }
        };

        private DateFormatHolder() {
        }

        private static DateFormat getFormat(String pattern) {
            return DateFormatHolder.getFormat(pattern, LOCALE);
        }

        private static DateFormat getFormat(String pattern, Locale locale) {
            SimpleDateFormat format;
            SoftReference<Map<String, SimpleDateFormat>> ref = FORMATS.get();
            Map<String, SimpleDateFormat> formats = ref.get();
            if (formats == null) {
                formats = new HashMap<String, SimpleDateFormat>();
                FORMATS.set(new SoftReference<Map<String, SimpleDateFormat>>(formats));
            }
            if ((format = formats.get(pattern)) == null) {
                format = new SimpleDateFormat(pattern, locale);
                formats.put(pattern, format);
            }
            return format;
        }
    }
}

