/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.lib.utils;

import com.stimulsoft.lib.utils.StiCurrencyHelper;
import com.stimulsoft.lib.utils.StiDateUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StiStringUtil {
    public static final String EMPTY = "";
    private static final String[] _currencyTextFormatCurrencySymbols = new String[]{"p.", "$", "\u20ac", "\u00a2", "\u00a3", "\u00a4", "\u00a5", "\u20a3", "\u20a4", "\u20a7", "\u20aa", "\u20ab", "\u0e3f", "\u20a0", "\u20a1", "\u20a2", "\u20a5", "\u20a6", "\u20a8", "\u20a9", "\u20ab"};
    private static final Pattern Base64StringPattern = Pattern.compile("^[a-zA-Z0-9\\+/]*={0,3}$");
    public static final int INDEX_NOT_FOUND = -1;

    private StiStringUtil() {
    }

    public static String format(String format, Object arg) {
        return StiStringUtil.format(format, arg, Locale.ENGLISH, null);
    }

    public static String format(String format, Object arg, Locale locale, String culture) {
        if (StiValidationUtil.isNotNullOrEmpty(format) && format.startsWith("{") && format.endsWith("}")) {
            String result = EMPTY;
            int pos = 0;
            int posBegin = 0;
            while (pos < format.length()) {
                if (format.charAt(pos) == '{') {
                    while (format.charAt(pos) == '{') {
                        ++pos;
                    }
                    if (pos - 1 > posBegin) {
                        result = result + format.substring(posBegin, pos - 1);
                    }
                    posBegin = pos;
                    while (pos < format.length() && format.charAt(pos) != '}') {
                        ++pos;
                    }
                    if (pos > posBegin) {
                        result = result + StiStringUtil.parseFormatString(format.substring(posBegin, pos), arg, locale, culture);
                    }
                    posBegin = ++pos;
                    continue;
                }
                ++pos;
            }
            if (pos > posBegin) {
                result = result + format.substring(posBegin, pos);
            }
            return result;
        }
        return String.format(format, arg);
    }

    private static String parseFormatString(String formatString, Object value, Locale locale, String culture) {
        int pos;
        for (pos = 0; pos < formatString.length() && Character.isDigit(formatString.charAt(pos)); ++pos) {
        }
        if (pos > 0) {
            Character specifier = null;
            int precision = -1;
            String fullSpecifier = null;
            if (pos + 1 < formatString.length() && formatString.charAt(pos) == ':') {
                if (value instanceof Date) {
                    return StiDateUtil.format((Date)value, formatString.substring(pos + 1), locale);
                }
                specifier = Character.valueOf(formatString.charAt(pos + 1));
                fullSpecifier = formatString.substring(pos + 1);
                int pos2 = pos += 2;
                while (pos < formatString.length() && Character.isDigit(formatString.charAt(pos))) {
                    ++pos;
                }
                if (pos > pos2) {
                    precision = Integer.parseInt(formatString.substring(pos2, pos), 10);
                }
            }
            if (specifier == null) {
                return value.toString();
            }
            if (fullSpecifier.startsWith("dd")) {
                return value == null ? EMPTY : value.toString();
            }
            Double dValue = 0.0;
            try {
                dValue = Double.parseDouble(value.toString());
            }
            catch (Exception e) {
                // empty catch block
            }
            int currencyPositivePattern = 0;
            int currencyNegativePattern = 0;
            String currencySymbol = "$";
            String decimalSeparator = ".";
            String groupSeparator = " ";
            try {
                currencyPositivePattern = StiCurrencyHelper.getCurrencySymbol().get(culture).getCurrencyPositivePattern();
                currencyNegativePattern = StiCurrencyHelper.getCurrencySymbol().get(culture).getCurrencyNegativePattern();
                currencySymbol = StiCurrencyHelper.getCurrencySymbol().get(culture).getSymbol();
                decimalSeparator = StiCurrencyHelper.getCurrencySymbol().get(culture).getDecimalSeparator();
                groupSeparator = StiCurrencyHelper.getCurrencySymbol().get(culture).getGroupSeparator();
            }
            catch (Exception e) {
                // empty catch block
            }
            switch (specifier.charValue()) {
                case 'F': 
                case 'f': {
                    return StiStringUtil.formatNumber(value, precision, false, true, decimalSeparator, groupSeparator);
                }
                case 'N': 
                case 'n': {
                    return StiStringUtil.formatNumber(value, precision, true, true, decimalSeparator, groupSeparator);
                }
                case 'P': 
                case 'p': {
                    return StiStringUtil.formatNumber(Double.parseDouble(value.toString()) * 100.0, precision, true, true, decimalSeparator, groupSeparator) + "%";
                }
                case 'C': 
                case 'c': {
                    int pattern = dValue < 0.0 ? currencyNegativePattern : currencyPositivePattern;
                    String formattedNumber = StiStringUtil.formatNumber(value, precision, true, true, decimalSeparator, groupSeparator);
                    switch (pattern) {
                        case 0: {
                            return currencySymbol + formattedNumber;
                        }
                        case 1: {
                            return formattedNumber + currencySymbol;
                        }
                        case 2: {
                            return currencySymbol + " " + formattedNumber;
                        }
                        case 3: {
                            return formattedNumber + " " + currencySymbol;
                        }
                    }
                }
                case 'D': 
                case 'd': {
                    return (dValue < 0.0 ? "-" : EMPTY) + StiStringUtil.padLeft(String.valueOf(Math.abs(dValue)), precision, "0");
                }
                case 'X': {
                    return StiStringUtil.padLeft(Long.toString(Long.parseLong(value.toString()), 16).toUpperCase(), precision, "0");
                }
                case 'x': {
                    return StiStringUtil.padLeft(Long.toString(Long.parseLong(value.toString()), 16).toLowerCase(), precision, "0");
                }
            }
            if (fullSpecifier.indexOf("#") != -1 || fullSpecifier.indexOf("0") != -1 || fullSpecifier.indexOf(",") != -1 || fullSpecifier.indexOf(".") != -1) {
                return StiStringUtil.customFormat(value, fullSpecifier);
            }
            return value.toString();
        }
        return EMPTY;
    }

    private static String customFormat(Object arg, String format) {
        if (format == null || format.length() == 0) {
            return arg.toString();
        }
        if (arg instanceof Double || arg instanceof Long || arg instanceof Byte || arg instanceof Float || arg instanceof Integer || arg instanceof Byte || arg instanceof BigDecimal) {
            return StiStringUtil.customFormatNumber(Double.parseDouble(arg.toString()), format);
        }
        return arg.toString();
    }

    private static String customFormatNumber(Double arg, String format) {
        String javaPattern = EMPTY;
        for (int i = 0; i < format.length(); ++i) {
            char ch = format.charAt(i);
            if (ch != '#' && ch != '0' && ch != '.' && ch != ',') continue;
            javaPattern = javaPattern + ch;
        }
        DecimalFormat dc = new DecimalFormat(javaPattern);
        String res = dc.format(arg);
        StringBuilder sb = new StringBuilder(format);
        int fIndex = res.length() - 1;
        int lastFoundIndex = 0;
        for (int i = sb.length() - 1; i >= 0; --i) {
            char ch = sb.charAt(i);
            if (ch != '#' && ch != '0' && ch != '.' && ch != ',') continue;
            sb.replace(i, i + 1, fIndex >= 0 ? res.substring(fIndex, fIndex + 1) : EMPTY);
            --fIndex;
            lastFoundIndex = i;
        }
        if (fIndex >= 0) {
            sb.insert(lastFoundIndex, res.substring(0, fIndex + 1));
        }
        return sb.toString();
    }

    private static String formatNumber(Object arg1, int decimalDigits, boolean useGroupSeparator, boolean useSign, String decimalSeparator, String groupSeparator) {
        Double arg = Double.parseDouble(arg1.toString());
        int groupSize = 3;
        if (decimalDigits == -1) {
            decimalDigits = 2;
        }
        String result = EMPTY;
        Boolean sign = arg < 0.0;
        Double abs = Math.abs(arg);
        Long integerPart = abs.longValue();
        double decimalPower = Math.pow(10.0, decimalDigits);
        Long decimalPart = Math.round(StiStringUtil.round(abs - (double)integerPart.longValue(), Double.valueOf(decimalDigits)) * decimalPower);
        if ((double)decimalPart.longValue() >= decimalPower) {
            Long l = integerPart;
            Long l2 = integerPart = Long.valueOf(integerPart + 1L);
            decimalPart = 0L;
        }
        String integerStr = integerPart.toString();
        if (groupSize > 0 && useGroupSeparator) {
            int index;
            for (index = integerStr.length() - groupSize; index >= 0; index -= groupSize) {
                result = (index > 0 ? groupSeparator : EMPTY) + integerStr.substring(index, index + groupSize) + result;
            }
            if (index < 0) {
                result = integerStr.substring(0, index + groupSize) + result;
            }
        } else {
            result = integerStr;
        }
        if (decimalDigits > 0) {
            integerStr = decimalPart.toString();
            while (integerStr.length() < decimalDigits) {
                integerStr = "0" + integerStr;
            }
            result = result + decimalSeparator + integerStr;
        }
        if (useSign && sign.booleanValue()) {
            result = "-" + result;
        }
        return result;
    }

    public static String padLeft(String value, int length, String paddingChar) {
        int diff = length - value.length();
        if (diff > 0) {
            if (diff == 1) {
                return paddingChar + value;
            }
            return StiStringUtil.repeatString(paddingChar, diff) + value;
        }
        return value;
    }

    public static boolean checkEndsWith(String str, String end) {
        int endLen = end.length();
        return str.regionMatches(true, str.length() - endLen, end, 0, endLen);
    }

    public static String substringBetween(String str, String open, String close) {
        int end;
        if (str == null || open == null || close == null) {
            return null;
        }
        int start = str.indexOf(open);
        if (start != -1 && (end = str.indexOf(close, start + open.length())) != -1) {
            return str.substring(start + open.length(), end);
        }
        return null;
    }

    public static String substringAfterLast(String str, String separator) {
        if (StiValidationUtil.isEmpty(str)) {
            return str;
        }
        if (StiValidationUtil.isEmpty(separator)) {
            return EMPTY;
        }
        int pos = str.lastIndexOf(separator);
        if (pos == -1 || pos == str.length() - separator.length()) {
            return EMPTY;
        }
        return str.substring(pos + separator.length());
    }

    public static String join(Collection<?> collection, String separator) {
        return StiStringUtil.join(new ArrayList(collection), separator);
    }

    public static String join(Collection<?> collection, char separator) {
        return StiStringUtil.join(new ArrayList(collection), String.valueOf(separator));
    }

    public static String join(List<?> array, String separator) {
        if (array == null) {
            return null;
        }
        int startIndex = 0;
        int endIndex = array.size();
        int bufSize = endIndex - startIndex;
        if (bufSize <= 0) {
            return EMPTY;
        }
        StringBuilder buf = new StringBuilder(bufSize *= (array.get(startIndex) == null ? 16 : array.get(startIndex).toString().length()) + 1);
        for (int i = startIndex; i < endIndex; ++i) {
            if (i > startIndex) {
                buf.append(separator);
            }
            if (array.get(i) == null) continue;
            buf.append(array.get(i));
        }
        return buf.toString();
    }

    public static String removalBetween(String str, String open, String close) {
        return str.replace(open + ".*" + close, EMPTY);
    }

    public static boolean stringsEquals(String st1, String st2) {
        return StiValidationUtil.isNullOrEmpty(st1) && StiValidationUtil.isNullOrEmpty(st2) || st1 != null && st1.equals(st2);
    }

    public static String createCopies(char value, int repeatCount) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < repeatCount; ++i) {
            buff.append(value);
        }
        return buff.toString();
    }

    public static String repeatString(String value, int count) {
        String result = value;
        for (int i = 1; i < count; ++i) {
            result = result + value;
        }
        return result;
    }

    public static String toHex(int c, int width) {
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toHexString(c));
        while (sb.length() < width) {
            sb.insert(0, '0');
        }
        return sb.toString();
    }

    public static String escape(String str) {
        char[] letters = str.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < letters.length; ++i) {
            sb.append("\\u");
            sb.append(StiStringUtil.toHex(letters[i], 4));
        }
        return sb.toString();
    }

    @Deprecated
    public static String toTitleCase(String str) {
        String[] words = str.split(" ");
        String result = EMPTY;
        for (String word : words) {
            result = result + Character.toTitleCase(word.charAt(0)) + word.substring(1);
        }
        return result;
    }

    public static double round(Double value, Double digits) {
        Integer minus = value < 0.0 ? -1 : 1;
        if (minus < 0) {
            value = Math.abs(value);
        }
        digits = Math.pow(10.0, digits);
        return (double)Math.round(value * digits) / digits * (double)minus.intValue();
    }

    public static String[] split(String text, String regex) {
        ArrayList<String> result = new ArrayList<String>();
        while (text.length() > 0) {
            int index = text.indexOf(regex);
            if (index >= 0) {
                result.add(text.substring(0, index));
                if ((text = text.substring(index + 1)).length() != 0) continue;
                result.add(EMPTY);
                continue;
            }
            result.add(text);
            text = EMPTY;
        }
        return result.toArray(new String[0]);
    }

    public static boolean isBase64String(String s) {
        s = s.trim();
        Matcher m = Base64StringPattern.matcher(s);
        return s.length() % 4 == 0 && m.matches();
    }
}

