/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.lib.utils;

import com.stimulsoft.lib.enums.StiTypeCode;
import com.stimulsoft.lib.utils.StiValidationUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class StiTypeConverter {
    private static final String DATE_TIME_FORMAT = "MM/dd/yyyy hh:mm:ss a";
    private static final DecimalFormat DOUBLE_FORMAT = new DecimalFormat("#.######");

    private StiTypeConverter() {
    }

    public static String booleanToString(Object value) {
        return StiTypeConverter.booleanToString(Boolean.valueOf(value.toString()));
    }

    public static String booleanToString(Boolean value) {
        return StiTypeConverter.booleanToString((boolean)value);
    }

    public static String booleanToString(boolean value) {
        return value ? "True" : "False";
    }

    public static boolean stringToBoolean(String value) {
        return value.equalsIgnoreCase("True");
    }

    public static String integerToString(Object value) {
        return value.toString();
    }

    public static int stringToInteger(String value) {
        return Integer.valueOf(value);
    }

    public static int stringToInt(String value) {
        return StiTypeConverter.stringToInteger(value);
    }

    public static String doubleToString(Object value) {
        return StiTypeConverter.numberToString(value);
    }

    private static String numberToString(Object value) {
        return DOUBLE_FORMAT.format(value).replace(",", ".");
    }

    public static double stringToDouble(String value) {
        value = value.trim();
        return Double.valueOf(value);
    }

    public static String floatToString(Object value) {
        return StiTypeConverter.numberToString(value);
    }

    public static float stringToFloat(String value) {
        return Float.valueOf(value).floatValue();
    }

    public static String calendarToString(Object value) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_TIME_FORMAT);
        return sdf.format(((Calendar)value).getTime());
    }

    public static Calendar stringToCalendar(String value) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_TIME_FORMAT);
            Date date = sdf.parse(value);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            return calendar;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte stringToByte(String value) {
        return Byte.valueOf(value);
    }

    public static String bigDecimalToString(BigDecimal value) {
        return StiTypeConverter.numberToString(value);
    }

    public static BigDecimal stringToBigDecimal(String decodeName) {
        return new BigDecimal(decodeName);
    }

    public static BigDecimal ToDecimal(Object par1) {
        return new BigDecimal(par1.toString());
    }

    public static BigDecimal ToDouble(Object par1) {
        return new BigDecimal(par1.toString());
    }

    public static Character ToChar(Object par1) {
        try {
            int keyCode = Integer.parseInt(par1.toString());
            return new Character((char)keyCode);
        }
        catch (Exception e) {
            return new Character(par1.toString().charAt(0));
        }
    }

    public static String ToString(Object object) {
        return object.toString();
    }

    public static Object ChangeType(Date avgDate, Class<Date> class1) {
        return null;
    }

    public static Object ChangeType(Calendar avgTime, Class<Calendar> class1) {
        return null;
    }

    public static Object ChangeType(BigDecimal max, Class<BigDecimal> class1) {
        return null;
    }

    public static Object changeType(String value, StiTypeCode typeCode) {
        switch (typeCode) {
            case Boolean: {
                return StiTypeConverter.stringToBoolean(value);
            }
            case Byte: 
            case SByte: {
                return StiTypeConverter.stringToByte(value);
            }
            case Char: {
                return StiValidationUtil.isNotNullOrEmpty(value) ? Character.valueOf(value.charAt(0)) : "";
            }
            case DateTime: {
                return StiTypeConverter.stringToCalendar(value);
            }
            case Decimal: {
                return Float.valueOf(StiTypeConverter.stringToFloat(value));
            }
            case Double: 
            case Number: 
            case Single: {
                return StiTypeConverter.stringToDouble(value);
            }
            case Int: {
                return StiTypeConverter.stringToInt(value);
            }
            case Int16: {
                return StiTypeConverter.stringToInteger(value);
            }
            case Int32: 
            case Int64: 
            case UInt: 
            case UInt16: 
            case UInt32: 
            case UInt64: {
                return StiTypeConverter.parseLong(value);
            }
        }
        return value;
    }

    public static boolean isInegral(Object par) {
        int cat = StiTypeConverter.getCategoryClass(par);
        return cat >= 4 && cat <= 7 || cat == 2 && (float)((BigDecimal)par).intValue() == ((BigDecimal)par).floatValue();
    }

    public static int getCategoryClass(Object par) {
        if (par == null) {
            return -1;
        }
        int category = 0;
        if (par instanceof String || par instanceof Character) {
            category = 1;
        } else if (par instanceof BigDecimal) {
            category = 2;
        } else if (par instanceof Double || par instanceof Float) {
            category = 3;
        } else if (par instanceof Long) {
            category = 4;
        } else if (par instanceof Long) {
            category = 5;
        } else if (par instanceof Integer || par instanceof Short || par instanceof Byte) {
            category = 6;
        } else if (par instanceof Integer || par instanceof Short || par instanceof Byte) {
            category = 7;
        } else if (par instanceof Calendar) {
            category = 8;
        } else if (par instanceof Boolean) {
            category = 9;
        }
        if (par.getClass().getName().equals("com.stimulsoft.base.system.StiDateTime")) {
            category = 8;
        }
        if (par.getClass().getName().equals("com.stimulsoft.base.system.StiTimeSpan")) {
            category = 10;
        }
        return category;
    }

    public static long parseLong(Object value) {
        String svalue = value.toString();
        return Long.parseLong(svalue.endsWith(".0") ? svalue.substring(0, svalue.length() - 2) : svalue);
    }

    public static boolean parseBoolean(Object value) {
        return Boolean.parseBoolean(value.toString());
    }

    public static int parseInt(Object value) {
        String svalue = value.toString();
        return Integer.parseInt(svalue.endsWith(".0") ? svalue.substring(0, svalue.length() - 2) : svalue);
    }

    public static double parseDouble(Object value) {
        return Double.parseDouble(value.toString());
    }

    public static String parseString(Object value) {
        return String.valueOf(value);
    }

    public static void main(String[] args) {
        Float value = Float.valueOf(4.091f);
        DecimalFormat twoPlaces = new DecimalFormat("#.######");
        System.out.println(StiTypeConverter.floatToString(value) + "|" + twoPlaces.format(value));
    }
}

