/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report;

import com.stimulsoft.base.utils.StiDeflateHelper;
import com.stimulsoft.report.components.simplecomponents.StiImageHelper;
import com.stimulsoft.report.export.tools.StiColorImageFormat;
import com.stimulsoft.report.export.tools.StiImageFormat;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.CRC32;

public class StiImageCache {
    public ArrayList<BufferedImage> imageStore;
    private Map<Long, Integer> imageHashTable;
    private boolean useImageComparer = true;
    private boolean useImageCompression;
    private boolean useImageTransparency;
    private ArrayList<byte[]> imageMaskStore;
    private ArrayList<byte[]> deflateImages;
    private StiImageFormat imageSaveFormat = StiImageFormat.Bmp;
    private float imageQuality = 1.0f;
    private long usedMemoryCounter = 0L;
    public ArrayList<Integer> imageIndex;

    public StiImageCache(boolean useImageComparer) {
        this.init(useImageComparer, false, StiImageFormat.Bmp);
    }

    public StiImageCache(boolean useImageComparer, StiImageFormat imageFormat, float imageQuality) {
        this.init(useImageComparer, true, imageFormat);
        this.imageQuality = imageQuality;
    }

    public StiImageCache(boolean useImageComparer, StiImageFormat imageFormat, float imageQuality, boolean useImageTransparency) {
        this.init(useImageComparer, true, imageFormat);
        this.imageQuality = imageQuality;
        this.useImageTransparency = useImageTransparency;
    }

    private void init(boolean useImageComparer, boolean useImageCompression, StiImageFormat imageFormat) {
        this.imageStore = new ArrayList();
        this.imageHashTable = new HashMap<Long, Integer>();
        this.imageIndex = new ArrayList();
        this.imageMaskStore = new ArrayList();
        this.deflateImages = new ArrayList();
        this.useImageComparer = useImageComparer;
        this.useImageCompression = useImageCompression;
        this.imageSaveFormat = imageFormat;
    }

    public void clear() {
        this.imageStore.clear();
        this.imageStore = null;
        this.imageHashTable.clear();
        this.imageHashTable = null;
        this.imageIndex.clear();
        this.imageIndex = null;
        this.imageMaskStore.clear();
        this.imageMaskStore = null;
    }

    public int addImageInt(BufferedImage image) {
        return this.addImageInt(image, this.imageSaveFormat);
    }

    public int addImageInt(BufferedImage image, StiImageFormat imageFormat) {
        return this.addImageInt(image, imageFormat, StiColorImageFormat.Color);
    }

    public int addImageInt(BufferedImage image, StiColorImageFormat colorFormat) {
        return this.addImageInt(image, this.imageSaveFormat, colorFormat);
    }

    public int addImageInt(BufferedImage image, StiImageFormat imageFormat, StiColorImageFormat colorFormat) {
        byte[] bytes = null;
        byte[] mask = new byte[1];
        BufferedImage imageForMask = image;
        BufferedImage rgbImage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        rgbImage.createGraphics().drawImage(image, null, 0, 0);
        image = rgbImage;
        byte[] deflateImage = new byte[1];
        if ((this.useImageComparer || this.useImageCompression) && imageFormat == StiImageFormat.MemoryBmp) {
            int posX;
            int posY;
            byte[] bufDeflate = null;
            if (colorFormat == StiColorImageFormat.Monochrome) {
                bufDeflate = new byte[image.getHeight() * ((image.getWidth() - 1) / 8 + 1) + 4];
                int posDeflate = 0;
                WritableRaster raster = image.getRaster();
                for (posY = 0; posY < image.getHeight(); ++posY) {
                    for (posX = 0; posX < image.getWidth(); posX += 8) {
                        bufDeflate[posDeflate] = this.getByte(raster, posX, posY);
                        ++posDeflate;
                    }
                }
            } else {
                bufDeflate = new byte[image.getHeight() * image.getWidth() * 3];
                WritableRaster raster = image.getRaster();
                int posDeflate = 0;
                for (posY = 0; posY < image.getHeight(); ++posY) {
                    for (posX = 0; posX < image.getWidth(); ++posX) {
                        bufDeflate[posDeflate + 0] = (byte)raster.getSample(posX, posY, 0);
                        bufDeflate[posDeflate + 1] = (byte)raster.getSample(posX, posY, 1);
                        bufDeflate[posDeflate + 2] = (byte)raster.getSample(posX, posY, 2);
                        posDeflate += 3;
                    }
                }
            }
            deflateImage = StiDeflateHelper.deflate((byte[])bufDeflate);
            bufDeflate = null;
        }
        long lngChecksum = 0L;
        if (this.useImageComparer) {
            try {
                bytes = StiImageHelper.imageToByteArray(imageForMask, StiImageFormat.Png);
                CRC32 checksum = new CRC32();
                checksum.update(bytes, 0, bytes.length);
                lngChecksum = checksum.getValue();
                this.usedMemoryCounter += (long)bytes.length;
                bytes = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        int imageIndex = 0;
        if (this.imageHashTable.containsKey(lngChecksum) && this.useImageComparer) {
            imageIndex = this.imageHashTable.get(lngChecksum);
        } else {
            WritableRaster alphaRaster = imageForMask.getAlphaRaster();
            if (this.useImageCompression && this.useImageTransparency && alphaRaster != null) {
                int pixelsDataCount2 = imageForMask.getWidth() * imageForMask.getHeight();
                byte[] pixelsData2 = new byte[pixelsDataCount2];
                boolean needMask = false;
                for (int y = 0; y < imageForMask.getHeight(); ++y) {
                    for (int x = 0; x < imageForMask.getWidth(); ++x) {
                        int data = alphaRaster.getSample(x, y, 0);
                        pixelsData2[y * imageForMask.getWidth() + x] = (byte)data;
                        if (data == 255) continue;
                        needMask = true;
                    }
                }
                if (needMask) {
                    mask = StiDeflateHelper.deflate((byte[])pixelsData2);
                }
                pixelsData2 = null;
                this.usedMemoryCounter += (long)pixelsDataCount2;
            }
            this.imageStore.add(image);
            this.imageMaskStore.add(mask);
            imageIndex = this.imageStore.indexOf(image);
            this.deflateImages.add(deflateImage);
            this.imageHashTable.put(lngChecksum, this.imageStore.indexOf(image));
        }
        this.imageIndex.add(imageIndex);
        mask = null;
        imageForMask = null;
        this.usedMemoryCounter = 0L;
        return imageIndex;
    }

    private byte getByte(WritableRaster raster, int x, int y) {
        int result = 0;
        for (int i = 0; i < 8; ++i) {
            if (raster.getWidth() > x + i) {
                result |= raster.getSample(x + i, y, 0) == 255 ? 1 : 0;
            }
            if (i == 7) continue;
            result <<= 1;
        }
        return (byte)result;
    }

    public int getImageStoreSize() {
        return this.imageStore != null ? this.imageStore.size() : 0;
    }

    public BufferedImage getImageByIndex(int index) {
        return this.imageStore != null && this.imageStore.size() > index ? this.imageStore.get(index) : null;
    }

    public byte[] getDeflateImage(int index) {
        return this.deflateImages != null && this.deflateImages.size() > index ? this.deflateImages.get(index) : null;
    }

    public float getImageQuality() {
        return this.imageQuality;
    }

    public ArrayList<Integer> getImageIndex() {
        return this.imageIndex;
    }

    public ArrayList<byte[]> getImageMaskStore() {
        return this.imageMaskStore;
    }
}

