/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report;

import com.stimulsoft.base.json.JSONArray;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.system.type.StiSystemTypeEnum;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiNameValidator;
import com.stimulsoft.report.dictionary.StiDataColumn;
import com.stimulsoft.report.dictionary.data.DataRow;
import com.stimulsoft.report.dictionary.data.DataSet;
import com.stimulsoft.report.dictionary.data.DataTable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public class StiJsonToDataSetConverter {
    private static DataSet dataSet;
    private static Hashtable<String, Integer> hashColumnIndex;

    public static DataSet getDataTable(Object token) throws JSONException {
        dataSet = new DataSet();
        StiJsonToDataSetConverter.parseJToken(dataSet, null, token, null);
        StiJsonToDataSetConverter.checkColumnType(dataSet);
        return dataSet;
    }

    public static DataSet getDataTable(InputStream is) throws JSONException, IOException {
        return StiJsonToDataSetConverter.getDataTable(new JSONObject(StiIOUtil.toString((InputStream)is)));
    }

    public static DataSet detDataTable(String text) throws JSONException {
        return StiJsonToDataSetConverter.getDataTable(new JSONObject(text));
    }

    public static void checkColumnType(DataSet dataSet) {
    }

    private static void parseJToken(DataSet dataSet, String tokenName, Object token, DataTable tableProperties) throws JSONException {
        StiJsonToDataSetConverter.parseJContainer(dataSet, tokenName, token, tableProperties);
    }

    private static void parseJContainer(DataSet dataSet, String tokenName, Object jContainer, DataTable tableProperties) throws JSONException {
        if (jContainer instanceof JSONArray) {
            StiJsonToDataSetConverter.parseJArray(dataSet, tokenName, (JSONArray)jContainer);
        } else if (jContainer instanceof JSONObject) {
            StiJsonToDataSetConverter.parseJObject(dataSet, tokenName, (JSONObject)jContainer);
        } else if (jContainer instanceof String) {
            StiJsonToDataSetConverter.parseJProperty(dataSet, tokenName, jContainer, tableProperties);
        }
    }

    private static void parseJArray(DataSet dataSet, String tokenName, JSONArray jArray) throws JSONException {
        block8: {
            DataTable table = StiJsonToDataSetConverter.tryParseArrayToTable(tokenName, jArray);
            if (table == null) break block8;
            if (jArray.length() > 1) {
                dataSet.getTables().add(table);
            } else if (jArray.length() > 1 && StiJsonToDataSetConverter.checkArrayForSimpleCreateTable(jArray)) {
                dataSet.getTables().add(table);
                for (int i = 0; i < jArray.length(); ++i) {
                    JSONArray childArray = jArray.getJSONArray(i);
                    while (table.getColumns().size() < childArray.length()) {
                        table.getColumns().add(new StiDataColumn());
                    }
                    DataRow row = table.NewRow();
                    for (int indexRowValue = 0; indexRowValue < childArray.length(); ++indexRowValue) {
                        row.setValue(indexRowValue, childArray.get(indexRowValue));
                    }
                    table.getRows().add(row);
                }
            } else {
                dataSet.getTables().add(table);
                for (int index = 0; index < jArray.length(); ++index) {
                    StiJsonToDataSetConverter.parseJToken(dataSet, jArray.getString(index), jArray.get(index), table);
                }
            }
        }
    }

    private static boolean checkArrayForSimpleCreateTable(JSONArray jArray) throws JSONException {
        for (int i = 0; i < jArray.length(); ++i) {
            if (jArray.get(i) instanceof JSONArray) continue;
            return false;
        }
        return true;
    }

    private static DataTable tryParseArrayToTable(String tokenName, JSONArray array) throws JSONException {
        hashColumnIndex.clear();
        DataTable table = new DataTable(StiValidationUtil.isNotNullOrEmpty((String)tokenName) ? tokenName : StiJsonToDataSetConverter.getTableName(dataSet));
        for (int i = 0; i < array.length(); ++i) {
            DataRow row;
            Object jObject = array.get(i);
            if (jObject instanceof JSONObject) {
                row = table.NewRow();
                JSONArray names = ((JSONObject)jObject).names();
                for (int j = 0; j < names.length(); ++j) {
                    Object toKen = ((JSONObject)jObject).get(names.getString(j));
                    String name = StiNameValidator.CorrectName(names.getString(j));
                    if (toKen instanceof JSONObject.Null) continue;
                    if (!table.getColumns().contains(name)) {
                        table.getColumns().add(new StiDataColumn(name, name, StiSystemTypeEnum.SystemString.getSystemType()));
                        hashColumnIndex.put(name, table.getColumns().getIndexByName(name));
                    }
                    row.setValue(name, ((JSONObject)jObject).get(names.getString(j)));
                }
            } else {
                return null;
            }
            table.getRows().add(row);
        }
        return table;
    }

    private static void parseJProperty(DataSet dataSet, String tokenName, Object jProperty, DataTable tableProperties) {
        if (tableProperties == null) {
            tableProperties = new DataTable(tokenName);
            dataSet.getTables().add(tableProperties);
            tableProperties.getColumns().add(new StiDataColumn("name", "name", StiSystemTypeEnum.SystemString.getSystemType()));
            tableProperties.getColumns().add(new StiDataColumn("value", "value", StiSystemTypeEnum.SystemString.getSystemType()));
        }
        DataRow row = tableProperties.NewRow();
        row.setValue("name", (Object)tokenName);
        row.setValue("value", jProperty);
        tableProperties.getRows().add(row);
    }

    private static void parseJObject(DataSet dataSet, String tokenName, JSONObject jObject) throws JSONException {
        DataTable tableProperties = new DataTable(StiValidationUtil.isNotNullOrEmpty((String)tokenName) ? tokenName : StiJsonToDataSetConverter.getTableName(dataSet));
        tableProperties.getColumns().add(new StiDataColumn("name", "name", StiSystemTypeEnum.SystemString.getSystemType()));
        tableProperties.getColumns().add(new StiDataColumn("value", "value", StiSystemTypeEnum.SystemString.getSystemType()));
        dataSet.getTables().add(tableProperties);
        if (jObject.names() != null) {
            for (int index = 0; index < jObject.names().length(); ++index) {
                StiJsonToDataSetConverter.parseJToken(dataSet, jObject.names().getString(index), jObject.get(jObject.names().getString(index)), tableProperties);
            }
        }
    }

    private static String getTableName(DataSet dataSet) {
        Integer s = 1;
        while (true) {
            boolean found = false;
            String tableName = "Table" + s.toString();
            for (DataTable table : dataSet.getTables()) {
                if (!tableName.equals(table.getName())) continue;
                found = true;
            }
            if (!found) {
                return tableName;
            }
            Integer n = s;
            Integer n2 = s = Integer.valueOf(s + 1);
        }
    }

    static {
        hashColumnIndex = new Hashtable();
    }
}

