/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report;

import com.stimulsoft.base.StiEncryption;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.serializing.StiDeserializationException;
import com.stimulsoft.base.serializing.StiDeserializerControler;
import com.stimulsoft.base.serializing.StiSerializerControler;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializable;
import com.stimulsoft.base.serializing.interfaceobject.IStiSerializableRef;
import com.stimulsoft.base.zip.StiGZipHelper;
import com.stimulsoft.lib.io.StiIOUtil;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.dictionary.StiResource;
import com.stimulsoft.report.dictionary.databases.StiResourcesCollection;
import com.stimulsoft.report.dictionary.enums.StiResourceType;
import com.stimulsoft.report.saveLoad.StiDocument;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.zip.GZIPOutputStream;
import org.xml.sax.SAXException;

public class StiSerializeManager {
    private StiSerializeManager() {
    }

    public static StiReport deserializeReport(File file) throws IOException, SAXException, StiDeserializationException {
        StiReport report = new StiReport();
        report.setIsSerializing(true);
        StiReport result = (StiReport)StiDeserializerControler.deserializeReport((File)file, (IStiSerializable)report);
        result.setIsRendered(true);
        result.setNeedsCompiling(false);
        report.setIsSerializing(false);
        report.loadFonts();
        report.applyStyles();
        report.correctFormatProperties();
        return result;
    }

    public static StiDocument deserializeDocument(File file) throws StiException {
        StiDocument result = (StiDocument)StiDeserializerControler.deserializeDocument((File)file, StiDocument.class);
        result.getReport().setIsRendered(true);
        result.getReport().setNeedsCompiling(false);
        result.getReport().loadDocumentFonts();
        return result;
    }

    public static StiReport deserializeReport(InputStream is) throws IOException, SAXException, StiDeserializationException {
        return StiSerializeManager.deserializeReport(is, null, false, null);
    }

    public static StiReport deserializeReport(InputStream is, String password) throws IOException, SAXException, StiDeserializationException {
        return StiSerializeManager.deserializeReport(is, null, false, password);
    }

    public static StiReport deserializeReport(InputStream is, Hashtable<String, Object> memoryStore) throws IOException, SAXException, StiDeserializationException {
        return StiSerializeManager.deserializeReport(is, memoryStore, false);
    }

    public static StiReport deserializeReport(InputStream is, Hashtable<String, Object> memoryStore, boolean enhanced) throws IOException, SAXException, StiDeserializationException {
        return StiSerializeManager.deserializeReport(is, memoryStore, enhanced, null);
    }

    public static StiReport deserializeReport(InputStream is, Hashtable<String, Object> memoryStore, boolean enhanced, String password) throws IOException, SAXException, StiDeserializationException {
        StiReport report = new StiReport();
        report.setIsSerializing(true);
        if (StiValidationUtil.isNotNullOrEmpty((String)password)) {
            try {
                byte[] encrypted = StiSerializeManager.unpack(is, password);
                is = new ByteArrayInputStream(encrypted);
            }
            catch (Exception e) {
                throw new StiDeserializationException(e.getMessage());
            }
        }
        StiReport result = (StiReport)StiDeserializerControler.deserializeReport((InputStream)is, (IStiSerializable)report, memoryStore, (Boolean)enhanced);
        result.setIsRendered(true);
        result.setNeedsCompiling(false);
        report.setIsSerializing(false);
        report.loadFonts();
        report.applyStyles();
        report.correctFormatProperties();
        return result;
    }

    public static StiDocument deserializeDocument(InputStream is) throws IOException, SAXException, StiDeserializationException {
        StiDocument result = (StiDocument)StiDeserializerControler.deserializeDocument((InputStream)is, StiDocument.class);
        result.getReport().setIsRendered(true);
        result.getReport().setNeedsCompiling(false);
        result.getReport().loadFonts();
        result.getReport().isDocument = true;
        return result;
    }

    public static void serializeDocument(StiReport report, File file) {
        StiSerializeManager.serializeDocument(report, file, false);
    }

    public static void serializeDocument(StiReport report, File file, boolean formatOutput) {
        StiDocument document = new StiDocument(report);
        StiSerializeManager.updateResources(document, report);
        StiSerializerControler.serializeDocument((IStiSerializableRef)document, (String)file.getAbsolutePath(), (boolean)formatOutput);
    }

    public static void serializeDocument(StiReport report, OutputStream outputStream) {
        StiSerializeManager.serializeDocument(report, outputStream, false);
    }

    public static void serializeDocument(StiReport report, OutputStream outputStream, boolean formatOutput) {
        StiDocument document = new StiDocument(report);
        StiSerializeManager.updateResources(document, report);
        StiSerializerControler.serializeDocument((IStiSerializableRef)document, (OutputStream)outputStream);
    }

    public static void serializeDocument(StiReport report, String isDocument, OutputStream outputStream) {
        StiDocument document = new StiDocument(report);
        StiSerializeManager.updateResources(document, report);
        StiSerializerControler.serializeDocument((IStiSerializableRef)document, (String)isDocument, (OutputStream)outputStream);
    }

    public static Hashtable<String, Object> serializeReport2(StiReport report, OutputStream outputStream) {
        return StiSerializeManager.serializeReport2(report, outputStream, false, false);
    }

    public static void serializeReport(StiReport report, OutputStream outputStream) {
        StiSerializeManager.serializeReport(report, outputStream, false);
    }

    public static Hashtable<String, Object> serializeReport2(StiReport report, OutputStream outputStream, boolean formatOutput, boolean enhanced) {
        return StiSerializerControler.serializeReport((IStiSerializableRef)report, (OutputStream)outputStream, (boolean)formatOutput, (boolean)enhanced);
    }

    public static void serializeReport(StiReport report, OutputStream outputStream, boolean formatOutput) {
        StiSerializerControler.serializeReport((IStiSerializableRef)report, (OutputStream)outputStream, (boolean)formatOutput, (boolean)false);
    }

    public static void serializeReport(StiReport report, OutputStream stream, String password) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(outputStream);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            StiSerializeManager.serializeReport(report, (OutputStream)bos, false);
            bos.close();
            gzipOutputStream.write(bos.toByteArray());
            gzipOutputStream.flush();
            gzipOutputStream.close();
            byte[] bytes = StiEncryption.encrypt((byte[])outputStream.toByteArray(), (String)password);
            byte[] dest = new byte[bytes.length + 3];
            dest[0] = 109;
            dest[1] = 114;
            dest[2] = 120;
            System.arraycopy(bytes, 0, dest, 3, bytes.length);
            stream.write(dest, 0, dest.length);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void serializeReportToJson(StiReport report, OutputStream stream, String password) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(outputStream);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            StiSerializeManager.serializeReportToJson(report, bos);
            bos.close();
            gzipOutputStream.write(bos.toByteArray());
            gzipOutputStream.flush();
            gzipOutputStream.close();
            byte[] bytes = StiEncryption.encrypt((byte[])outputStream.toByteArray(), (String)password);
            byte[] dest = new byte[bytes.length + 3];
            dest[0] = 109;
            dest[1] = 114;
            dest[2] = 120;
            System.arraycopy(bytes, 0, dest, 3, bytes.length);
            stream.write(dest, 0, dest.length);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void serializeReportToJson(StiReport report, OutputStream outputStream) throws JSONException, IOException {
        report.updateReportVersion();
        String jsonReport = report.saveToJsonInternal(StiJsonSaveMode.Report);
        StiIOUtil.write((String)jsonReport, (OutputStream)outputStream);
    }

    public static void serializeDocumentToJson(StiReport report, OutputStream outputStream) {
        try {
            report.updateReportVersion();
            String jsonReport = report.saveToJsonInternal(StiJsonSaveMode.Document);
            StiIOUtil.write((String)jsonReport, (OutputStream)outputStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static StiReport deserializeReportFromJson(InputStream inputStream) throws JSONException, IOException, ParseException, StiDeserializationException {
        return StiSerializeManager.deserializeReportFromJson(inputStream, null);
    }

    public static StiReport deserializeReportFromJson(InputStream inputStream, String password) throws JSONException, IOException, ParseException, StiDeserializationException {
        StiReport report = StiReport.newInstance();
        if (StiValidationUtil.isNotNullOrEmpty((String)password)) {
            try {
                byte[] encrypted = StiSerializeManager.unpack(inputStream, password);
                inputStream = new ByteArrayInputStream(encrypted);
            }
            catch (Exception e) {
                throw new StiDeserializationException(e.getMessage());
            }
        }
        report.loadFromJson(StiIOUtil.toString((InputStream)inputStream));
        report.setIsRendered(true);
        for (StiPage page : report.getRenderedPages()) {
            page.setReport(report);
            StiComponentsCollection comps = page.GetComponents();
            for (StiComponent comp : comps) {
                comp.setPage(page);
            }
        }
        report.correctFormatProperties();
        return report;
    }

    public static byte[] unpack(InputStream is, String password) throws Exception {
        byte[] data = StiIOUtil.toByteArray((InputStream)is);
        int[] dest = new int[data.length - 3];
        for (int i = 3; i < data.length; ++i) {
            dest[i - 3] = data[i] >= 0 ? data[i] : 256 + data[i];
        }
        dest = StiEncryption.decrypt((int[])dest, (String)password);
        try {
            byte[] dest2 = new byte[dest.length];
            for (int i = 0; i < dest.length; ++i) {
                dest2[i] = (byte)dest[i];
            }
            return StiGZipHelper.unpack((byte[])dest2);
        }
        catch (Exception ee) {
            if (StiOptions.Engine.logLevel >= 10) {
                ee.printStackTrace();
            }
            throw new Exception("File decryption error: wrong key.");
        }
    }

    private static void updateResources(StiDocument document, StiReport report) {
        document.setResources(new StiResourcesCollection());
        Iterator i$ = report.getDictionary().getResources().iterator();
        while (i$.hasNext()) {
            StiResource resource = (StiResource)i$.next();
            if (!resource.isAvailableInTheViewer() && resource.type != StiResourceType.FontEot && resource.type != StiResourceType.FontOtf && resource.type != StiResourceType.FontTtc && resource.type != StiResourceType.FontTtf && resource.type != StiResourceType.FontWoff) continue;
            document.getResources().add(resource);
        }
    }
}

