/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.enums.StiHorAlignment;
import com.stimulsoft.base.drawing.enums.StiVertAlignment;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.annotations.StiSerializeTypesEnum;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiFontStyle;
import com.stimulsoft.base.system.StiGraphicsUnit;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.base.utils.StiLoggingUtil;
import com.stimulsoft.report.barCodes.IStiBarCode;
import com.stimulsoft.report.barCodes.StiBarCodeTypeService;
import com.stimulsoft.report.barCodes.StiEAN13BarCodeType;
import com.stimulsoft.report.barCodes.expressions.StiBarCodeExpression;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.enums.StiAngle;
import com.stimulsoft.report.components.enums.StiComponentToolboxPosition;
import com.stimulsoft.report.components.interfaces.IStiBackColor;
import com.stimulsoft.report.components.interfaces.IStiBorder;
import com.stimulsoft.report.components.interfaces.IStiEnumAngle;
import com.stimulsoft.report.components.interfaces.IStiExportImageExtended;
import com.stimulsoft.report.components.interfaces.IStiForeColor;
import com.stimulsoft.report.components.interfaces.IStiHorAlignment;
import com.stimulsoft.report.components.interfaces.IStiVertAlignment;
import com.stimulsoft.report.engine.parser.StiParser;
import com.stimulsoft.report.enums.StiCalculationMode;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.events.StiGetBarCodeEvent;
import com.stimulsoft.report.events.StiValueEventArgs;
import com.stimulsoft.report.events.StiValueEventHandler;
import com.stimulsoft.report.options.ExportOptions;
import java.util.logging.Logger;

public class StiBarCode
extends StiComponent
implements IStiBarCode,
IStiBackColor,
IStiForeColor,
IStiExportImageExtended,
IStiVertAlignment,
IStiHorAlignment,
IStiEnumAngle,
IStiBorder {
    static Logger LOG = Logger.getLogger("com.stimulsoft.report.barCodes.StiBarCode");
    private StiAngle angle = StiAngle.Angle0;
    private StiBorder border = new StiBorder();
    private StiColor foreColor = StiColor.Black;
    private StiColor backColor = StiColor.White;
    private boolean autoScale = false;
    private boolean showLabelText = true;
    private boolean showQuietZones = true;
    private StiBarCodeTypeService barCodeType = new StiEAN13BarCodeType();
    private StiFont font = null;
    private StiHorAlignment horAlignment = StiHorAlignment.Left;
    private StiVertAlignment vertAlignment = StiVertAlignment.Top;
    private String codeValue;
    private static final Object EventGetBarCode = new Object();

    public StiBarCode() {
        this(StiRectangle.empty());
    }

    public StiBarCode(StiRectangle rect) {
        super(rect);
        this.setPlaceOnToolbox(true);
        this.getCode().setValue("1234567890123");
    }

    @Override
    public boolean getCanShrink() {
        return super.getCanShrink();
    }

    @Override
    public void setCanShrink(boolean value) {
    }

    @Override
    public boolean getCanGrow() {
        return super.getCanGrow();
    }

    @Override
    public void setCanGrow(boolean value) {
    }

    @Override
    public int getToolboxPosition() {
        return StiComponentToolboxPosition.BarCode.getValue();
    }

    @Override
    public String getLocalizedCategory() {
        return StiLocalization.getValue((String)"Report", (String)"Components");
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.getValue((String)"Components", (String)"StiBarCode");
    }

    @Override
    public boolean isExportAsImage(StiExportFormat format) {
        return format != StiExportFormat.Pdf && format != StiExportFormat.ImageSvg || ExportOptions.Pdf.isRenderBarCodeAsImage();
    }

    @Override
    @StiDefaulValue(value="Angle0")
    @StiSerializable
    public final StiAngle getAngle() {
        return this.angle;
    }

    @Override
    public final void setAngle(StiAngle value) {
        this.angle = value;
    }

    @Override
    @StiSerializable(shortName="br")
    public final StiBorder getBorder() {
        return this.border;
    }

    @Override
    public final void setBorder(StiBorder value) {
        this.border = value;
    }

    @Override
    @StiSerializable
    public final StiColor getForeColor() {
        return this.foreColor;
    }

    @Override
    public final void setForeColor(StiColor value) {
        this.foreColor = value;
    }

    @Override
    @StiSerializable
    public final StiColor getBackColor() {
        return this.backColor;
    }

    @Override
    public final void setBackColor(StiColor value) {
        this.backColor = value;
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getAutoScale() {
        return this.autoScale;
    }

    @Override
    public void setAutoScale(boolean value) {
        this.autoScale = value;
    }

    @Override
    @StiDefaulValue(value="true")
    @StiSerializable
    public boolean getShowLabelText() {
        return this.showLabelText;
    }

    @Override
    public void setShowLabelText(boolean value) {
        this.showLabelText = value;
    }

    @StiDefaulValue(value="true")
    @StiSerializable
    public boolean getShowQuietZones() {
        return this.showQuietZones;
    }

    public void setShowQuietZones(boolean value) {
        this.showQuietZones = value;
    }

    @Override
    @StiSerializable
    public final StiBarCodeTypeService getBarCodeType() {
        return this.barCodeType;
    }

    @Override
    public final void setBarCodeType(StiBarCodeTypeService value) {
        this.barCodeType = value;
    }

    @Override
    public final String GetBarCodeString() {
        if (this.getCodeValue() != null) {
            return this.getCodeValue();
        }
        return this.getCode().getValue();
    }

    @StiSerializable(shortName="fn")
    public StiFont getFont() {
        if (this.font == null) {
            this.font = new StiFont("Arial", 8.0, StiFontStyle.Bold, StiGraphicsUnit.Point);
        }
        return this.font;
    }

    public void setFont(StiFont value) {
        this.font = value;
    }

    @Override
    @StiDefaulValue(value="Left")
    @StiSerializable(shortName="ha")
    public final StiHorAlignment getHorAlignment() {
        return this.horAlignment;
    }

    @Override
    public final void setHorAlignment(StiHorAlignment value) {
        this.horAlignment = value;
    }

    @Override
    @StiDefaulValue(value="Top")
    @StiSerializable(shortName="va")
    public final StiVertAlignment getVertAlignment() {
        return this.vertAlignment;
    }

    @Override
    public final void setVertAlignment(StiVertAlignment value) {
        this.vertAlignment = value;
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToDocument)
    public final String getCodeValue() {
        return this.codeValue;
    }

    public final void setCodeValue(String value) {
        this.codeValue = value;
    }

    private boolean isSerialization() {
        boolean isSerialization = false;
        try {
            int s = 11 / 0;
        }
        catch (Exception e) {
            for (StackTraceElement element : e.getStackTrace()) {
                if (element.getClassName().indexOf("StiSerializerReport") < 0) continue;
                isSerialization = true;
            }
        }
        return isSerialization;
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public StiBarCodeExpression getCode() {
        if (this.barCodeType != null) {
            String combinedCode = this.barCodeType.getCombinedCode();
            if (combinedCode != null && this.isSerialization()) {
                combinedCode = combinedCode.replaceAll("\u001f", "|");
            }
            if (combinedCode != null) {
                return new StiBarCodeExpression(combinedCode);
            }
        }
        return new StiBarCodeExpression(this, "Code");
    }

    public void setCode(StiBarCodeExpression value) {
        if (value != null) {
            value.Set(this, "Code", value.getValue() != null && this.isSerialization() ? value.getValue().replaceAll("|", "\u001f") : value.getValue());
        }
    }

    @Override
    public void invokeEvents() {
        try {
            Object parserResult;
            super.invokeEvents();
            if (this.codeValue == null && this.codeValue == null && (parserResult = StiParser.parseTextValue(this.getCode().getValue(), this)) != null) {
                this.codeValue = parserResult.toString();
            }
        }
        catch (RuntimeException r) {
            if (this.getReport() != null) {
                this.getReport().WriteToReportRenderingMessages("Expression in BarCode can't be evaluated!\nValue: " + this.getCode().getValue());
            }
            StiLoggingUtil.showWarning((String)("Expression in BarCode can't be evaluated!\nValue: " + this.getCode().getValue()), (Exception)r);
        }
    }

    protected void OnGetBarCode(StiValueEventArgs e) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void InvokeGetBarCode(StiComponent sender, StiValueEventArgs e) {
        try {
            StiValueEventHandler handler;
            this.OnGetBarCode(e);
            if (this.getReport().getCalculationMode() == StiCalculationMode.Compilation && (handler = (StiValueEventHandler)(super.getEvents().get(EventGetBarCode) instanceof StiValueEventHandler ? super.getEvents().get(EventGetBarCode) : null)) == null) return;
        }
        catch (RuntimeException ex) {
            if (this.getReport() == null) throw new RuntimeException(ex);
            this.getReport().WriteToReportRenderingMessages(String.format("Expression in BarCode property of '%1$s' can't be evaluated!", this.getName()));
            throw new RuntimeException(ex);
        }
    }

    @StiSerializable
    public final StiGetBarCodeEvent getGetBarCodeEvent() {
        return new StiGetBarCodeEvent(this);
    }

    public final void setGetBarCodeEvent(StiGetBarCodeEvent value) {
        if (value != null) {
            value.set(this, value.getScript());
        }
    }

    @Override
    public StiRectangle getDefaultClientRectangle() {
        return new StiRectangle(0L, 0L, 240L, 110L);
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.RemoveProperty("CanShrink");
        jObject.RemoveProperty("CanGrow");
        jObject.AddPropertyEnum("Angle", (Enum)this.getAngle(), (Enum)StiAngle.Angle0);
        jObject.AddPropertyStringNullOfEmpty("Border", StiJsonReportObjectHelper.Serialize.jBorder((StiBorder)this.getBorder()));
        jObject.AddPropertyStringNullOfEmpty("ForeColor", StiJsonReportObjectHelper.Serialize.jColor((StiColor)this.getForeColor(), (StiColor)StiColorEnum.Black.color()));
        jObject.AddPropertyStringNullOfEmpty("BackColor", StiJsonReportObjectHelper.Serialize.jColor((StiColor)this.getBackColor(), (StiColor)StiColorEnum.White.color()));
        jObject.AddPropertyBool("AutoScale", this.getAutoScale());
        jObject.AddPropertyBool("ShowLabelText", this.getShowLabelText(), true);
        jObject.AddPropertyBool("ShowQuietZones", this.getShowQuietZones(), true);
        jObject.AddPropertyStringNullOfEmpty("Font", StiJsonReportObjectHelper.Serialize.font((StiFont)this.getFont(), (String)"Arial", (float)8.0f, (int)StiFontStyle.Bold.intValue));
        jObject.AddPropertyEnum("HorAlignment", (Enum)this.getHorAlignment(), (Enum)StiHorAlignment.Left);
        jObject.AddPropertyEnum("VertAlignment", (Enum)this.getVertAlignment(), (Enum)StiVertAlignment.Top);
        jObject.AddPropertyJObject("GetBarCodeEvent", this.getGetBarCodeEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("BarCodeType", this.getBarCodeType().SaveToJsonObject(mode));
        if (mode == StiJsonSaveMode.Document) {
            jObject.AddPropertyStringNullOfEmpty("CodeValue", this.getCodeValue());
        } else {
            jObject.AddPropertyJObject("Code", this.getCode().SaveToJsonObject(mode));
        }
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Angle")) {
                this.angle = StiAngle.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("Border")) {
                this.border = StiJsonReportObjectHelper.Deserialize.Border((JProperty)property);
                continue;
            }
            if (property.Name.equals("ForeColor")) {
                this.foreColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("BackColor")) {
                this.backColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("AutoScale")) {
                this.autoScale = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("ShowLabelText")) {
                this.showLabelText = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("ShowQuietZones")) {
                this.showQuietZones = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("Font")) {
                this.font = StiJsonReportObjectHelper.Deserialize.Font((JProperty)property, (StiFont)this.getFont());
                continue;
            }
            if (property.Name.equals("HorAlignment")) {
                this.horAlignment = StiHorAlignment.valueOf((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("VertAlignment")) {
                this.vertAlignment = StiVertAlignment.valueOf((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("CodeValue")) {
                this.codeValue = (String)property.Value;
                continue;
            }
            if (property.Name.equals("Code")) {
                StiBarCodeExpression exp = new StiBarCodeExpression();
                exp.LoadFromJsonObject((JSONObject)property.Value);
                this.setCode(exp);
                continue;
            }
            if (property.Name.equals("GetBarCodeEvent")) {
                StiGetBarCodeEvent _event = new StiGetBarCodeEvent(this);
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.setGetBarCodeEvent(_event);
                continue;
            }
            if (!property.Name.equals("BarCodeType")) continue;
            this.barCodeType = StiBarCodeTypeService.LoadFromJsonObjectInternal((JSONObject)property.Value);
        }
    }
}

