/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.report.barCodes.StiBarCodeTypeService;
import java.util.HashMap;

public abstract class StiCode128BarCodeType
extends StiBarCodeTypeService {
    protected String[] Code128Table = new String[]{"212222", "222122", "222221", "121223", "121322", "131222", "122213", "122312", "132212", "221213", "221312", "231212", "112232", "122132", "122231", "113222", "123122", "123221", "223211", "221132", "221231", "213212", "223112", "312131", "311222", "321122", "321221", "312212", "322112", "322211", "212123", "212321", "232121", "111323", "131123", "131321", "112313", "132113", "132311", "211313", "231113", "231311", "112133", "112331", "132131", "113123", "113321", "133121", "313121", "211331", "231131", "213113", "213311", "213131", "311123", "311321", "331121", "312113", "312311", "332111", "314111", "221411", "431111", "111224", "111422", "121124", "121421", "141122", "141221", "112214", "112412", "122114", "122411", "142112", "142211", "241211", "221114", "413111", "241112", "134111", "111242", "121142", "121241", "114212", "124112", "124211", "411212", "421112", "421211", "212141", "214121", "412121", "111143", "111341", "131141", "114113", "114311", "411113", "411311", "113141", "114131", "311141", "411131", "211412", "211214", "211232", "2331112"};
    private double module = 13.0;
    private double height = 1.0;
    protected static final double Code128SpaceLeft = 10.0;
    protected static final double Code128SpaceRight = 10.0;
    protected static final double Code128SpaceTop = 0.0;
    protected static final double Code128SpaceBottom = 1.0;
    protected static final double Code128LineHeightShort = 45.0;
    protected static final double Code128LineHeightLong = 45.0;
    protected static final double Code128TextPosition = 46.0;
    protected static final double Code128TextHeight = (double)8.33f;
    protected static final double Code128MainHeight = 55.0;
    protected static final double Code128LineHeightForCut = 45.0;
    protected static final CodeSet DefaultCodeSetAB = CodeSet.B;

    public StiCode128BarCodeType(double module, double height) {
        this.module = module;
        this.height = height;
    }

    @Override
    @StiDefaulValue(value="13.0")
    @StiSerializable
    public double getModule() {
        return this.module;
    }

    @Override
    public void setModule(double value) {
        this.module = value;
        if (value < (double)9.84f) {
            this.module = 9.84f;
        }
        if (value > 40.0) {
            this.module = 40.0;
        }
    }

    @Override
    @StiDefaulValue(value="1.0")
    @StiSerializable
    public double getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(double value) {
        this.height = value;
        if (value < 0.5) {
            this.height = 0.5;
        }
        if (value > 2.0) {
            this.height = 2.0;
        }
    }

    @Override
    public double getLabelFontHeight() {
        return 8.33f;
    }

    protected final String CodeToBar(String inputCode) {
        StringBuilder outputBar = new StringBuilder();
        boolean counter = true;
        for (int index = 0; index < inputCode.length(); ++index) {
            int currentsym = counter ? (inputCode.charAt(index) == '1' ? 52 : (inputCode.charAt(index) == '2' ? 53 : (inputCode.charAt(index) == '3' ? 54 : (inputCode.charAt(index) == '4' ? 55 : 52)))) : (inputCode.charAt(index) == '1' ? 48 : (inputCode.charAt(index) == '2' ? 49 : (inputCode.charAt(index) == '3' ? 50 : (inputCode.charAt(index) == '4' ? 51 : 48))));
            outputBar.append((char)currentsym);
            counter = !counter;
        }
        return outputBar.toString();
    }

    protected static String EncodeAuto(String inputText, boolean encodeAsEan) {
        StringBuilder output = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        for (char ch : inputText.toCharArray()) {
            char sym = ch;
            if (sym >= '\u0080' && (sym < ControlCodes.FNC1.getValue() || sym > ControlCodes.FNC4.getValue())) continue;
            sb.append(ch);
        }
        CodeSet state = StiCode128BarCodeType.GetSet(sb, 0, CodeSet.None);
        if (state == CodeSet.A) {
            output.append((char)BarcodeCommands.StartA.intValue);
        } else if (state == CodeSet.B) {
            output.append((char)BarcodeCommands.StartB.intValue);
        } else {
            output.append((char)BarcodeCommands.StartC.intValue);
        }
        if (encodeAsEan) {
            output.append((char)BarcodeCommands.FNC1.intValue);
        }
        for (int pos = 0; pos < sb.length(); ++pos) {
            char sym;
            CodeSet newState = StiCode128BarCodeType.GetSet(sb, pos, state);
            if (newState != state) {
                if (newState == CodeSet.A) {
                    output.append((char)BarcodeCommands.CodeA.intValue);
                } else if (newState == CodeSet.B) {
                    output.append((char)BarcodeCommands.CodeB.intValue);
                } else {
                    output.append((char)BarcodeCommands.CodeC.intValue);
                }
                state = newState;
            }
            if ((sym = sb.charAt(pos)) >= ControlCodes.FNC1.getValue() && sym <= ControlCodes.FNC4.getValue()) {
                if (sym == ControlCodes.FNC1.getValue()) {
                    output.append((char)BarcodeCommands.FNC1.intValue);
                } else if (sym == ControlCodes.FNC2.getValue()) {
                    output.append((char)BarcodeCommands.FNC2.intValue);
                } else if (sym == ControlCodes.FNC3.getValue()) {
                    output.append((char)BarcodeCommands.FNC3.intValue);
                } else if (state == CodeSet.A) {
                    output.append((char)BarcodeCommands.FNC4A.intValue);
                } else {
                    output.append((char)BarcodeCommands.FNC4B.intValue);
                }
            }
            if (state == CodeSet.A) {
                output.append((char)(sym >= ' ' ? sym - 32 : sym + 64));
                continue;
            }
            if (state == CodeSet.B) {
                output.append((char)(sym - 32));
                continue;
            }
            int pair = (sym - 48) * 10 + (sb.charAt(pos + 1) - 48);
            output.append((char)pair);
            ++pos;
        }
        output.append('\u0000');
        output.append((char)BarcodeCommands.Stop.intValue);
        return output.toString();
    }

    private static CodeSet GetSet(StringBuilder text, int pos, CodeSet prevSet) {
        char sym = text.charAt(pos);
        if (sym >= ControlCodes.FNC1.getValue() && sym <= ControlCodes.FNC4.getValue()) {
            if (prevSet == CodeSet.None) {
                return DefaultCodeSetAB;
            }
            if (sym == ControlCodes.FNC1.getValue()) {
                return prevSet;
            }
            if (prevSet == CodeSet.C) {
                return DefaultCodeSetAB;
            }
            return prevSet;
        }
        if (sym < ' ') {
            return CodeSet.A;
        }
        if (sym >= '`') {
            return CodeSet.B;
        }
        if (Character.isDigit(text.charAt(pos)) && (prevSet == CodeSet.C ? pos + 1 < text.length() && Character.isDigit(text.charAt(pos + 1)) : pos + 3 < text.length() && Character.isDigit(text.charAt(pos + 1)) && Character.isDigit(text.charAt(pos + 2)) && Character.isDigit(text.charAt(pos + 3)))) {
            return CodeSet.C;
        }
        if (prevSet != CodeSet.None && prevSet != CodeSet.C) {
            return prevSet;
        }
        return DefaultCodeSetAB;
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyFloat("Module", this.getModule(), 13.0);
        jObject.AddPropertyFloat("Height", this.getHeight(), 1.0);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Module")) {
                this.module = property.floatValue().floatValue();
                continue;
            }
            if (!property.Name.equals("Height")) continue;
            this.height = property.floatValue().floatValue();
        }
    }

    private static enum BarcodeCommands {
        FNC1(102),
        FNC2(97),
        FNC3(96),
        FNC4A(101),
        FNC4B(100),
        CodeA(101),
        CodeB(100),
        CodeC(99),
        Shift(98),
        StartA(103),
        StartB(104),
        StartC(105),
        Stop(106);

        private int intValue;
        private static HashMap<Integer, BarcodeCommands> mappings;

        private static synchronized HashMap<Integer, BarcodeCommands> getMappings() {
            if (mappings == null) {
                mappings = new HashMap();
            }
            return mappings;
        }

        private BarcodeCommands(int value) {
            this.intValue = value;
            BarcodeCommands.getMappings().put(value, this);
        }

        public int getValue() {
            return this.intValue;
        }

        public static BarcodeCommands forValue(int value) {
            return BarcodeCommands.getMappings().get(value);
        }
    }

    private static enum ControlCodes {
        FNC1(129),
        FNC2(130),
        FNC3(131),
        FNC4(132),
        CodeA(133),
        CodeB(134),
        CodeC(135),
        Shift(136);

        private int intValue;
        private static HashMap<Integer, ControlCodes> mappings;

        private static synchronized HashMap<Integer, ControlCodes> getMappings() {
            if (mappings == null) {
                mappings = new HashMap();
            }
            return mappings;
        }

        private ControlCodes(int value) {
            this.intValue = value;
            ControlCodes.getMappings().put(value, this);
        }

        public int getValue() {
            return this.intValue;
        }

        public static ControlCodes forValue(int value) {
            return ControlCodes.getMappings().get(value);
        }
    }

    protected static enum CodeSet {
        None,
        A,
        B,
        C;


        public int getValue() {
            return this.ordinal();
        }

        public static CodeSet forValue(int value) {
            return CodeSet.values()[value];
        }
    }
}

