/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiCode128BarCodeType;

public class StiEAN128AutoBarCodeType
extends StiCode128BarCodeType {
    public StiEAN128AutoBarCodeType() {
        this(13.0, 1.0);
    }

    public StiEAN128AutoBarCodeType(double module, double height) {
        super(module, height);
    }

    public String getServiceName() {
        return "EAN-128 Auto";
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        String code = this.GetCode(barCode);
        StringBuilder sbTemp = new StringBuilder();
        for (int index = 0; index < code.length(); ++index) {
            char ch = code.charAt(index);
            sbTemp.append(ch >= ' ' && ch != '\u0081' ? (char)ch : (char)'\u2219');
        }
        String encodedText = StiEAN128AutoBarCodeType.EncodeAuto(code, true);
        int[] fullCode = new int[encodedText.length()];
        for (int index = 0; index < encodedText.length(); ++index) {
            fullCode[index] = encodedText.charAt(index);
        }
        int checkSum = fullCode[0] + fullCode[1];
        for (int index = 0; index < encodedText.length() - 4; ++index) {
            checkSum += fullCode[index + 2] * (index + 2);
        }
        fullCode[fullCode.length - 2] = checkSum % 103;
        StringBuilder barsArray = new StringBuilder();
        for (int index = 0; index < fullCode.length; ++index) {
            barsArray.append(this.CodeToBar(this.Code128Table[fullCode[index]]));
        }
        String text = sbTemp.toString();
        this.CalculateSizeFull(10.0, 10.0, 0.0, 1.0, 45.0, 45.0, 46.0, 8.33f, 55.0, 45.0, 2.0, zoom, code, text, barsArray.toString(), rect, barCode);
        this.drawBarCode(context, rect, barCode);
    }

    @Override
    public String getDefaultCodeValue() {
        return "1234567890123";
    }
}

