/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiEAN13BarCodeType;
import com.stimulsoft.report.barCodes.enums.StiEanSupplementType;
import java.util.ArrayList;

public class StiEAN8BarCodeType
extends StiEAN13BarCodeType {
    public StiEAN8BarCodeType() {
        this(13.0, 1.0, StiEanSupplementType.None, null, true);
    }

    public StiEAN8BarCodeType(double module, double height, StiEanSupplementType supplementType, String supplementCodeValue, boolean showQuietZoneIndicator) {
        super(module, height, supplementType, supplementCodeValue, showQuietZoneIndicator);
    }

    @Override
    public String getServiceName() {
        return "EAN-8";
    }

    @Override
    protected double getEanSpaceLeft() {
        return 7.0;
    }

    @Override
    protected double getEanSpaceRight() {
        return 7.0;
    }

    @Override
    protected double getEanLineHeightShort() {
        return 55.2f;
    }

    @Override
    protected double getEanMainHeight() {
        return 64.58;
    }

    protected final ArrayList MakeEan8Bars(String code, boolean isLast) {
        StiEAN13BarCodeType.EanBarInfo sym;
        int currentNumber;
        int index;
        int[] dig = new int[8];
        for (int tempIndex = 0; tempIndex < 7; ++tempIndex) {
            dig[tempIndex] = Integer.parseInt(String.valueOf(code.charAt(tempIndex)));
        }
        int sum = (dig[0] + dig[2] + dig[4] + dig[6]) * 3 + dig[1] + dig[3] + dig[5];
        int checkDigit = 10 - sum % 10;
        if (checkDigit == 10) {
            checkDigit = 0;
        }
        code = code.substring(0, 7) + (char)(checkDigit + 48);
        ArrayList<StiEAN13BarCodeType.EanBarInfo> barsArray = new ArrayList<StiEAN13BarCodeType.EanBarInfo>();
        barsArray.add(new StiEAN13BarCodeType.EanBarInfo(StiEAN13BarCodeType.Ean13Symbol.SpaceLeft, this.getShowQuietZoneIndicator() ? (char)'<' : ' ', false));
        barsArray.add(new StiEAN13BarCodeType.EanBarInfo(StiEAN13BarCodeType.Ean13Symbol.GuardLeft, ' ', false));
        for (index = 0; index < 4; ++index) {
            currentNumber = Integer.parseInt(String.valueOf(code.charAt(0 + index)));
            sym = new StiEAN13BarCodeType.EanBarInfo(StiEAN13BarCodeType.Ean13Symbol.forValue(StiEAN13BarCodeType.Ean13Symbol.ComboA0.getValue() + currentNumber), code.charAt(0 + index), false);
            barsArray.add(sym);
        }
        barsArray.add(new StiEAN13BarCodeType.EanBarInfo(StiEAN13BarCodeType.Ean13Symbol.GuardCenter, ' ', false));
        for (index = 0; index < 4; ++index) {
            currentNumber = Integer.parseInt(String.valueOf(code.charAt(4 + index)));
            sym = new StiEAN13BarCodeType.EanBarInfo(StiEAN13BarCodeType.Ean13Symbol.forValue(StiEAN13BarCodeType.Ean13Symbol.ComboC0.getValue() + currentNumber), code.charAt(4 + index), false);
            barsArray.add(sym);
        }
        barsArray.add(new StiEAN13BarCodeType.EanBarInfo(StiEAN13BarCodeType.Ean13Symbol.GuardRight, ' ', false));
        if (isLast) {
            barsArray.add(new StiEAN13BarCodeType.EanBarInfo(StiEAN13BarCodeType.Ean13Symbol.SpaceRight, this.getShowQuietZoneIndicator() ? (char)'>' : ' ', false));
        } else {
            barsArray.add(new StiEAN13BarCodeType.EanBarInfo(StiEAN13BarCodeType.Ean13Symbol.SpaceBeforeAdd, ' ', false));
        }
        return barsArray;
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        String code = this.GetCode(barCode);
        code = this.CheckCodeSymbols(code, "0123456789") + "00000000";
        String suppCode = this.CheckCodeSymbols(this.getSupplementCode(), "0123456789") + "00000";
        ArrayList barsArray = null;
        if (this.getSupplementType() == StiEanSupplementType.None) {
            barsArray = this.MakeEan8Bars(code, true);
        } else {
            barsArray = this.MakeEan8Bars(code, false);
            if (this.getSupplementType() == StiEanSupplementType.TwoDigit) {
                this.MakeEanAdd2Bars(suppCode, barsArray, true);
            } else {
                this.MakeEanAdd5Bars(suppCode, barsArray, true);
            }
        }
        this.CalculateSizeEan(0.0, zoom, barsArray, rect, barCode);
        this.translateRect(context, rect, barCode);
        this.drawEanBars(context, barsArray, barCode);
        this.rollbackTransform(context);
    }

    @Override
    public String getDefaultCodeValue() {
        return "12345678";
    }
}

