/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiBarCodeTypeService;

public class StiITF14BarCodeType
extends StiBarCodeTypeService {
    private double module = 40.0;
    private double height = 1.0;
    private double ratio = 2.5;
    private boolean printVerticalBars = false;
    protected String[] symTableSet = new String[]{"00110", "10001", "01001", "11000", "00101", "10100", "01100", "00011", "10010", "01010", "0000", "100"};
    private static final double Itf14BearerBarWidth = 2.0;
    private static final double Itf14SpaceLeft = 10.0;
    private static final double Itf14SpaceRight = 10.0;
    private static final double Itf14SpaceTop = 2.0;
    private static final double Itf14SpaceBottom = 3.0;
    private static final double Itf14LineHeightShort = 31.25;
    private static final double Itf14LineHeightLong = 31.25;
    private static final double Itf14TextHeight = 8.33;
    private static final double Itf14MainHeight = 51.75;
    private static final double Itf14TextPosition = 36.25;
    private static final double Itf14LineHeightForCut = 31.25;

    public StiITF14BarCodeType() {
        this(40.0, 1.0, 2.5, false);
    }

    public StiITF14BarCodeType(double module, double height, double ratio, boolean printVerticalBars) {
        this.module = module;
        this.height = height;
        this.ratio = ratio;
        this.printVerticalBars = printVerticalBars;
    }

    public String getServiceName() {
        return "ITF-14";
    }

    @Override
    @StiDefaulValue(value="40.0")
    @StiSerializable
    public double getModule() {
        return this.module;
    }

    @Override
    public void setModule(double value) {
        this.module = value;
        if (value < 10.0) {
            this.module = 10.0;
        }
        if (value > 40.0) {
            this.module = 40.0;
        }
        this.setRatio(this.getRatio());
    }

    @Override
    @StiDefaulValue(value="1.0")
    @StiSerializable
    public double getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(double value) {
        this.height = value;
        if (value < 0.5) {
            this.height = 0.5;
        }
        if (value > 2.0) {
            this.height = 2.0;
        }
    }

    @StiDefaulValue(value="2.5")
    @StiSerializable
    public final double getRatio() {
        return this.ratio;
    }

    public final void setRatio(double value) {
        this.ratio = value;
        if (value < 2.25) {
            this.ratio = 2.25;
        }
        if (value > 3.0) {
            this.ratio = 3.0;
        }
    }

    @StiDefaulValue(value="false")
    @StiSerializable
    public final boolean getPrintVerticalBars() {
        return this.printVerticalBars;
    }

    public final void setPrintVerticalBars(boolean value) {
        this.printVerticalBars = value;
    }

    @Override
    public double getLabelFontHeight() {
        return 8.33;
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        String code = this.GetCode(barCode);
        code = this.CheckCodeSymbols(code, "0123456789") + "00000000000000";
        Double pageZoom = barCode.getReport().getInfo().getPageZoom();
        int[] dig = new int[14];
        for (int tempIndex = 0; tempIndex < 14; ++tempIndex) {
            dig[tempIndex] = Integer.parseInt(String.valueOf(code.charAt(tempIndex)));
        }
        int sum = (dig[0] + dig[2] + dig[4] + dig[6] + dig[8] + dig[10] + dig[12]) * 3 + dig[1] + dig[3] + dig[5] + dig[7] + dig[9] + dig[11];
        int checkDigit = 10 - sum % 10;
        if (checkDigit == 10) {
            checkDigit = 0;
        }
        dig[13] = checkDigit;
        code = code.substring(0, 13) + (char)(checkDigit + 48);
        StringBuilder barsArray = new StringBuilder();
        barsArray.append(this.symTableSet[10]);
        for (int index = 0; index < 7; ++index) {
            String sym1 = this.symTableSet[dig[index * 2 + 0]];
            String sym2 = this.symTableSet[dig[index * 2 + 1]];
            StringBuilder sb = new StringBuilder("0000000000");
            sb.setCharAt(0, sym1.charAt(0));
            sb.setCharAt(2, sym1.charAt(1));
            sb.setCharAt(4, sym1.charAt(2));
            sb.setCharAt(6, sym1.charAt(3));
            sb.setCharAt(8, sym1.charAt(4));
            sb.setCharAt(1, sym2.charAt(0));
            sb.setCharAt(3, sym2.charAt(1));
            sb.setCharAt(5, sym2.charAt(2));
            sb.setCharAt(7, sym2.charAt(3));
            sb.setCharAt(9, sym2.charAt(4));
            barsArray.append((CharSequence)sb);
        }
        barsArray.append(this.symTableSet[11]);
        boolean counter = true;
        for (int index = 0; index < barsArray.length(); ++index) {
            char currentsym = counter ? (barsArray.charAt(index) == '0' ? (char)'4' : '5') : (barsArray.charAt(index) == '0' ? (char)'0' : '1');
            barsArray.setCharAt(index, currentsym);
            counter = !counter;
        }
        this.CalculateSizeFull(10.0 + (this.getPrintVerticalBars() ? 2.0 : 0.0), 10.0 + (this.getPrintVerticalBars() ? 2.0 : 0.0), 2.0, 3.0, 31.25, 31.25, 36.25, 8.33, 51.75, 31.25, this.getRatio(), zoom, code, code, barsArray.toString(), rect, barCode);
        this.drawBarCode(context, rect, barCode);
        StiSolidBrush foreBrush = new StiSolidBrush(barCode.getForeColor());
        this.translateRect(context, rect, barCode);
        this.baseFillRectangle(context, (StiBrush)foreBrush, 0.0, 0.0, this.getBarCodeData().MainWidth, this.getBarCodeData().SpaceTop, zoom, pageZoom);
        this.baseFillRectangle(context, (StiBrush)foreBrush, 0.0, this.getBarCodeData().SpaceTop + this.getBarCodeData().LineHeightShort, this.getBarCodeData().MainWidth, this.getBarCodeData().SpaceTop, zoom, pageZoom);
        if (this.getPrintVerticalBars()) {
            this.baseFillRectangle(context, (StiBrush)foreBrush, 0.0, 0.0, this.getBarCodeData().SpaceTop, this.getBarCodeData().LineHeightShort + this.getBarCodeData().SpaceTop * 2.0, zoom, pageZoom);
            this.baseFillRectangle(context, (StiBrush)foreBrush, this.getBarCodeData().MainWidth - this.getBarCodeData().SpaceTop, 0.0, this.getBarCodeData().SpaceTop, this.getBarCodeData().LineHeightShort + this.getBarCodeData().SpaceTop * 2.0, zoom, pageZoom);
        }
        this.rollbackTransform(context);
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyFloat("Module", this.getModule(), 40.0);
        jObject.AddPropertyFloat("Height", this.getHeight(), 1.0);
        jObject.AddPropertyFloat("Ratio", this.getRatio(), 2.5);
        jObject.AddPropertyBool("PrintVerticalBars", this.getPrintVerticalBars());
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Module")) {
                this.module = property.floatValue().floatValue();
                continue;
            }
            if (property.Name.equals("Height")) {
                this.height = property.floatValue().floatValue();
                continue;
            }
            if (property.Name.equals("Ratio")) {
                this.ratio = property.floatValue().floatValue();
                continue;
            }
            if (!property.Name.equals("PrintVerticalBars")) continue;
            this.printVerticalBars = (Boolean)property.Value;
        }
    }

    @Override
    public String getDefaultCodeValue() {
        return "15400141288763";
    }
}

