/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.barCodes;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiGraphics;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiStringUtil;
import com.stimulsoft.report.barCodes.StiBarCode;
import com.stimulsoft.report.barCodes.StiBarCodeTypeService;
import com.stimulsoft.report.barCodes.StiCode128cBarCodeType;
import com.stimulsoft.report.enums.StiComponentId;
import java.util.ArrayList;

public class StiSSCC18BarCodeType
extends StiCode128cBarCodeType {
    private String companyPrefix = "0123456";
    private String serialNumber = "000000001";
    private String extensionDigit = "0";

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.AddPropertyString("CompanyPrefix", this.getCompanyPrefix(), "0123456");
        jObject.AddPropertyString("SerialNumber", this.getSerialNumber(), "000000001");
        jObject.AddPropertyString("ExtensionDigit", this.getExtensionDigit(), "0");
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if ("CompanyPrefix".equals(property.Name)) {
                this.companyPrefix = (String)property.Value;
                continue;
            }
            if ("SerialNumber".equals(property.Name)) {
                this.serialNumber = (String)property.Value;
                continue;
            }
            if (!"ExtensionDigit".equals(property.Name)) continue;
            this.extensionDigit = (String)property.Value;
        }
    }

    public StiComponentId getComponentId() {
        return StiComponentId.StiSSCC18BarCodeType;
    }

    @Override
    public String getServiceName() {
        return "SSCC";
    }

    @Override
    public String getDefaultCodeValue() {
        return "(00)\u001f0\u001f0123456\u001f000000001\u001f8";
    }

    protected boolean getTextSpacing() {
        return false;
    }

    @StiSerializable
    public String getCompanyPrefix() {
        return this.companyPrefix;
    }

    public void setCompanyPrefix(String companyPrefix) {
        this.companyPrefix = companyPrefix;
    }

    @StiSerializable
    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    @StiSerializable
    public String getExtensionDigit() {
        return this.extensionDigit;
    }

    public void setExtensionDigit(String extensionDigit) {
        this.extensionDigit = extensionDigit;
    }

    @Override
    public String getCombinedCode() {
        return String.format("(00)\u001f%s\u001f%s\u001f%s\u001f%s", this.extensionDigit, this.companyPrefix, this.serialNumber, this.GetCheckDigit(this.CheckCodeSymbols(this.extensionDigit + this.companyPrefix + this.serialNumber + StiStringUtil.createCopies((char)'0', (int)17), "0123456789")));
    }

    private String GetCheckDigit(String input) {
        int[] dig = new int[17];
        for (int tempIndex = 0; tempIndex < 17; ++tempIndex) {
            dig[tempIndex] = Integer.parseInt(Character.toString(input.charAt(tempIndex)));
        }
        int sum = dig[1] + dig[3] + dig[5] + dig[7] + dig[9] + dig[11] + dig[13] + dig[15] + (dig[0] + dig[2] + dig[4] + dig[6] + dig[8] + dig[10] + dig[12] + dig[14] + dig[16]) * 3;
        int checkDigit = 10 - sum % 10;
        if (checkDigit == 10) {
            checkDigit = 0;
        }
        return Character.toString((char)(checkDigit + 48));
    }

    private boolean CheckContens(String inputCode, String[] arr) {
        if (arr.length != 5) {
            return true;
        }
        if (arr[0] != "00") {
            return true;
        }
        if (arr[1].length() != 1) {
            return true;
        }
        int companyPrefixLen = arr[2].length();
        if (companyPrefixLen < 7 || companyPrefixLen > 10) {
            return true;
        }
        int serialLen = arr[3].length();
        if (serialLen + companyPrefixLen != 16) {
            return true;
        }
        return inputCode.length() != 24;
    }

    @Override
    public void draw(StiGraphics context, StiBarCode barCode, StiRectangle rect, double zoom) throws Exception {
        String[] arr;
        String inputString = this.GetCode(barCode);
        String inputCode = this.CheckCodeSymbols(inputString, "0123456789\u001f");
        boolean error = this.CheckContens(inputCode, arr = inputCode.split("\u001f"));
        if (error) {
            String[] newArr = new String[arr.length > 5 ? arr.length : 5];
            for (int index = 0; index < arr.length; ++index) {
                newArr[index] = arr[index];
            }
            arr = newArr;
            arr[0] = "00";
            if (arr[1].length() < 1) {
                arr[1] = "0";
            }
            if (arr[1].length() > 1) {
                arr[1] = arr[1].substring(0, 1);
            }
            if (arr[2].length() < 7) {
                arr[2] = arr[2] + StiStringUtil.createCopies((char)'0', (int)(7 - arr[2].length()));
            }
            if (arr[2].length() > 10) {
                arr[2] = arr[2].substring(0, 10);
            }
            if (arr[3].length() < 16 - arr[2].length()) {
                arr[3] = arr[3] + StiStringUtil.createCopies((char)'0', (int)(16 - arr[2].length()));
            }
            if (arr[3].length() > 16 - arr[2].length()) {
                arr[3] = arr[3].substring(0, 16 - arr[2].length());
            }
        }
        String code = arr[1] + arr[2] + arr[3];
        String checkDigit = this.GetCheckDigit(code);
        code = arr[0] + code + checkDigit;
        String text = String.format("(%s) %s %s %s %s%s", arr[0], arr[1], arr[2], arr[3], checkDigit, error ? " *" : "");
        if (barCode.getReport() != null && barCode.getReport().getIsDesigning()) {
            text = inputString.replace('\u001f', ' ');
        }
        ArrayList<String> stringList = new ArrayList<String>();
        stringList.add(code);
        StringBuilder sbCode = new StringBuilder();
        for (int index = 0; index < stringList.size(); ++index) {
            String stLine = (String)stringList.get(index);
            int stringLen = stLine.length() / 2;
            for (int index2 = 0; index2 < stringLen; ++index2) {
                sbCode.append((char)Integer.parseInt(stLine.substring(index2 * 2, index2 * 2 + 2)));
            }
            if (stLine.length() % 2 == 1) {
                sbCode.append('d');
                sbCode.append((char)(stLine.charAt(stLine.length() - 1) - 32));
                if (index < stringList.size() - 1) {
                    sbCode.append('c');
                }
            }
            if (index >= stringList.size() - 1) continue;
            sbCode.append('f');
        }
        int[] fullCode = new int[sbCode.length() + 4];
        fullCode[0] = 105;
        fullCode[1] = 102;
        for (int index = 0; index < sbCode.length(); ++index) {
            fullCode[index + 2] = sbCode.charAt(index);
        }
        int checkSum = fullCode[0] + fullCode[1];
        for (int index = 0; index < fullCode.length - 3; ++index) {
            checkSum += fullCode[index + 2] * (index + 2);
        }
        fullCode[fullCode.length - 2] = checkSum % 103;
        fullCode[fullCode.length - 1] = 106;
        StringBuilder barsArray = new StringBuilder();
        for (int index = 0; index < fullCode.length; ++index) {
            barsArray.append(this.CodeToBar(this.Code128Table[fullCode[index]]));
        }
        this.CalculateSizeFull(10.0, 10.0, 0.0, 1.0, 45.0, 45.0, 46.0, 8.33f, 55.0, 45.0, 2.0, zoom, code, text, barsArray.toString(), rect, barCode);
        this.drawBarCode(context, rect, barCode);
    }

    public StiBarCodeTypeService CreateNew() {
        return new StiSSCC18BarCodeType();
    }

    public StiSSCC18BarCodeType() {
        this(13.0f, 1.0f);
    }

    public StiSSCC18BarCodeType(float module, float height) {
        super(module, height);
    }
}

