/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBorder;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.system.StiEventHandlerArgs;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.IStiIgnoryStyle;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.StiChartInfoV1;
import com.stimulsoft.report.chart.StiChartInfoV2;
import com.stimulsoft.report.chart.core.StiChartCoreXF;
import com.stimulsoft.report.chart.interfaces.IStiChart;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.IStiAxisArea;
import com.stimulsoft.report.chart.interfaces.chartTitle.IStiChartTitle;
import com.stimulsoft.report.chart.interfaces.constantLines.IStiConstantLines;
import com.stimulsoft.report.chart.interfaces.legend.IStiLegend;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.seriesLabels.IStiSeriesLabels;
import com.stimulsoft.report.chart.interfaces.strips.IStiStrips;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;
import com.stimulsoft.report.chart.interfaces.table.IStiChartTable;
import com.stimulsoft.report.chart.view.areas.StiArea;
import com.stimulsoft.report.chart.view.areas.clusteredColumn.StiClusteredColumnArea;
import com.stimulsoft.report.chart.view.areas.radar.StiRadarArea;
import com.stimulsoft.report.chart.view.chartTitle.StiChartTitle;
import com.stimulsoft.report.chart.view.conditions.StiChartConditionsCollection;
import com.stimulsoft.report.chart.view.constantLines.StiConstantLinesCollection;
import com.stimulsoft.report.chart.view.legend.StiLegend;
import com.stimulsoft.report.chart.view.series.StiSeries;
import com.stimulsoft.report.chart.view.series.StiSeriesCollection;
import com.stimulsoft.report.chart.view.seriesLabels.StiSeriesLabels;
import com.stimulsoft.report.chart.view.seriesLabels.axis.StiCenterAxisLabels;
import com.stimulsoft.report.chart.view.strips.StiStripsCollection;
import com.stimulsoft.report.chart.view.styles.StiChartStyle;
import com.stimulsoft.report.chart.view.styles.StiStyle29;
import com.stimulsoft.report.chart.view.table.StiChartTable;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiFiltersCollection;
import com.stimulsoft.report.components.enums.StiComponentPriority;
import com.stimulsoft.report.components.enums.StiComponentToolboxPosition;
import com.stimulsoft.report.components.enums.StiComponentType;
import com.stimulsoft.report.components.enums.StiFilterMode;
import com.stimulsoft.report.components.enums.StiImageRotation;
import com.stimulsoft.report.components.interfaces.IStiBorder;
import com.stimulsoft.report.components.interfaces.IStiBrush;
import com.stimulsoft.report.components.interfaces.IStiBusinessObject;
import com.stimulsoft.report.components.interfaces.IStiChartComponent;
import com.stimulsoft.report.components.interfaces.IStiDataRelation;
import com.stimulsoft.report.components.interfaces.IStiDataSource;
import com.stimulsoft.report.components.interfaces.IStiExportImageExtended;
import com.stimulsoft.report.components.interfaces.IStiFilter;
import com.stimulsoft.report.components.interfaces.IStiMasterComponent;
import com.stimulsoft.report.components.interfaces.IStiProcessAtEnd;
import com.stimulsoft.report.components.interfaces.IStiSort;
import com.stimulsoft.report.dictionary.StiDataRelation;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObject;
import com.stimulsoft.report.dictionary.businessObjects.StiBusinessObjectHelper;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.engine.engineV2.builders.StiChartV2Builder;
import com.stimulsoft.report.enums.StiExportFormat;
import com.stimulsoft.report.events.StiFilterEventHandler;
import com.stimulsoft.report.events.StiProcessChartEvent;
import com.stimulsoft.report.globalization.IStiGlobalizationProvider;
import com.stimulsoft.report.options.EngineOptions;
import com.stimulsoft.report.units.StiUnit;
import java.util.ArrayList;
import java.util.List;

public class StiChart
extends StiComponent
implements IStiBorder,
IStiBusinessObject,
IStiBrush,
IStiDataSource,
IStiDataRelation,
IStiMasterComponent,
IStiSort,
IStiFilter,
IStiExportImageExtended,
IStiIgnoryStyle,
IStiGlobalizationProvider,
IStiProcessAtEnd,
IStiChartComponent,
IStiChart {
    private StiFilterEventHandler filterMethodHandler;
    private StiFilterMode filterMode = StiFilterMode.And;
    private StiFiltersCollection filters = new StiFiltersCollection();
    private boolean filterOn = true;
    private StiBorder border = new StiBorder();
    private StiBrush brush = new StiSolidBrush(StiColor.Transparent);
    private ArrayList<String> sort = new ArrayList();
    private String dataSourceName = "";
    private String businessObjectGuid = "";
    private StiComponent masterComponent = null;
    private int countData = 0;
    public boolean isEofValue = false;
    public boolean isBofValue = false;
    public boolean isAnimation = false;
    private boolean isAnimationChangingValues = false;
    public int positionValue;
    private String dataRelationName = "";
    private boolean processAtEnd = false;
    private StiProcessChartEvent processChartEvent = new StiProcessChartEvent();
    private StiChartConditionsCollection seriesLabelsConditions = new StiChartConditionsCollection();
    private StiChartCoreXF core;
    private StiImageRotation rotation = StiImageRotation.None;
    private StiSeriesCollection series;
    private IStiArea area;
    private IStiChartStyle style = new StiStyle29();
    private boolean allowApplyStyle = true;
    private String customStyleName = "";
    private int horSpacing = 10;
    private int vertSpacing = 10;
    private IStiSeriesLabels seriesLabels;
    private IStiLegend legend;
    private IStiChartTitle title;
    private StiStripsCollection strips;
    private StiConstantLinesCollection constantLines;
    private StiChartInfoV1 chartInfoV1 = new StiChartInfoV1();
    private StiChartInfoV2 chartInfoV2 = new StiChartInfoV2();
    private IStiChartTable table;
    public String jsonMasterComponentTemp;

    @Override
    public boolean isDataSourceEmpty() {
        return false;
    }

    @Override
    public void convert(StiUnit oldUnit, StiUnit newUnit) {
        super.convert(oldUnit, newUnit);
        this.getLegend().setSize(newUnit.ConvertFromHInches(oldUnit.ConvertToHInches(this.getLegend().getSize())));
    }

    @Override
    public final double ConvertToHInches(double value) {
        if (this.getReport() != null) {
            return this.getReport().getUnit().ConvertToHInches(value);
        }
        return value;
    }

    @Override
    public void setString(String propertyName, String value) {
        if (propertyName.equals("Legend.Title")) {
            this.getLegend().setTitle(value);
        } else if (propertyName.equals("SeriesLabels.TextBefore")) {
            this.getSeriesLabels().setTextBefore(value);
        } else if (propertyName.equals("SeriesLabels.TextAfter")) {
            this.getSeriesLabels().setTextAfter(value);
        }
        IStiAxisArea axisArea = (IStiAxisArea)(this.area instanceof IStiAxisArea ? this.area : null);
        if (axisArea != null) {
            if (propertyName.equals("Area.XAxis.Labels.TextBefore")) {
                axisArea.getXAxis().getLabels().setTextBefore(value);
            } else if (propertyName.equals("Area.XAxis.Labels.TextAfter")) {
                axisArea.getXAxis().getLabels().setTextAfter(value);
            } else if (propertyName.equals("Area.XAxis.Title.Text")) {
                axisArea.getXAxis().getTitle().setText(value);
            } else if (propertyName.equals("Area.YAxis.Labels.TextBefore")) {
                axisArea.getYAxis().getLabels().setTextBefore(value);
            } else if (propertyName.equals("Area.YAxis.Labels.TextAfter")) {
                axisArea.getYAxis().getLabels().setTextAfter(value);
            } else if (propertyName.equals("Area.YAxis.Title.Text")) {
                axisArea.getYAxis().getTitle().setText(value);
            } else if (propertyName.equals("Area.XTopAxis.Labels.TextBefore")) {
                axisArea.getXTopAxis().getLabels().setTextBefore(value);
            } else if (propertyName.equals("Area.XTopAxis.Labels.TextAfter")) {
                axisArea.getXTopAxis().getLabels().setTextAfter(value);
            } else if (propertyName.equals("Area.XTopAxis.Title.Text")) {
                axisArea.getXTopAxis().getTitle().setText(value);
            } else if (propertyName.equals("Area.YRightAxis.Labels.TextBefore")) {
                axisArea.getYRightAxis().getLabels().setTextBefore(value);
            } else if (propertyName.equals("Area.YRightAxis.Labels.TextAfter")) {
                axisArea.getYRightAxis().getLabels().setTextAfter(value);
            } else if (propertyName.equals("Area.YRightAxis.Title.Text")) {
                axisArea.getYRightAxis().getTitle().setText(value);
            }
        }
        int index = 0;
        for (IStiSeries series : this.getSeries()) {
            String name;
            if (!propertyName.equals(name = String.format("Series%1$s.Title", index++))) continue;
            series.setCoreTitle(value);
        }
    }

    @Override
    public String getString(String propertyName) {
        if (propertyName.equals("Legend.Title")) {
            return this.getLegend().getTitle();
        }
        if (propertyName.equals("SeriesLabels.TextBefore")) {
            return this.getSeriesLabels().getTextBefore();
        }
        if (propertyName.equals("SeriesLabels.TextAfter")) {
            return this.getSeriesLabels().getTextAfter();
        }
        IStiAxisArea axisArea = (IStiAxisArea)(this.area instanceof IStiAxisArea ? this.area : null);
        if (axisArea != null) {
            if (propertyName.equals("Area.XAxis.Labels.TextBefore")) {
                return axisArea.getXAxis().getLabels().getTextBefore();
            }
            if (propertyName.equals("Area.XAxis.Labels.TextAfter")) {
                return axisArea.getXAxis().getLabels().getTextAfter();
            }
            if (propertyName.equals("Area.XAxis.Title.Text")) {
                return axisArea.getXAxis().getTitle().getText();
            }
            if (propertyName.equals("Area.YAxis.Labels.TextBefore")) {
                return axisArea.getYAxis().getLabels().getTextBefore();
            }
            if (propertyName.equals("Area.YAxis.Labels.TextAfter")) {
                return axisArea.getYAxis().getLabels().getTextAfter();
            }
            if (propertyName.equals("Area.YAxis.Title.Text")) {
                return axisArea.getYAxis().getTitle().getText();
            }
            if (propertyName.equals("Area.XTopAxis.Labels.TextBefore")) {
                return axisArea.getXTopAxis().getLabels().getTextBefore();
            }
            if (propertyName.equals("Area.XTopAxis.Labels.TextAfter")) {
                return axisArea.getXTopAxis().getLabels().getTextAfter();
            }
            if (propertyName.equals("Area.XTopAxis.Title.Text")) {
                return axisArea.getXTopAxis().getTitle().getText();
            }
            if (propertyName.equals("Area.YRightAxis.Labels.TextBefore")) {
                return axisArea.getYRightAxis().getLabels().getTextBefore();
            }
            if (propertyName.equals("Area.YRightAxis.Labels.TextAfter")) {
                return axisArea.getYRightAxis().getLabels().getTextAfter();
            }
            if (propertyName.equals("Area.YRightAxis.Title.Text")) {
                return axisArea.getYRightAxis().getTitle().getText();
            }
        }
        int index = 0;
        for (IStiSeries series : this.getSeries()) {
            String name;
            if (!propertyName.equals(name = String.format("Series%1$s.Title", index++))) continue;
            return series.getCoreTitle();
        }
        throw new IllegalArgumentException(String.format("Property with name %1$s", propertyName));
    }

    @Override
    public String[] getAllStrings() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Legend.Title");
        list.add("SeriesLabels.TextBefore");
        list.add("SeriesLabels.TextAfter");
        if (this.getArea() instanceof IStiAxisArea) {
            list.add("Area.XAxis.Labels.TextBefore");
            list.add("Area.XAxis.Labels.TextAfter");
            list.add("Area.XAxis.Title.Text");
            list.add("Area.YAxis.Labels.TextBefore");
            list.add("Area.YAxis.Labels.TextAfter");
            list.add("Area.YAxis.Title.Text");
            list.add("Area.XTopAxis.Labels.TextBefore");
            list.add("Area.XTopAxis.Labels.TextAfter");
            list.add("Area.XTopAxis.Title.Text");
            list.add("Area.YRightAxis.Labels.TextBefore");
            list.add("Area.YRightAxis.Labels.TextAfter");
            list.add("Area.YRightAxis.Title.Text");
        }
        for (int index = 0; index < this.series.size(); ++index) {
            list.add(String.format("Series%1$s.Title", index));
        }
        String[] strs = new String[list.size()];
        return list.toArray(strs);
    }

    @Override
    public Object clone() {
        Object tempVar11;
        Object tempVar6;
        Object tempVar = super.clone();
        StiChart chart = (StiChart)(tempVar instanceof StiChart ? tempVar : null);
        Object tempVar2 = this.getChartInfoV1().clone();
        chart.chartInfoV1 = (StiChartInfoV1)(tempVar2 instanceof StiChartInfoV1 ? tempVar2 : null);
        Object tempVar3 = this.getChartInfoV2().clone();
        chart.chartInfoV2 = (StiChartInfoV2)(tempVar3 instanceof StiChartInfoV2 ? tempVar3 : null);
        Object tempVar4 = this.brush.clone();
        chart.brush = (StiBrush)(tempVar4 instanceof StiBrush ? tempVar4 : null);
        Object tempVar5 = this.border.clone();
        chart.border = (StiBorder)(tempVar5 instanceof StiBorder ? tempVar5 : null);
        chart.sort = this.sort != null ? (ArrayList)this.sort.clone() : null;
        chart.filters = this.filters != null ? (StiFiltersCollection)((tempVar6 = this.filters.clone()) instanceof StiFiltersCollection ? tempVar6 : null) : null;
        if (chart.getTitle() != null) {
            Object tempVar7 = this.getTitle().clone();
            chart.setTitle((IStiChartTitle)(tempVar7 instanceof IStiChartTitle ? tempVar7 : null));
        }
        if (chart.getArea() != null) {
            Object tempVar8 = this.getArea().clone();
            chart.setArea((IStiArea)(tempVar8 instanceof IStiArea ? tempVar8 : null));
        }
        if (chart.getSeriesLabels() != null) {
            Object tempVar9 = this.getSeriesLabels().clone();
            chart.setSeriesLabels((IStiSeriesLabels)(tempVar9 instanceof IStiSeriesLabels ? tempVar9 : null));
        }
        if (chart.getLegend() != null) {
            Object tempVar10 = this.getLegend().clone();
            chart.setLegend((IStiLegend)(tempVar10 instanceof IStiLegend ? tempVar10 : null));
        }
        if (chart.getTable() != null) {
            tempVar11 = this.getTable().clone();
            chart.setTable((IStiChartTable)(tempVar11 instanceof IStiChartTable ? tempVar11 : null));
        }
        chart.setSeries(new StiSeriesCollection());
        for (IStiSeries series : this.series) {
            IStiSeries newSeries = series.clone();
            String oldTitle = ((StiSeries)(newSeries instanceof StiSeries ? newSeries : null)).getTitle().getValue();
            chart.getSeries().add(newSeries, false);
            ((StiSeries)newSeries).getTitle().setValue(oldTitle);
        }
        chart.setConstantLines(new StiConstantLinesCollection());
        for (IStiConstantLines line : this.constantLines) {
            chart.getConstantLines().add(line.clone());
        }
        chart.setStrips(new StiStripsCollection());
        for (IStiStrips strip : this.strips) {
            chart.getStrips().add(strip.clone());
        }
        if (chart.core != null) {
            tempVar11 = this.core.clone();
            chart.core = (StiChartCoreXF)(tempVar11 instanceof StiChartCoreXF ? tempVar11 : null);
            chart.core.setChart(chart);
        }
        return chart;
    }

    @Override
    public void saveState(String stateName) {
        super.saveState(stateName);
        this.getStates().PushInt(stateName, this, "positionValue", this.positionValue);
        this.getStates().PushBool(stateName, this, "isEofValue", this.isEofValue);
        this.getStates().PushBool(stateName, this, "isBofValue", this.isBofValue);
        if (this.getDataSource() != null) {
            this.getDataSource().saveState(stateName);
        }
    }

    @Override
    public void RestoreState(String stateName) {
        super.RestoreState(stateName);
        if (this.getStates().IsExist(stateName, this)) {
            this.isBofValue = this.getStates().PopBool(stateName, this, "isBofValue");
            this.isEofValue = this.getStates().PopBool(stateName, this, "isEofValue");
            this.positionValue = this.getStates().PopInt(stateName, this, "positionValue");
        }
        if (this.getDataSource() != null) {
            this.getDataSource().RestoreState(stateName);
        }
    }

    public EngineOptions.Image GetImage(StiRefObject<Float> zoom) {
        return this.GetImage(zoom, StiExportFormat.None);
    }

    public EngineOptions.Image GetImage(StiRefObject<Float> zoom, StiExportFormat format) {
        return null;
    }

    @Override
    public boolean isExportAsImage(StiExportFormat format) {
        return format != StiExportFormat.ImageSvg;
    }

    @Override
    public final StiFilterEventHandler getFilterMethodHandler() {
        return this.filterMethodHandler;
    }

    @Override
    public final void setFilterMethodHandler(StiFilterEventHandler value) {
        this.filterMethodHandler = value;
    }

    @Override
    @StiDefaulValue(value="And")
    @StiSerializable
    public final StiFilterMode getFilterMode() {
        return this.filterMode;
    }

    @Override
    public final void setFilterMode(StiFilterMode value) {
        this.filterMode = value;
    }

    @Override
    @StiSerializable
    public final StiFiltersCollection getFilters() {
        return this.filters;
    }

    @Override
    public final void setFilters(StiFiltersCollection value) {
        this.filters = value;
    }

    @Override
    @StiDefaulValue(value="true")
    @StiSerializable
    public boolean getFilterOn() {
        return this.filterOn;
    }

    @Override
    public void setFilterOn(boolean value) {
        this.filterOn = value;
    }

    @Override
    @StiSerializable(shortName="br")
    public final StiBorder getBorder() {
        return this.border;
    }

    @Override
    public final void setBorder(StiBorder value) {
        this.border = value instanceof StiBorder ? value : null;
    }

    @Override
    @StiSerializable(shortName="bh")
    public final StiBrush getBrush() {
        return this.brush;
    }

    @Override
    public final void setBrush(StiBrush value) {
        this.brush = value;
    }

    @Override
    @StiSerializable
    public ArrayList<String> getSort() {
        return this.sort;
    }

    @Override
    public void setSort(ArrayList<String> value) {
        this.sort = value;
    }

    @Override
    public StiDataSource getDataSource() {
        if (this.page == null || this.getReport() == null || this.getReport().getDataSources() == null || this.getDataSourceName() == null || this.getDataSourceName().length() == 0) {
            return null;
        }
        return this.getReport().getDataSources().get(this.getDataSourceName());
    }

    public void setDataSource(StiDataSource source) {
        this.setDataSourceName(source.getName());
    }

    @Override
    @StiDefaulValue(value="")
    @StiSerializable
    public final String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public final void setDataSourceName(String value) {
        if (!this.dataSourceName.equals(value)) {
            this.dataSourceName = value;
            EngineOptions.GlobalEvents.InvokeDataSourceAssigned(this, StiEventHandlerArgs.Empty);
        }
    }

    public final boolean getIsDataSourceEmpty() {
        return this.getDataSourceName() == null || this.getDataSourceName().length() == 0 || this.getDataSource() == null;
    }

    @Override
    public final boolean getIsBusinessObjectEmpty() {
        return this.getBusinessObjectGuid() == null || this.getBusinessObjectGuid().length() == 0 || this.getBusinessObject() == null;
    }

    @Override
    public StiBusinessObject getBusinessObject() {
        if (this.page == null || this.getReport() == null || this.getBusinessObjectGuid() == null || this.getBusinessObjectGuid().length() == 0) {
            return null;
        }
        return StiBusinessObjectHelper.getBusinessObjectFromGuid(this.getReport(), this.getBusinessObjectGuid());
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="")
    public final String getBusinessObjectGuid() {
        return this.businessObjectGuid;
    }

    @Override
    public final void setBusinessObjectGuid(String value) {
        if (!this.businessObjectGuid.equals(value)) {
            this.businessObjectGuid = value;
            if (!StiValidationUtil.isNullOrEmpty((String)value)) {
                this.setDataSourceName(null);
            }
            EngineOptions.GlobalEvents.InvokeBusinessObjectAssigned(this, StiEventHandlerArgs.Empty);
        }
    }

    @Override
    @StiSerializable(isRef=true)
    public StiComponent getMasterComponent() {
        return this.masterComponent;
    }

    @Override
    public void setMasterComponent(StiComponent value) {
        this.masterComponent = value;
    }

    @StiDefaulValue(value="0")
    @StiSerializable
    public int getCountData() {
        return this.countData;
    }

    public void setCountData(int value) {
        this.countData = value;
    }

    @Override
    public void First() {
        if (!this.getIsBusinessObjectEmpty()) {
            this.getBusinessObject().first();
        } else if (!this.getIsDataSourceEmpty()) {
            this.getDataSource().First();
        } else {
            this.isEofValue = false;
            this.isBofValue = true;
            this.positionValue = 0;
        }
    }

    @Override
    public void Prior() {
        if (!this.getIsBusinessObjectEmpty()) {
            this.getBusinessObject().prior();
        } else if (!this.getIsDataSourceEmpty()) {
            this.getDataSource().Prior();
        } else {
            this.isBofValue = false;
            this.isEofValue = false;
            if (this.positionValue <= 0) {
                this.isBofValue = true;
            } else {
                --this.positionValue;
            }
        }
    }

    @Override
    public void Next() {
        if (!this.getIsBusinessObjectEmpty()) {
            this.getBusinessObject().next();
        } else if (!this.getIsDataSourceEmpty()) {
            this.getDataSource().Next();
        } else {
            this.isBofValue = false;
            this.isEofValue = false;
            if (this.positionValue >= this.countData - 1) {
                this.isEofValue = true;
            } else {
                ++this.positionValue;
            }
        }
    }

    @Override
    public void Last() {
        if (!this.getIsBusinessObjectEmpty()) {
            this.getBusinessObject().last();
        } else if (!this.getIsDataSourceEmpty()) {
            this.getDataSource().Last();
        } else {
            this.isEofValue = true;
            this.isBofValue = false;
            this.positionValue = this.countData - 1;
        }
    }

    @Override
    public boolean getIsEof() {
        if (!this.getIsBusinessObjectEmpty()) {
            return this.getBusinessObject().getIsEof();
        }
        if (!this.getIsDataSourceEmpty()) {
            return this.getDataSource().getIsEof();
        }
        return this.isEofValue;
    }

    @Override
    public void setIsEof(boolean value) {
        if (!this.getIsBusinessObjectEmpty()) {
            this.getBusinessObject().setIsEof(value);
        } else if (!this.getIsDataSourceEmpty()) {
            this.getDataSource().setIsEof(value);
        } else {
            this.isEofValue = value;
        }
    }

    @Override
    public boolean getIsBof() {
        if (!this.getIsBusinessObjectEmpty()) {
            return this.getBusinessObject().isBof();
        }
        if (!this.getIsDataSourceEmpty()) {
            return this.getDataSource().getIsBof();
        }
        return this.isBofValue;
    }

    @Override
    public void setIsBof(boolean value) {
        if (!this.getIsBusinessObjectEmpty()) {
            this.getBusinessObject().setIsBof(value);
        } else if (!this.getIsDataSourceEmpty()) {
            this.getDataSource().setIsBof(value);
        } else {
            this.isBofValue = value;
        }
    }

    @Override
    public boolean getIsEmpty() {
        if (!this.getIsBusinessObjectEmpty()) {
            return this.getBusinessObject().isEmpty();
        }
        if (!this.getIsDataSourceEmpty()) {
            return this.getDataSource().isEmpty();
        }
        return this.getCountData() == 0;
    }

    @Override
    public int getPosition() {
        if (!this.getIsBusinessObjectEmpty()) {
            return this.getBusinessObject().Position;
        }
        if (!this.getIsDataSourceEmpty()) {
            return this.getDataSource().getPosition();
        }
        return this.positionValue;
    }

    @Override
    public void setPosition(int value) {
        if (!this.getIsBusinessObjectEmpty()) {
            this.getBusinessObject().Position = value;
        } else if (!this.getIsDataSourceEmpty()) {
            this.getDataSource().setPosition(value);
        } else {
            this.positionValue = value;
        }
    }

    @Override
    public int getCount() {
        if (!this.getIsBusinessObjectEmpty()) {
            return this.getBusinessObject().size();
        }
        if (!this.getIsDataSourceEmpty()) {
            return this.getDataSource().size();
        }
        return this.countData;
    }

    @Override
    public StiDataRelation getDataRelation() {
        if (this.getPage() == null || this.getReport() == null || this.getReport().getDictionary() == null || this.getReport().getDictionary().getRelations() == null || this.getDataRelationName() == null || this.getDataRelationName().length() == 0) {
            return null;
        }
        return this.getReport().getDictionary().getRelations().get(this.getDataRelationName());
    }

    @Override
    public boolean existDataRelation() {
        if (this.getPage() == null || this.getReport() == null || this.getReport().getDictionary() == null || this.getReport().getDictionary().getRelations() == null || this.getDataRelationName() == null || this.getDataRelationName().length() == 0) {
            return false;
        }
        return this.getReport().getDictionary().getRelations().exist(this.getDataRelationName());
    }

    @Override
    @StiDefaulValue(value="")
    @StiSerializable
    public final String getDataRelationName() {
        return this.dataRelationName;
    }

    @Override
    public final void setDataRelationName(String value) {
        this.dataRelationName = value;
    }

    @Override
    @StiSerializable(need=false)
    public boolean getCanShrink() {
        return super.getCanShrink();
    }

    @Override
    public void setCanShrink(boolean value) {
    }

    @Override
    @StiSerializable(need=false)
    public boolean getCanGrow() {
        return super.getCanGrow();
    }

    @Override
    public void setCanGrow(boolean value) {
    }

    @Override
    @StiDefaulValue(value="false")
    @StiSerializable
    public boolean getProcessAtEnd() {
        return this.processAtEnd;
    }

    @Override
    public void setProcessAtEnd(boolean value) {
        this.processAtEnd = value;
    }

    @Override
    public int getPriority() {
        return StiComponentPriority.Component.getValue();
    }

    @Override
    public String getLocalizedCategory() {
        return StiLocalization.Get((String)"Report", (String)"Components");
    }

    @Override
    public StiRectangle getDefaultClientRectangle() {
        return new StiRectangle(0L, 0L, 200L, 200L);
    }

    @Override
    public StiComponentType getComponentType() {
        return StiComponentType.Simple;
    }

    @Override
    public int getToolboxPosition() {
        return StiComponentToolboxPosition.Chart.getValue();
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Components", (String)"StiChart");
    }

    @Override
    public void invokeEvents() {
        super.invokeEvents();
        this.InvokeProcessChart(this, StiEventHandlerArgs.Empty);
    }

    protected void OnProcessChart(StiEventHandlerArgs e) {
    }

    public final void InvokeProcessChart(Object sender, StiEventHandlerArgs e) {
        this.OnProcessChart(e);
    }

    @StiSerializable
    public StiProcessChartEvent getProcessChartEvent() {
        return this.processChartEvent;
    }

    public void setProcessChartEvent(StiProcessChartEvent value) {
        this.processChartEvent = value;
    }

    @Override
    @StiSerializable
    public StiChartConditionsCollection getSeriesLabelsConditions() {
        return this.seriesLabelsConditions;
    }

    @Override
    public void setSeriesLabelsConditions(StiChartConditionsCollection value) {
        this.seriesLabelsConditions = value;
    }

    @Deprecated
    public final IStiArea getChartType() {
        return this.getArea();
    }

    @Deprecated
    public final void setChartType(IStiArea value) {
        this.setArea(value);
    }

    @Override
    public String getComponentStyle() {
        return super.getComponentStyle();
    }

    @Override
    public void setComponentStyle(String value) {
        super.setComponentStyle(value);
    }

    public StiChart() {
        this(new StiRectangle(0L, 0L, 0L, 0L));
    }

    public StiChart(StiRectangle rect) {
        super(rect);
        this.allowApplyStyle = StiOptions.Engine.getDefaultValueOfAllowApplyStyleProperty();
        this.setPlaceOnToolbox(true);
        this.setLegend(new StiLegend());
        this.setSeries(new StiSeriesCollection());
        this.setArea(new StiClusteredColumnArea());
        this.setSeriesLabels(new StiCenterAxisLabels());
        this.setConstantLines(new StiConstantLinesCollection());
        this.setStrips(new StiStripsCollection());
        this.setTitle(new StiChartTitle());
        this.setTable(new StiChartTable());
        this.core = new StiChartCoreXF(this);
        this.getCore().applyStyle(this.getStyle());
    }

    public final StiChartCoreXF getCore() {
        return this.core;
    }

    public final void setCore(StiChartCoreXF value) {
        this.core = value;
    }

    @StiDefaulValue(value="None")
    @StiSerializable
    public final StiImageRotation getRotation() {
        return this.rotation;
    }

    public final void setRotation(StiImageRotation value) {
        this.rotation = value;
    }

    @Override
    @StiSerializable
    public final StiSeriesCollection getSeries() {
        return this.series;
    }

    @Override
    public final void setSeries(StiSeriesCollection value) {
        this.series = value;
        this.series.setChart(this);
    }

    @Override
    @StiSerializable
    public final IStiArea getArea() {
        return this.area;
    }

    @Override
    public final void setArea(IStiArea value) {
        if (this.area != value) {
            if (value instanceof StiRadarArea) {
                this.area = value;
            }
            this.area = value;
            if (value != null) {
                this.area.setChart(this);
            } else {
                this.area = null;
            }
        }
    }

    @Override
    @StiSerializable
    public IStiChartTable getTable() {
        return this.table;
    }

    @Override
    public void setTable(IStiChartTable table) {
        if (table != null) {
            this.table = table;
            table.setChart(this);
        }
    }

    @Override
    @StiSerializable
    public final IStiChartStyle getStyle() {
        return this.style;
    }

    @Override
    public final void setStyle(IStiChartStyle value) {
        if (this.style != value) {
            this.style = value;
            if (value != null) {
                value.getCore().setChart(this);
            }
        }
    }

    @StiSerializable
    @StiDefaulValue(value="true")
    public final boolean getAllowApplyStyle() {
        return this.allowApplyStyle;
    }

    public final void setAllowApplyStyle(boolean value) {
        if (this.allowApplyStyle != value) {
            this.allowApplyStyle = value;
            if (value) {
                this.getCore().applyStyle(this.getStyle());
            }
        }
    }

    @StiSerializable
    public final String getCustomStyleName() {
        return this.customStyleName;
    }

    public final void setCustomStyleName(String value) {
        this.customStyleName = value;
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="10")
    public final int getHorSpacing() {
        return this.horSpacing;
    }

    @Override
    public final void setHorSpacing(int value) {
        if (value >= 0) {
            this.horSpacing = value;
        }
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="10")
    public final int getVertSpacing() {
        return this.vertSpacing;
    }

    @Override
    public final void setVertSpacing(int value) {
        if (value >= 0) {
            this.vertSpacing = value;
        }
    }

    @Override
    @StiSerializable
    public final IStiSeriesLabels getSeriesLabels() {
        return this.seriesLabels;
    }

    @Override
    public final void setSeriesLabels(IStiSeriesLabels value) {
        this.seriesLabels = value;
        if (value != null) {
            this.seriesLabels.setChart(this);
        }
    }

    @Override
    @StiSerializable
    public final IStiLegend getLegend() {
        return this.legend;
    }

    @Override
    public final void setLegend(IStiLegend value) {
        if (value == null) {
            throw new RuntimeException();
        }
        this.legend = value;
        this.legend.setChart(this);
    }

    @Override
    @StiSerializable
    public final IStiChartTitle getTitle() {
        return this.title;
    }

    @Override
    public final void setTitle(IStiChartTitle value) {
        if (this.title != value) {
            this.title = value;
            this.title.setChart(this);
        }
    }

    @Override
    @StiSerializable
    public StiStripsCollection getStrips() {
        return this.strips;
    }

    @Override
    public void setStrips(StiStripsCollection value) {
        this.strips = value;
        this.strips.setChart(this);
    }

    @Override
    @StiSerializable
    public StiConstantLinesCollection getConstantLines() {
        return this.constantLines;
    }

    @Override
    public void setConstantLines(StiConstantLinesCollection value) {
        this.constantLines = value;
        this.constantLines.setChart(this);
    }

    public final StiChartInfoV1 getChartInfoV1() {
        return this.chartInfoV1;
    }

    public final StiChartInfoV2 getChartInfoV2() {
        return this.chartInfoV2;
    }

    public final void RenderAtEnd() {
        StiChartV2Builder.RenderAtEnd(this);
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.RemoveProperty("CanShrink");
        jObject.RemoveProperty("CanGrow");
        jObject.AddPropertyEnum("FilterMode", (Enum)this.getFilterMode(), (Enum)StiFilterMode.And);
        jObject.AddPropertyBool("FilterOn", this.getFilterOn(), true);
        jObject.AddPropertyStringNullOfEmpty("Border", StiJsonReportObjectHelper.Serialize.JBorder((StiBorder)this.getBorder()));
        jObject.AddPropertyStringNullOfEmpty("Brush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.getBrush()));
        jObject.AddPropertyStringNullOfEmpty("DataSourceName", this.getDataSourceName());
        jObject.AddPropertyStringNullOfEmpty("BusinessObjectGuid", this.getBusinessObjectGuid());
        jObject.AddPropertyInt("CountData", this.getCountData());
        jObject.AddPropertyStringNullOfEmpty("DataRelationName", this.getDataRelationName());
        jObject.AddPropertyBool("ProcessAtEnd", this.getProcessAtEnd());
        jObject.AddPropertyJObject("ProcessChartEvent", this.getProcessChartEvent().SaveToJsonObject(mode));
        jObject.AddPropertyEnum("Rotation", (Enum)this.getRotation(), (Enum)StiImageRotation.None);
        jObject.AddPropertyStringNullOfEmpty("CustomStyleName", this.getCustomStyleName());
        jObject.AddPropertyInt("HorSpacing", this.getHorSpacing(), 10);
        jObject.AddPropertyInt("VertSpacing", this.getVertSpacing(), 10);
        if (this.masterComponent != null) {
            jObject.AddPropertyStringNullOfEmpty("MasterComponent", this.getMasterComponent().getName());
        }
        jObject.AddPropertyJObject("Series", this.getSeries().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("Area", this.getArea().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("Table", this.getTable().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("SeriesLabels", this.getSeriesLabels().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("Legend", this.getLegend().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("Title", this.getTitle().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("Strips", this.getStrips().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("ConstantLines", this.getConstantLines().SaveToJsonObject(mode));
        jObject.AddPropertyBool("AllowApplyStyle", this.getAllowApplyStyle(), true);
        jObject.AddPropertyJObject("Style", this.getStyle().SaveToJsonObject(mode));
        if (mode == StiJsonSaveMode.Report) {
            jObject.AddPropertyJObject("Filters", this.getFilters().SaveToJsonObject(mode));
            jObject.AddPropertyJObject("Sort", StiJsonReportObjectHelper.Serialize.StringArray(this.getSort()));
            jObject.AddPropertyJObject("SeriesLabelsConditions", this.getSeriesLabelsConditions().SaveToJsonObject(mode));
        }
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("FilterMode")) {
                this.filterMode = StiFilterMode.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("Filters")) {
                this.filters.LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("FilterOn")) {
                this.filterOn = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("Border")) {
                this.border = StiJsonReportObjectHelper.Deserialize.Border((JProperty)property);
                continue;
            }
            if (property.Name.equals("Brush")) {
                this.brush = StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property);
                continue;
            }
            if (property.Name.equals("DataSourceName")) {
                this.dataSourceName = (String)property.Value;
                continue;
            }
            if (property.Name.equals("BusinessObjectGuid")) {
                this.businessObjectGuid = (String)property.Value;
                continue;
            }
            if (property.Name.equals("CountData")) {
                this.countData = (Integer)property.Value;
                continue;
            }
            if (property.Name.equals("DataRelationName")) {
                this.dataRelationName = (String)property.Value;
                continue;
            }
            if (property.Name.equals("ProcessAtEnd")) {
                this.processAtEnd = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("ProcessChartEvent")) {
                StiProcessChartEvent _event = new StiProcessChartEvent();
                _event.LoadFromJsonObject((JSONObject)property.Value);
                this.processChartEvent = _event;
                continue;
            }
            if (property.Name.equals("SeriesLabelsConditions")) {
                this.seriesLabelsConditions.LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("Rotation")) {
                this.rotation = StiImageRotation.valueOf((String)property.Value);
                continue;
            }
            if (property.Name.equals("AllowApplyStyle")) {
                this.setAllowApplyStyle((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("CustomStyleName")) {
                this.customStyleName = (String)property.Value;
                continue;
            }
            if (property.Name.equals("HorSpacing")) {
                this.horSpacing = (Integer)property.Value;
                continue;
            }
            if (property.Name.equals("VertSpacing")) {
                this.vertSpacing = (Integer)property.Value;
                continue;
            }
            if (property.Name.equals("MasterComponent")) {
                this.jsonMasterComponentTemp = (String)property.Value;
                this.getReport().getJsonLoaderHelper().MasterComponents.add(this);
                continue;
            }
            if (property.Name.equals("Style")) {
                this.setStyle(StiChartStyle.LoadFromJsonObjectInternal((JSONObject)property.Value));
                continue;
            }
            if (property.Name.equals("ConstantLines")) {
                this.getConstantLines().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("Strips")) {
                this.getStrips().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("Title")) {
                this.getTitle().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("Legend")) {
                this.getLegend().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("SeriesLabels")) {
                this.setSeriesLabels(StiSeriesLabels.LoadFromJsonObjectInternal((JSONObject)property.Value, this));
                continue;
            }
            if (property.Name.equals("Table")) {
                this.table.LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("Area")) {
                this.area = StiArea.LoadFromJsonObjectInternal((JSONObject)property.Value);
                this.area.setChart(this);
                continue;
            }
            if (!property.Name.equals("Series")) continue;
            this.series.LoadFromJsonObject((JSONObject)property.Value);
        }
    }

    public boolean isAnimationChangingValues() {
        return this.isAnimationChangingValues;
    }

    public void setAnimationChangingValues(boolean value) {
        if (this.isAnimationChangingValues != value) {
            this.isAnimationChangingValues = value;
            this.isAnimation = value;
        }
    }

    public void simplifyValues() {
        for (int seriesIndex = 0; seriesIndex < this.getSeries().size(); ++seriesIndex) {
            IStiSeries series = (IStiSeries)this.getSeries().get(seriesIndex);
            if (series.getValues().length <= 800) continue;
            List<StiPoint> shorterListPoints = StiChartHelper.getShorterListPoints((StiSeries)series);
            series.setValues(new Double[shorterListPoints.size()]);
            series.setArguments(new Object[shorterListPoints.size()]);
            for (int index = 0; index < shorterListPoints.size(); ++index) {
                series.getValues()[index] = shorterListPoints.get((int)index).x;
                series.getArguments()[index] = shorterListPoints.get((int)index).y;
            }
        }
    }
}

