/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.axis;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiFontGeom;
import com.stimulsoft.base.context.chart.geoms.StiStringFormatGeom;
import com.stimulsoft.base.drawing.enums.StiStringAlignment;
import com.stimulsoft.base.drawing.enums.StiStringFormatFlags;
import com.stimulsoft.base.drawing.enums.StiStringTrimming;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.chart.core.axis.StiAxisInfoXF;
import com.stimulsoft.report.chart.core.axis.StiXAxisCoreXF;
import com.stimulsoft.report.chart.core.axis.StiYAxisCoreXF;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripLineXF;
import com.stimulsoft.report.chart.enums.StiLabelsPlacement;
import com.stimulsoft.report.chart.enums.StiMarkerAlignment;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.interfaces.IStiApplyStyle;
import com.stimulsoft.report.chart.interfaces.axis.IStiAxis;
import com.stimulsoft.report.chart.interfaces.axis.IStiYAxis;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;
import com.stimulsoft.report.chart.view.series.scatter.StiScatterSeries;

public abstract class StiAxisCoreXF
implements Cloneable,
IStiApplyStyle {
    private boolean isMouseOverDecreaseButton = false;
    private boolean isMouseOverIncreaseButton = false;
    private boolean isMouseOverTrackBar = false;
    public static float DefaultScrollBarSize = 12.0f;
    public static float DefaultScrollBarSmallFactor = 0.01f;
    public static float DefaultScrollBarFirstRecallTime = 0.3f;
    public static float DefaultScrollBarOtherRecallTime = 0.05f;
    private IStiAxis axis;

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public final boolean getIsMouseOverDecreaseButton() {
        return this.isMouseOverDecreaseButton;
    }

    public final void setIsMouseOverDecreaseButton(boolean value) {
        this.isMouseOverDecreaseButton = value;
    }

    public final boolean getIsMouseOverIncreaseButton() {
        return this.isMouseOverIncreaseButton;
    }

    public final void setIsMouseOverIncreaseButton(boolean value) {
        this.isMouseOverIncreaseButton = value;
    }

    public final boolean getIsMouseOverTrackBar() {
        return this.isMouseOverTrackBar;
    }

    public final void setIsMouseOverTrackBar(boolean value) {
        this.isMouseOverTrackBar = value;
    }

    @Override
    public void applyStyle(IStiChartStyle style) {
        if (this.getAxis().getAllowApplyStyle()) {
            this.getAxis().setLineColor(style.getCore().getAxisLineColor());
            this.getAxis().getLabels().getCore().applyStyle(style);
            this.getAxis().getTitle().getCore().applyStyle(style);
        }
    }

    public boolean GetStartFromZero() {
        if (this.getAxis() != null && this.getAxis().getRange() != null && !this.getAxis().getRange().getAuto()) {
            return true;
        }
        return this.getAxis() != null ? this.getAxis().getStartFromZero() : true;
    }

    public abstract StiCellGeom Render(StiContext var1, StiRectangle var2);

    public abstract StiCellGeom RenderView(StiContext var1, StiRectangle var2);

    public final void CalculateStripPositions(double topPosition, double bottomPosition) {
        bottomPosition -= topPosition;
        topPosition = 0.0;
        if (this.getAxis().getInfo().StripLines == null || this.getAxis().getInfo().StripLines.size() < 2) {
            this.getAxis().getInfo().StripPositions = new double[0];
        } else {
            boolean isScatterSeries = false;
            if (this.getAxis().getArea().getChart().getSeries().size() > 0 && this.getAxis().getArea().getChart().getSeries().get(0) instanceof StiScatterSeries) {
                isScatterSeries = true;
            }
            if (this.getAxis().getLogarithmicScale() && isScatterSeries) {
                int countStrip = this.getAxis().getInfo().StripLines.size();
                this.getAxis().getInfo().StripPositions = new double[this.getAxis().getInfo().StripLines.size()];
                this.getAxis().getInfo().StripPositions[0] = topPosition;
                this.getAxis().getInfo().StripPositions[this.getAxis().getInfo().StripPositions.length - 1] = bottomPosition;
                double startValue = ((StiStripLineXF)this.getAxis().getInfo().StripLines.get(0)).getValue();
                double endValue = ((StiStripLineXF)this.getAxis().getInfo().StripLines.get(countStrip - 1)).getValue();
                double decadeX = bottomPosition / (Math.log10(endValue) - Math.log10(startValue));
                for (int index = 1; index < this.getAxis().getInfo().StripPositions.length - 1; ++index) {
                    double value = ((StiStripLineXF)this.getAxis().getInfo().StripLines.get(index)).getValue();
                    double x = Math.abs(Math.log10(Math.abs(((StiStripLineXF)this.getAxis().getInfo().StripLines.get(index)).getValue())) * decadeX - Math.log10(Math.abs(((StiStripLineXF)this.getAxis().getInfo().StripLines.get(index - 1)).getValue())) * decadeX);
                    this.getAxis().getInfo().StripPositions[index] = (float)(topPosition + x);
                    topPosition = this.getAxis().getInfo().StripPositions[index];
                }
            } else {
                this.getAxis().getInfo().StripPositions = new double[this.getAxis().getInfo().StripLines.size()];
                this.getAxis().getInfo().StripPositions[0] = topPosition;
                this.getAxis().getInfo().StripPositions[this.getAxis().getInfo().StripPositions.length - 1] = bottomPosition;
                for (int index = 1; index < this.getAxis().getInfo().StripPositions.length - 1; ++index) {
                    this.getAxis().getInfo().StripPositions[index] = topPosition + (double)((float)index * this.getAxis().getInfo().Step);
                }
            }
        }
    }

    protected final double GetTicksMaxLength(StiContext context) {
        return this.getAxis().getCore().getTicksMaxLength() * (float)context.Options.zoom;
    }

    protected final float GetArrowHeight(StiContext context) {
        return this.getAxis().getCore().getArrowHeight() * 4.0f * (float)context.Options.zoom;
    }

    protected final float GetLabelsSpaceAxis(StiContext context) {
        return 5 * context.Options.zoom;
    }

    protected final float GetLabelsTwoLinesDestination(StiContext context) {
        return (float)this.getAxis().getLabels().getFont().getSize() * 2.0f * (float)context.Options.zoom;
    }

    public final StiFontGeom GetFontGeom(StiContext context) {
        StiFontGeom font = StiFontGeom.ChangeFontSize((StiFont)this.getAxis().getLabels().getFont(), (double)(this.getAxis().getLabels().getFont().size * (double)context.Options.zoom));
        return font;
    }

    protected final StiMarkerAlignment GetTextAlignment() {
        if (this.getAxis() instanceof IStiYAxis) {
            IStiAxis tempVar = this.getAxis();
            IStiYAxis yAxis = (IStiYAxis)(tempVar instanceof IStiYAxis ? tempVar : null);
            if (this.getAxis().getLabels().getPlacement() == StiLabelsPlacement.TwoLines) {
                if (((StiYAxisCoreXF)yAxis.getCore()).getIsLeftSide()) {
                    return StiMarkerAlignment.Right;
                }
                if (((StiYAxisCoreXF)yAxis.getCore()).getIsRightSide()) {
                    return StiMarkerAlignment.Left;
                }
            }
        }
        return this.getAxis().getLabels().getTextAlignment();
    }

    public final StiStringFormatGeom GetStringFormatGeom(StiContext context) {
        StiStringFormatGeom sf = context.GetGenericStringFormat();
        sf.setTrimming(StiStringTrimming.None);
        if (!this.getAxis().getLabels().getWordWrap()) {
            sf.getFormatFlags().OR((IStiEnum)StiStringFormatFlags.MeasureTrailingSpaces);
            sf.getFormatFlags().OR((IStiEnum)StiStringFormatFlags.NoWrap);
        }
        if (this.getAxis().getLabels().getWidth() > 0.0f) {
            StiMarkerAlignment alignment = this.GetTextAlignment();
            if (alignment == StiMarkerAlignment.Left) {
                sf.setAlignment(StiStringAlignment.Near);
            } else {
                sf.setAlignment(StiStringAlignment.Far);
            }
        }
        return sf;
    }

    protected final StiSize GetAxisTitleSize(StiContext context) {
        if (StiValidationUtil.isNullOrEmpty((String)this.getAxis().getTitle().getText())) {
            return StiSize.getEmpty();
        }
        StiFontGeom font = StiFontGeom.ChangeFontSize((StiFont)this.getAxis().getTitle().getFont(), (double)(this.getAxis().getTitle().getFont().size * (double)context.Options.zoom));
        StiSize sizeF = context.MeasureString(this.getAxis().getTitle().getText(), font);
        switch (this.getAxis().getTitle().getDirection()) {
            case LeftToRight: 
            case RightToLeft: {
                return sizeF;
            }
            case BottomToTop: 
            case TopToBottom: {
                return new StiSize(sizeF.height, sizeF.width);
            }
        }
        return StiSize.getEmpty();
    }

    public final float getTicksMaxLength() {
        if (this.getAxis().getVisible()) {
            return Math.max(this.getAxis().getTicks().getVisible() ? this.getAxis().getTicks().getLength() : 0.0f, this.getAxis().getTicks().getMinorVisible() ? this.getAxis().getTicks().getMinorLength() : 0.0f);
        }
        return 0.0f;
    }

    public final float getArrowWidth() {
        return 3.0f;
    }

    public final float getArrowHeight() {
        if (this instanceof StiXAxisCoreXF) {
            if (this.getAxis().getArea().getReverseHor()) {
                return -5.0f;
            }
            return 5.0f;
        }
        if (this instanceof StiYAxisCoreXF) {
            if (this.getAxis().getArea().getReverseVert()) {
                return -5.0f;
            }
            return 5.0f;
        }
        return 0.0f;
    }

    public final IStiAxis getAxis() {
        return this.axis;
    }

    public final void setAxis(IStiAxis value) {
        this.axis = value;
    }

    public final StiAxisInfoXF getInfo() {
        return this.getAxis().getInfo();
    }

    public final void setInfo(StiAxisInfoXF value) {
        this.getAxis().setInfo(value);
    }

    public StiAxisCoreXF(IStiAxis axis) {
        this.axis = axis;
    }
}

