/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.series.candlestick;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripLineXF;
import com.stimulsoft.report.chart.core.series.StiSeriesCoreXF;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.financial.StiCandlestickSeriesElementGeom;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.candlestick.IStiCandlestickArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.candlestick.IStiCandlestickSeries;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;
import com.stimulsoft.report.chart.view.series.StiSeriesInteractionData;

public class StiCandlestickSeriesCoreXF
extends StiSeriesCoreXF {
    @Override
    public void ApplyStyle(IStiChartStyle style, StiColor color) {
        super.ApplyStyle(style, color);
        if (this.getSeries().getAllowApplyStyle()) {
            ((IStiCandlestickSeries)this.getSeries()).setBrush(style.getCore().GetColumnBrush(color));
            ((IStiCandlestickSeries)this.getSeries()).setBorderColor(style.getCore().GetColumnBorder(color));
        }
    }

    @Override
    public void RenderSeries(StiContext context, StiRectangle rect, StiAreaGeom geom, IStiSeries[] series) {
        if (series == null || series.length == 0 || this.getSeries().getChart() == null) {
            return;
        }
        IStiArea tempVar = geom.getArea();
        IStiCandlestickArea candlestickArea = (IStiCandlestickArea)(tempVar instanceof IStiCandlestickArea ? tempVar : null);
        double posY = candlestickArea.getAxisCore().GetDividerY();
        Integer time = StiChartHelper.GlobalBeginTimeElement;
        for (IStiSeries currentSeries1 : series) {
            IStiCandlestickSeries currentSeries = (IStiCandlestickSeries)currentSeries1;
            Double[] values = currentSeries.getValuesOpen();
            Double[] valuesEnd = currentSeries.getValuesClose();
            Double[] valuesHigh = currentSeries.getValuesHigh();
            Double[] valuesLow = currentSeries.getValuesLow();
            int valueCount = Math.min(Math.min(values.length, valuesEnd.length), Math.min(valuesHigh.length, valuesLow.length));
            int argumentCount = currentSeries.getArguments().length;
            int count = Math.min(valueCount, argumentCount);
            for (int index = 0; index < count; ++index) {
                double lowCandle;
                double highCandle;
                double bodyEnd;
                StiColor candlestickBorderColor;
                Double value = values[index];
                Double valueEnd = valuesEnd[index];
                Double valueHigh = valuesHigh[index];
                Double valueLow = valuesLow[index];
                if (value == null || valueEnd == null || valueHigh == null || valueLow == null) continue;
                int argumentIndex = 0;
                for (StiStripLineXF line : candlestickArea.getXAxis().getInfo().StripLines) {
                    if (currentSeries.getArguments()[index].toString().equals(line.getValueObject().toString())) break;
                    ++argumentIndex;
                }
                double singleX = candlestickArea.getXAxis().getInfo().Dpi;
                StiSolidBrush candlestickBrush = new StiSolidBrush();
                if (value > valueEnd) {
                    candlestickBrush = currentSeries.getBrush();
                    candlestickBorderColor = currentSeries.getBorderColor();
                    if (valueHigh < value) {
                        valueHigh = value;
                    }
                    if (valueEnd < valueLow) {
                        valueLow = valueEnd;
                    }
                } else {
                    candlestickBrush = currentSeries.getBrushNegative();
                    candlestickBorderColor = currentSeries.getBorderColorNegative();
                    if (valueLow > value) {
                        valueLow = value;
                    }
                    if (valueEnd > valueHigh) {
                        valueHigh = valueEnd;
                    }
                    value = valuesEnd[index];
                    valueEnd = values[index];
                }
                if (candlestickArea.getReverseVert() && value > valueEnd) {
                    Double temp = value;
                    value = valueEnd;
                    valueEnd = temp;
                    temp = valueLow;
                    valueLow = valueHigh;
                    valueHigh = temp;
                }
                float singleY = (float)candlestickArea.getYAxis().getInfo().Dpi;
                double positionX = (double)argumentIndex * singleX;
                double bodyStart = Math.abs(posY - value * (double)singleY);
                StiRectangle clientRect = new StiRectangle(positionX - singleX / 4.0, bodyStart, singleX / 2.0, (bodyEnd = Math.abs(posY - valueEnd * (double)singleY)) - bodyStart);
                StiCandlestickSeriesElementGeom candlestickGeom = new StiCandlestickSeriesElementGeom(geom, currentSeries, clientRect, bodyStart, bodyEnd, highCandle = Math.abs(posY - valueHigh * (double)singleY), lowCandle = Math.abs(posY - valueLow * (double)singleY), positionX, argumentIndex - 1, (StiBrush)candlestickBrush, candlestickBorderColor, time / valueCount * index);
                if (candlestickGeom != null && currentSeries.getCore().getInteraction() != null) {
                    StiSeriesInteractionData data = new StiSeriesInteractionData();
                    data.Fill(geom.getArea(), currentSeries, index);
                    candlestickGeom.setInteraction(data);
                }
                geom.CreateChildGeoms();
                geom.getChildGeoms().add(candlestickGeom);
            }
        }
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Chart", (String)"Candlestick");
    }

    public StiCandlestickSeriesCoreXF(IStiSeries series) {
        super(series);
    }
}

