/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.series.gantt;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.core.area.StiAxisAreaCoreXF;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripLineXF;
import com.stimulsoft.report.chart.core.series.clusteredBar.StiClusteredBarSeriesCoreXF;
import com.stimulsoft.report.chart.core.seriesLabels.axis.StiAxisSeriesLabelsCoreXF;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.gantt.StiGanttSeriesElementGeom;
import com.stimulsoft.report.chart.geoms.seriesLabels.StiSeriesLabelsGeom;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.gantt.IStiGanttArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.gantt.IStiGanttSeries;
import com.stimulsoft.report.chart.interfaces.seriesLabels.axis.IStiAxisSeriesLabels;
import com.stimulsoft.report.chart.view.series.StiSeriesInteractionData;
import java.util.ArrayList;

public class StiGanttSeriesCoreXF
extends StiClusteredBarSeriesCoreXF {
    @Override
    public void RenderSeries(StiContext context, StiRectangle rect, StiAreaGeom geom, IStiSeries[] series) {
        ArrayList<StiSeriesLabelsGeom> seriesLabelsList = new ArrayList<StiSeriesLabelsGeom>();
        if (series == null || series.length == 0 || this.getSeries().getChart() == null) {
            return;
        }
        IStiArea tempVar = geom.getArea();
        IStiGanttArea ganttArea = (IStiGanttArea)(tempVar instanceof IStiGanttArea ? tempVar : null);
        IStiSeries tempVar2 = this.getSeries();
        IStiGanttSeries gSeries = (IStiGanttSeries)(tempVar2 instanceof IStiGanttSeries ? tempVar2 : null);
        double posX = ganttArea.getAxisCore().GetDividerX();
        double posY = ganttArea.getAxisCore().GetDividerY();
        int colorCount = ganttArea.getAxisCore().ValuesCount * series.length;
        for (IStiSeries currSeries1 : series) {
            IStiGanttSeries currSeries = (IStiGanttSeries)currSeries1;
            int valuesCount = currSeries.getValues().length;
            if (currSeries.getValuesEnd().length < valuesCount) {
                valuesCount = currSeries.getValuesEnd().length;
            }
            int argumentsCount = currSeries.getArguments().length;
            int count = Math.min(valuesCount, argumentsCount);
            Integer time = StiChartHelper.GlobalBeginTimeElement;
            StiChart chart = (StiChart)this.getSeries().getChart();
            for (int index = 0; index < count; ++index) {
                Double nullableValue = currSeries.getValues()[index];
                Double nullableValueEnd = currSeries.getValuesEnd()[index];
                if (nullableValue == null) {
                    nullableValue = 0.0;
                }
                if (nullableValueEnd == null) {
                    nullableValueEnd = 0.0;
                }
                double seriesWidth = Math.abs(nullableValue - nullableValueEnd) * ganttArea.getXAxis().getInfo().Dpi;
                double seriesLeftPos = posX;
                double value = Math.min(nullableValue, nullableValueEnd);
                seriesLeftPos = ganttArea.getReverseHor() ? (seriesLeftPos -= value * ganttArea.getXAxis().getInfo().Dpi + seriesWidth) : (seriesLeftPos += value * ganttArea.getXAxis().getInfo().Dpi);
                int argumentIndex = ganttArea.getYAxis().getInfo().StripLines.size() - 1;
                for (StiStripLineXF line : ganttArea.getYAxis().getInfo().StripLines) {
                    if (currSeries.getArguments()[index].toString().equals(line.getValueObject().toString())) break;
                    --argumentIndex;
                }
                if (ganttArea.getReverseVert()) {
                    argumentIndex = ganttArea.getYAxis().getInfo().StripLines.size() - 1 - argumentIndex;
                }
                double seriesHeight = ganttArea.getYAxis().getInfo().Step / 2.0f;
                double seriesTopPos = posY - seriesHeight / 2.0;
                seriesTopPos = ganttArea.getReverseVert() ? (seriesTopPos += (double)(ganttArea.getYAxis().getInfo().Step * (float)argumentIndex)) : (seriesTopPos -= (double)(ganttArea.getYAxis().getInfo().Step * (float)argumentIndex));
                StiRectangle seriesRect = new StiRectangle(seriesLeftPos, seriesTopPos, seriesWidth, seriesHeight);
                StiGanttSeriesElementGeom seriesGeom = new StiGanttSeriesElementGeom(geom, value, index, currSeries, seriesRect, time / ((StiAxisAreaCoreXF)ganttArea.getCore()).ValuesCount * index);
                if (currSeries.getCore().getInteraction() != null) {
                    StiSeriesInteractionData data = new StiSeriesInteractionData();
                    data.Fill(ganttArea, currSeries, index);
                    seriesGeom.setInteraction(data);
                }
                geom.CreateChildGeoms();
                geom.getChildGeoms().add(seriesGeom);
                IStiAxisSeriesLabels labels = currSeries.getCore().GetSeriesLabels();
                if (labels == null || !labels.getVisible()) continue;
                StiPoint pointValueEndLabels = new StiPoint((double)((float)seriesLeftPos), seriesTopPos + seriesHeight / 2.0);
                StiPoint pointValueLabels = new StiPoint((double)((float)seriesLeftPos + (float)seriesWidth), seriesTopPos + seriesHeight / 2.0);
                if (labels.getStep() != 0 && index % labels.getStep() != 0) continue;
                if (nullableValueEnd < nullableValue) {
                    Double temp = nullableValue;
                    nullableValue = nullableValueEnd;
                    nullableValueEnd = temp;
                }
                StiSeriesLabelsGeom seriesValueLabelsGeom = ((StiAxisSeriesLabelsCoreXF)labels.getCore()).RenderLabel(currSeries, context, pointValueLabels, pointValueLabels, index, nullableValueEnd, nullableValueEnd, currSeries.getArguments()[index].toString(), this.GetTag(index), 0, 1, rect, null);
                StiSeriesLabelsGeom seriesValueEndLabelsGeom = ((StiAxisSeriesLabelsCoreXF)labels.getCore()).RenderLabel(currSeries, context, pointValueEndLabels, pointValueEndLabels, index, nullableValue, nullableValue, currSeries.getArguments()[index].toString(), this.GetTag(index), 0, 1, rect, null);
                if (seriesValueEndLabelsGeom != null) {
                    seriesLabelsList.add(seriesValueEndLabelsGeom);
                    seriesValueEndLabelsGeom.setClientRectangle(this.CheckLabelsRect(labels, geom, seriesValueEndLabelsGeom.getClientRectangle()));
                }
                if (seriesValueLabelsGeom == null) continue;
                seriesLabelsList.add(seriesValueLabelsGeom);
                seriesValueLabelsGeom.setClientRectangle(this.CheckLabelsRect(labels, geom, seriesValueLabelsGeom.getClientRectangle()));
            }
        }
        for (StiSeriesLabelsGeom seriesLabelsGeom : seriesLabelsList) {
            geom.CreateChildGeoms();
            geom.getChildGeoms().add(seriesLabelsGeom);
        }
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Chart", (String)"Gantt");
    }

    public StiGanttSeriesCoreXF(IStiSeries series) {
        super(series);
    }
}

