/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.series.scatter;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.core.axis.stripLines.StiStripLineXF;
import com.stimulsoft.report.chart.core.series.clusteredColumn.StiBaseLineSeriesCoreXF;
import com.stimulsoft.report.chart.core.seriesLabels.axis.StiAxisSeriesLabelsCoreXF;
import com.stimulsoft.report.chart.enums.StiSeriesYAxis;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.seriesLabels.StiSeriesLabelsGeom;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.scatter.IStiScatterArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.scatter.IStiScatterSeries;
import com.stimulsoft.report.chart.interfaces.seriesLabels.axis.IStiAxisSeriesLabels;
import com.stimulsoft.report.chart.interfaces.trendLines.IStiTrendLine;
import com.stimulsoft.report.chart.view.series.StiSeries;
import java.util.ArrayList;
import java.util.Date;

public class StiScatterSeriesCoreXF
extends StiBaseLineSeriesCoreXF {
    @Override
    protected void RenderLines(StiContext context, StiAreaGeom geom, StiPoint[] pointsFrom, StiPoint[] points) {
        this.RenderMarkers(context, geom, points);
    }

    @Override
    public void RenderSeries(StiContext context, StiRectangle rect, StiAreaGeom geom, IStiSeries[] seriesArray) {
        if (seriesArray == null || seriesArray.length == 0 || this.getSeries().getChart() == null) {
            return;
        }
        IStiArea tempVar = geom.getArea();
        IStiScatterArea dotArea = (IStiScatterArea)(tempVar instanceof IStiScatterArea ? tempVar : null);
        double posY = 0.0;
        ArrayList<StiPoint[]> pointLists = new ArrayList<StiPoint[]>();
        for (int seriesIndex = 0; seriesIndex < seriesArray.length; ++seriesIndex) {
            IStiScatterSeries currentSeries = (IStiScatterSeries)(seriesArray[seriesIndex] instanceof IStiScatterSeries ? seriesArray[seriesIndex] : null);
            int pointsCount = Math.min(currentSeries.getValues().length, currentSeries.getArguments().length);
            StiPoint[] points = new StiPoint[pointsCount];
            for (int pointIndex = 0; pointIndex < pointsCount; ++pointIndex) {
                Double value = currentSeries.getValues()[pointIndex];
                if (value == null && ((IStiScatterSeries)this.getSeries()).getShowNulls()) {
                    value = 0.0;
                }
                if (value != null) {
                    if (dotArea.getReverseVert() && value != null && !dotArea.getYAxis().getLogarithmicScale()) {
                        value = -value.doubleValue();
                    }
                    double srY = 0.0;
                    if (dotArea.getYAxis().getLogarithmicScale()) {
                        int countStrip = dotArea.getYAxis().getInfo().StripLines.size();
                        int startPoint = 0;
                        int endPoint = countStrip - 1;
                        double startValue = ((StiStripLineXF)dotArea.getYAxis().getInfo().StripLines.get(startPoint)).getValue();
                        double endValue = ((StiStripLineXF)dotArea.getYAxis().getInfo().StripLines.get(endPoint)).getValue();
                        double decadeY = Math.abs(rect.height / (Math.log10(endValue) - Math.log10(startValue)));
                        srY = Math.abs(Math.log10(((StiStripLineXF)dotArea.getYAxis().getInfo().StripLines.get(startPoint)).getValue()) * decadeY - Math.log10(value == null ? 0.0 : value) * decadeY);
                    } else {
                        srY = currentSeries.getYAxis() == StiSeriesYAxis.LeftYAxis ? -(value == null ? 0.0 : value) * dotArea.getYAxis().getInfo().Dpi + dotArea.getAxisCore().GetDividerY() : -(value == null ? 0.0 : value) * dotArea.getYRightAxis().getInfo().Dpi + dotArea.getAxisCore().GetDividerRightY();
                    }
                    Double argument = null;
                    if (currentSeries.getArguments()[pointIndex] instanceof Date) {
                        Date tempDateTime = (Date)currentSeries.getArguments()[pointIndex];
                        argument = new Double(tempDateTime.getTime());
                    } else {
                        try {
                            argument = currentSeries.getArguments()[pointIndex] == null ? null : (Double)currentSeries.getArguments()[pointIndex];
                        }
                        catch (Exception e) {
                            argument = null;
                        }
                    }
                    if (argument == null) {
                        points[pointIndex] = null;
                        continue;
                    }
                    double posX = 0.0;
                    if (dotArea.getXAxis().getLogarithmicScale() && dotArea.getXAxis().getInfo().StripLines.size() > 0) {
                        int countStrip = dotArea.getXAxis().getInfo().StripLines.size();
                        int startPoint = dotArea.getReverseHor() ? countStrip - 1 : 0;
                        int endPoint = dotArea.getReverseHor() ? 0 : countStrip - 1;
                        double startValue = ((StiStripLineXF)dotArea.getXAxis().getInfo().StripLines.get(startPoint)).getValue();
                        double endValue = ((StiStripLineXF)dotArea.getXAxis().getInfo().StripLines.get(endPoint)).getValue();
                        double decadeX = Math.abs(rect.width / (Math.log10(endValue) - Math.log10(startValue)));
                        posX = Math.log10(argument) * decadeX - Math.log10(((StiStripLineXF)dotArea.getXAxis().getInfo().StripLines.get(startPoint)).getValue()) * decadeX;
                    } else {
                        posX = (argument - dotArea.getXAxis().getInfo().Minimum) * dotArea.getXAxis().getInfo().Dpi + dotArea.getAxisCore().GetDividerX();
                    }
                    if (dotArea.getReverseHor()) {
                        posX = rect.width - posX;
                    }
                    points[pointIndex] = new StiPoint((double)((float)posX), (double)((float)srY));
                    continue;
                }
                points[pointIndex] = null;
            }
            pointLists.add(points);
        }
        int index = 0;
        for (StiPoint[] pointList : pointLists) {
            IStiAxisSeriesLabels labels;
            IStiScatterSeries currentSeries = (IStiScatterSeries)(seriesArray[index] instanceof IStiScatterSeries ? seriesArray[index] : null);
            ((StiScatterSeriesCoreXF)currentSeries.getCore()).RenderLines(context, geom, null, pointList);
            IStiTrendLine trendLine = ((StiSeries)((Object)currentSeries)).getTrendLine();
            if (trendLine != null) {
                trendLine.getCore().RenderTrendLine(geom, pointList, dotArea.getAxisCore().GetDividerY());
            }
            if ((labels = currentSeries.getCore().GetSeriesLabels()) != null && labels.getVisible()) {
                for (int pointIndex = 0; pointIndex < pointList.length; ++pointIndex) {
                    StiSeriesLabelsGeom seriesLabelsGeom;
                    StiPoint startPoint;
                    Double value;
                    Double seriesValue = value = currentSeries.getValues()[pointIndex];
                    if (dotArea.getReverseVert() && value != null) {
                        seriesValue = -seriesValue.doubleValue();
                    }
                    posY = currentSeries.getYAxis() == StiSeriesYAxis.LeftYAxis ? dotArea.getAxisCore().GetDividerY() : dotArea.getAxisCore().GetDividerRightY();
                    StiPoint endPoint = pointList[pointIndex];
                    if (endPoint == null || !rect.contains(startPoint = new StiPoint(endPoint.getValue().x, (double)((float)posY))) && !rect.contains(endPoint.getValue()) || labels.getStep() != 0 && pointIndex % labels.getStep() != 0 || (seriesLabelsGeom = ((StiAxisSeriesLabelsCoreXF)labels.getCore()).RenderLabel(currentSeries, context, this.CorrectPoint(endPoint.getValue(), rect, currentSeries.getLabelsOffset() * context.Options.zoom), this.CorrectPoint(startPoint, rect, currentSeries.getLabelsOffset() * context.Options.zoom), pointIndex, seriesValue, value, currentSeries.getArguments()[pointIndex].toString(), this.GetTag(pointIndex), 0, 1, rect, null)) == null) continue;
                    geom.CreateChildGeoms();
                    geom.getChildGeoms().add(seriesLabelsGeom);
                    seriesLabelsGeom.setClientRectangle(this.CheckLabelsRect(labels, geom, seriesLabelsGeom.getClientRectangle()));
                }
            }
            ++index;
        }
        if (geom.getArea().getChart().getSeriesLabels().getPreventIntersection()) {
            this.CheckIntersectionLabels(geom);
        }
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Chart", (String)"Scatter");
    }

    public StiScatterSeriesCoreXF(IStiSeries series) {
        super(series);
    }
}

