/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.seriesLabels.axis;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.geoms.StiFontGeom;
import com.stimulsoft.base.context.chart.geoms.StiStringFormatGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.core.seriesLabels.axis.StiAxisSeriesLabelsCoreXF;
import com.stimulsoft.report.chart.enums.StiSeriesLabelsPosition;
import com.stimulsoft.report.chart.geoms.seriesLabels.StiSeriesLabelsGeom;
import com.stimulsoft.report.chart.geoms.seriesLabels.axis.StiOutsideAxisLabelsGeom;
import com.stimulsoft.report.chart.interfaces.areas.clusteredBar.IStiClusteredBarArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.seriesLabels.IStiSeriesLabels;
import com.stimulsoft.report.chart.interfaces.seriesLabels.axis.IStiOutsideAxisLabels;

public class StiOutsideAxisLabelsCoreXF
extends StiAxisSeriesLabelsCoreXF {
    @Override
    public StiSeriesLabelsGeom RenderLabel(IStiSeries series, StiContext context, StiPoint endPoint, StiPoint startPoint, int pointIndex, Double value, Double labelValue, String argumentText, String tag, int colorIndex, int colorCount, StiRectangle rect, StiAnimation animation) {
        IStiSeriesLabels tempVar = this.getSeriesLabels();
        IStiOutsideAxisLabels labels = (IStiOutsideAxisLabels)(tempVar instanceof IStiOutsideAxisLabels ? tempVar : null);
        if (value == null && !labels.getShowNulls()) {
            return null;
        }
        if (value != null && value == 0.0 && !labels.getShowZeros()) {
            return null;
        }
        if (value == null) {
            value = 0.0;
        }
        if (labelValue == null) {
            labelValue = 0.0;
        }
        String labelText = this.GetLabelText(series, labelValue, argumentText, tag, series.getCoreTitle());
        float infoAngle = 90.0f;
        if (this.getSeriesLabels().getChart().getArea() instanceof IStiClusteredBarArea) {
            if (value <= 0.0) {
                infoAngle = -infoAngle;
            }
            infoAngle += 90.0f;
        } else if (value < 0.0) {
            infoAngle = -infoAngle;
        }
        StiPoint newPoint = new StiPoint((double)((int)Math.round(endPoint.x + (double)labels.getLineLength() * Math.cos(infoAngle *= (float)Math.PI / 180) * (double)context.Options.zoom)), (double)((int)Math.round(endPoint.y - (double)labels.getLineLength() * Math.sin(infoAngle) * (double)context.Options.zoom)));
        StiFontGeom font = StiFontGeom.ChangeFontSize((StiFont)labels.getFont(), (double)(labels.getFont().size * (double)context.Options.zoom));
        StiSize labelSize = context.MeasureString(labelText, font).round();
        StiRectangle labelRect = new StiRectangle(newPoint.x - labelSize.width / 2.0, newPoint.y - labelSize.height / 2.0, labelSize.width + 1.0, labelSize.height + 1.0);
        StiColor labelColor = this.GetLabelColor(series, colorIndex, colorCount);
        StiColor labelBorderColor = this.GetBorderColor(series, colorIndex, colorCount);
        StiStringFormatGeom sf = context.GetDefaultStringFormat();
        StiColor seriesBorderColor = (StiColor)series.getCore().GetSeriesBorderColor(colorIndex, colorCount);
        StiBrush seriesBrush = series.getCore().GetSeriesBrush(colorIndex, colorCount);
        seriesBrush = this.ProcessSeriesColors(pointIndex, seriesBrush, series);
        return new StiOutsideAxisLabelsGeom(this.getSeriesLabels(), series, pointIndex, value, labelRect, labelText, labelColor, labelBorderColor, seriesBrush, seriesBorderColor, font, newPoint, endPoint);
    }

    @Override
    public int getPosition() {
        return StiSeriesLabelsPosition.OutsideAxis.getValue();
    }

    @Override
    public String getLocalizedName() {
        return StiLocalization.Get((String)"Chart", (String)"LabelsOutside");
    }

    public StiOutsideAxisLabelsCoreXF(IStiSeriesLabels seriesLabels) {
        super(seriesLabels);
    }
}

