/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.core.strips;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.geoms.areas.StiAxisAreaGeom;
import com.stimulsoft.report.chart.geoms.strips.StiStripsXGeom;
import com.stimulsoft.report.chart.geoms.strips.StiStripsYGeom;
import com.stimulsoft.report.chart.interfaces.IStiApplyStyle;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.IStiAxisArea;
import com.stimulsoft.report.chart.interfaces.strips.IStiStrips;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;
import com.stimulsoft.report.chart.view.strips.StiStrips;

public class StiStripsCoreXF
implements IStiApplyStyle,
Cloneable {
    private IStiStrips strips;

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final void applyStyle(IStiChartStyle style) {
        if (this.getStrips().getAllowApplyStyle()) {
            this.getStrips().setTitleColor(style.getCore().getChartAreaBorderColor());
            this.getStrips().setStripBrush((StiBrush)new StiSolidBrush(StiColor.FromArgb((int)150, (StiColor)style.getCore().getBasicStyleColor())));
        }
    }

    public final void RenderXStrips(StiContext context, StiAxisAreaGeom geom, StiRectangle rect) {
        double maxLeft;
        float value;
        IStiArea tempVar = this.getStrips().getChart().getArea();
        IStiAxisArea area = (IStiAxisArea)(tempVar instanceof IStiAxisArea ? tempVar : null);
        if (area == null) {
            return;
        }
        try {
            value = Float.parseFloat(this.getStrips().getMinValue());
        }
        catch (Exception e) {
            value = 0.0f;
        }
        if (area.getReverseVert()) {
            value = -value;
        }
        double minLeft = area.getAxisCore().GetDividerX() + (double)(value * (float)area.getXAxis().getInfo().Dpi);
        try {
            value = Float.parseFloat(this.getStrips().getMaxValue());
        }
        catch (Exception e2) {
            value = 0.0f;
        }
        if (area.getReverseVert()) {
            value = -value;
        }
        if (minLeft > (maxLeft = area.getAxisCore().GetDividerX() + (double)(value * (float)area.getXAxis().getInfo().Dpi))) {
            double tmpTop = minLeft;
            minLeft = maxLeft;
            maxLeft = tmpTop;
        }
        StiRectangle stripRect = new StiRectangle(minLeft, 0.0, maxLeft - minLeft, rect.height);
        StiStripsXGeom stripGeom = new StiStripsXGeom(this.getStrips(), stripRect);
        geom.CreateChildGeoms();
        geom.getChildGeoms().add(stripGeom);
    }

    public final void RenderYStrips(StiContext context, StiAxisAreaGeom geom, StiRectangle rect) {
        double maxTop;
        float value;
        IStiArea tempVar = this.getStrips().getChart().getArea();
        IStiAxisArea area = (IStiAxisArea)(tempVar instanceof IStiAxisArea ? tempVar : null);
        if (area == null) {
            return;
        }
        try {
            value = Float.parseFloat(this.getStrips().getMinValue());
        }
        catch (Exception e) {
            value = 0.0f;
        }
        if (area.getReverseVert()) {
            value = -value;
        }
        double minTop = area.getAxisCore().GetDividerY() - (double)(value * (float)area.getYAxis().getInfo().Dpi);
        try {
            value = Float.parseFloat(this.getStrips().getMaxValue());
        }
        catch (Exception e2) {
            value = 0.0f;
        }
        if (area.getReverseVert()) {
            value = -value;
        }
        if (minTop > (maxTop = area.getAxisCore().GetDividerY() - (double)(value * (float)area.getYAxis().getInfo().Dpi))) {
            double tmpTop = minTop;
            minTop = maxTop;
            maxTop = tmpTop;
        }
        StiRectangle stripRect = new StiRectangle(0.0, minTop, rect.width, maxTop - minTop);
        StiStripsYGeom stripGeom = new StiStripsYGeom(this.getStrips(), stripRect);
        geom.CreateChildGeoms();
        geom.getChildGeoms().add(stripGeom);
    }

    public final void Render(StiContext context, StiAxisAreaGeom geom, StiRectangle rect) {
        if (!this.getStrips().getVisible()) {
            return;
        }
        if (this.getStrips().getOrientation() == StiStrips.StiOrientation.Vertical) {
            this.RenderXStrips(context, geom, rect);
        }
        if (this.getStrips().getOrientation() == StiStrips.StiOrientation.Horizontal) {
            this.RenderYStrips(context, geom, rect);
        }
    }

    public final IStiStrips getStrips() {
        return this.strips;
    }

    public final void setStrips(IStiStrips value) {
        this.strips = value;
    }

    public StiStripsCoreXF(IStiStrips strips) {
        this.strips = strips;
    }
}

