/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.enums;

import java.util.HashMap;

public enum StiChartAreaPosition {
    ClusteredColumn(0),
    StackedColumn(1),
    FullStackedColumn(2),
    ClusteredBar(10),
    StackedBar(11),
    FullStackedBar(12),
    Pie(20),
    Doughnut(21),
    Line(30),
    SteppedLine(31),
    StackedLine(32),
    FullStackedLine(33),
    Spline(40),
    StackedSpline(41),
    FullStackedSpline(42),
    Area(50),
    SteppedArea(51),
    StackedArea(52),
    FullStackedArea(53),
    SplineArea(60),
    StackedSplineArea(61),
    FullStackedSplineArea(62),
    Gantt(70),
    Scatter(80),
    Bubble(81),
    RadarPoint(82),
    RadarLine(83),
    RadarArea(84),
    Range(90),
    SteppedRange(91),
    RangeBar(92),
    SplineRange(93),
    Funnel(100),
    Candlestick(110),
    Stock(120);

    private int intValue;
    private static HashMap<Integer, StiChartAreaPosition> mappings;

    private static synchronized HashMap<Integer, StiChartAreaPosition> getMappings() {
        if (mappings == null) {
            mappings = new HashMap();
        }
        return mappings;
    }

    private StiChartAreaPosition(int value) {
        this.intValue = value;
        StiChartAreaPosition.getMappings().put(value, this);
    }

    public int getValue() {
        return this.intValue;
    }

    public static StiChartAreaPosition forValue(int value) {
        return StiChartAreaPosition.getMappings().get(value);
    }
}

