/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiGeom;
import com.stimulsoft.base.context.chart.geoms.enums.StiGeomType;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiInteractionOptions;
import com.stimulsoft.report.chart.geoms.areas.StiAxisAreaGeom;
import com.stimulsoft.report.chart.geoms.marker.StiMarkerGeom;
import com.stimulsoft.report.chart.geoms.series.StiSeriesElementGeom;
import com.stimulsoft.report.chart.geoms.series.StiSeriesGeom;
import com.stimulsoft.report.chart.interfaces.IStiGeomInteraction;
import com.stimulsoft.report.chart.interfaces.IStiSeriesElement;
import java.util.ArrayList;
import java.util.List;

public abstract class StiCellGeom
extends StiGeom
implements IStiGeomInteraction {
    private ArrayList<StiCellGeom> childGeoms = null;
    private StiRectangle clientRectangle = StiRectangle.getEmpty();

    @Override
    public void InvokeClick(StiInteractionOptions options) {
    }

    @Override
    public void InvokeMouseEnter(StiInteractionOptions options) {
    }

    @Override
    public void InvokeMouseLeave(StiInteractionOptions options) {
    }

    @Override
    public void InvokeMouseDown(StiInteractionOptions options) {
    }

    @Override
    public void InvokeMouseUp(StiInteractionOptions options) {
    }

    @Override
    public void InvokeDrag(StiInteractionOptions options) {
    }

    public boolean getInvisible() {
        return false;
    }

    public StiGeomType getType() {
        return StiGeomType.None;
    }

    public final ArrayList<StiCellGeom> getChildGeoms() {
        return this.childGeoms;
    }

    public final StiRectangle getClientRectangle() {
        return this.clientRectangle.clone();
    }

    public final void setClientRectangle(StiRectangle value) {
        this.clientRectangle = value;
    }

    public boolean Contains(double x, double y) {
        if (this.getInvisible()) {
            return false;
        }
        return this.clientRectangle.contains(x, y);
    }

    public final StiCellGeom GetGeomAt(StiCellGeom parent, double x, double y) {
        double xx = x - parent.getClientRectangle().x;
        double yy = y - parent.getClientRectangle().y;
        if (parent.getChildGeoms() != null) {
            StiAxisAreaGeom axisAreaGeom = (StiAxisAreaGeom)(parent instanceof StiAxisAreaGeom ? parent : null);
            StiCellGeom selectedGeom = null;
            for (StiCellGeom childGeom : parent.getChildGeoms()) {
                StiCellGeom geom;
                if ((axisAreaGeom == null || !axisAreaGeom.IsChildVisibleInView(childGeom)) && axisAreaGeom != null) continue;
                if (childGeom instanceof StiAxisAreaGeom) {
                    if (!((StiAxisAreaGeom)childGeom).getView().Contains(x, y) || (geom = this.GetGeomAt(childGeom, xx, yy)) == null) continue;
                    selectedGeom = geom;
                    continue;
                }
                geom = this.GetGeomAt(childGeom, xx, yy);
                if (geom == null || !((selectedGeom = geom) instanceof StiMarkerGeom)) continue;
                return selectedGeom;
            }
            if (selectedGeom != null) {
                return selectedGeom;
            }
        }
        if (parent.Contains(x, y)) {
            return parent;
        }
        return null;
    }

    public final ArrayList<StiCellGeom> GetSeriesGeoms() {
        ArrayList<StiCellGeom> geoms = new ArrayList<StiCellGeom>();
        if (this.childGeoms == null) {
            return geoms;
        }
        for (StiCellGeom childGeom : this.getChildGeoms()) {
            if (childGeom instanceof StiSeriesGeom || childGeom instanceof StiSeriesElementGeom) {
                geoms.add(childGeom);
            }
            ArrayList<StiCellGeom> geoms2 = childGeom.GetSeriesGeoms();
            for (StiCellGeom childGeom2 : geoms2) {
                geoms.add(childGeom2);
            }
        }
        return geoms;
    }

    public List<StiCellGeom> getSeriesElementGeoms() {
        ArrayList<StiCellGeom> geoms = new ArrayList<StiCellGeom>();
        if (this.childGeoms == null) {
            return geoms;
        }
        for (StiCellGeom childGeom : this.getChildGeoms()) {
            if (childGeom instanceof IStiSeriesElement) {
                geoms.add(childGeom);
            }
            List<StiCellGeom> geoms2 = childGeom.getSeriesElementGeoms();
            for (StiCellGeom childGeom2 : geoms2) {
                geoms.add(childGeom2);
            }
        }
        return geoms;
    }

    public final StiRectangle GetRect(StiGeom geom) {
        StiRectangle rect = StiRectangle.getEmpty();
        if (this.childGeoms == null) {
            return rect;
        }
        for (StiCellGeom childGeom : this.getChildGeoms()) {
            if (childGeom == geom) {
                rect.x += childGeom.getClientRectangle().x;
                rect.y += childGeom.getClientRectangle().y;
                rect.setSize(childGeom.getClientRectangle().getSize());
                return rect;
            }
            StiRectangle clientRect = childGeom.GetRect(geom);
            if (clientRect.isEmpty().booleanValue()) continue;
            rect.x += childGeom.getClientRectangle().x;
            rect.y += childGeom.getClientRectangle().y;
            rect.x += clientRect.x;
            rect.y += clientRect.y;
            rect.setSize(clientRect.getSize());
            return rect;
        }
        return rect;
    }

    public final void CreateChildGeoms() {
        if (this.childGeoms == null) {
            this.childGeoms = new ArrayList();
        }
    }

    public abstract void Draw(StiContext var1);

    public void DrawGeom(StiContext context) {
        this.Draw(context);
        this.DrawChildGeoms(context);
    }

    public void DrawChildGeoms(StiContext context) {
        if (this.getChildGeoms() != null) {
            context.PushTranslateTransform(this.getClientRectangle().x, this.getClientRectangle().y);
            for (StiCellGeom childGeom : this.getChildGeoms()) {
                if (!this.AllowChildDrawing(childGeom)) continue;
                childGeom.DrawGeom(context);
            }
            context.PopTransform();
        }
    }

    protected boolean AllowChildDrawing(StiCellGeom cellGeom) {
        return cellGeom != null;
    }

    public StiCellGeom(StiRectangle clientRectangle) {
        this.clientRectangle = clientRectangle;
    }
}

