/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.constantLines;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiFontGeom;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.context.chart.geoms.StiStringFormatGeom;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiRotationMode;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.interfaces.constantLines.IStiConstantLines;

public class StiConstantLinesVerticalGeom
extends StiCellGeom {
    private final IStiConstantLines line;
    private final StiPoint point;
    private final StiRotationMode mode;

    public final IStiConstantLines getLine() {
        return this.line;
    }

    public final StiPoint getPoint() {
        return this.point;
    }

    public final StiRotationMode getMode() {
        return this.mode;
    }

    @Override
    public void Draw(StiContext context) {
        StiRectangle rect = this.getClientRectangle();
        StiPenGeom pen = new StiPenGeom((Object)this.line.getLineColor(), this.line.getLineWidth());
        pen.setPenStyle(this.line.getLineStyle());
        context.DrawLine(pen, rect.getLeft(), rect.getTop(), rect.getLeft(), rect.getBottom());
        if (this.line.getTitleVisible()) {
            StiSolidBrush brush = new StiSolidBrush(this.line.getLineColor());
            StiFontGeom font = StiFontGeom.ChangeFontSize((StiFont)this.line.getFont(), (float)((float)(this.line.getFont().size * (double)context.Options.zoom)));
            StiStringFormatGeom sf = context.GetGenericStringFormat();
            context.DrawRotatedString(this.line.getText(), font, (Object)brush, this.getPoint(), sf, this.getMode(), 90.0f, this.line.getAntialiasing(), 0);
        }
    }

    public StiConstantLinesVerticalGeom(IStiConstantLines line, StiRectangle clientRectangle, StiPoint point, StiRotationMode mode) {
        super(clientRectangle);
        this.line = line;
        this.point = point;
        this.mode = mode;
    }
}

