/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.marker;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.geoms.StiArcSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiLineSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.interfaces.legend.IStiLegendMarker;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.pie.IStiPieSeries;
import java.util.ArrayList;

public class StiLegendPieMarker
implements IStiLegendMarker {
    @Override
    public void Draw(StiContext context, IStiSeries serie, StiRectangle rect, int colorIndex, int colorCount) {
        IStiPieSeries series = (IStiPieSeries)serie;
        StiBrush seriesBrush = series.getBrush();
        if (series.getAllowApplyBrush()) {
            seriesBrush = series.getCore().GetSeriesBrush(colorIndex, colorCount);
            seriesBrush = series.ProcessSeriesColors(colorIndex, seriesBrush);
        }
        StiColor borderColor = series.getBorderColor().clone();
        if (series.getAllowApplyBorderColor()) {
            borderColor = (StiColor)serie.getCore().GetSeriesBorderColor(colorIndex, colorCount);
        }
        ArrayList<Object> path = new ArrayList<Object>();
        StiPenGeom pen = new StiPenGeom((Object)borderColor);
        context.PushSmoothingModeToAntiAlias();
        path.add(new StiArcSegmentGeom(new StiRectangle(rect.x - rect.width, rect.y, rect.width * 2.0, rect.height * 2.0), 270.0f, 90.0f));
        path.add(new StiLineSegmentGeom(rect.getRight(), rect.getBottom(), rect.x, rect.getBottom()));
        path.add(new StiLineSegmentGeom(rect.x, rect.getBottom(), rect.x, rect.y));
        context.FillPath((Object)seriesBrush, path, (Object)rect, null);
        context.DrawPath(pen, path, null);
        context.PopSmoothingMode();
    }
}

