/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.series.bubble;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiScaleAnimation;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.StiMouseOverHelper;
import com.stimulsoft.report.chart.geoms.series.StiSeriesElementGeom;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;

public class StiBubbleSeriesElementGeom
extends StiSeriesElementGeom {
    private final StiBrush seriesBrush;
    private final StiColor seriesBorderColor;
    private Integer beginTime;

    public final StiBrush getSeriesBrush() {
        return this.seriesBrush;
    }

    public final StiColor getSeriesBorderColor() {
        return this.seriesBorderColor;
    }

    public Integer getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(Integer beginTime) {
        this.beginTime = beginTime;
    }

    @Override
    public boolean Contains(double x, double y) {
        double dy;
        if (this.getInvisible()) {
            return false;
        }
        StiPoint center = new StiPoint(this.getClientRectangle().x + this.getClientRectangle().width / 2.0, this.getClientRectangle().y + this.getClientRectangle().height / 2.0);
        double dx = Math.abs(center.x - x);
        float radius = (float)Math.sqrt(dx * dx + (dy = Math.abs(center.y - y)) * dy);
        return (double)radius <= this.getClientRectangle().width / 2.0;
    }

    @Override
    public void Draw(StiContext context) {
        StiRectangle rect = this.getClientRectangle();
        StiPenGeom pen = new StiPenGeom((Object)this.getSeriesBorderColor(), 1.0f);
        StiChart chart = (StiChart)this.getSeries().getChart();
        if (chart.isAnimation) {
            StiScaleAnimation animation = new StiScaleAnimation(StiChartHelper.GlobalDurationElement, this.beginTime);
            context.FillDrawAnimationEllipse((Object)this.getSeriesBrush(), pen, rect.x, rect.y, rect.width, rect.height, this.GetToolTip(), (Object)this, (StiAnimation)animation, this.getInteractionData());
        } else {
            if (this.getSeries().getShowShadow()) {
                StiSolidBrush shadowBrush = new StiSolidBrush(StiColor.FromArgb((int)100, (StiColor)StiColor.Black));
                StiContext shadowContext = context.CreateShadowGraphics();
                StiRectangle rectShadow = rect.clone();
                rectShadow.x = 0.0;
                rectShadow.y = 0.0;
                rectShadow.x += (double)(4 * context.Options.zoom);
                rectShadow.y += (double)(4 * context.Options.zoom);
                shadowContext.FillEllipse((Object)shadowBrush, rectShadow, null);
                context.DrawShadow(shadowContext, rect, 0.0);
            }
            context.FillEllipse((Object)this.getSeriesBrush(), rect, this.getInteractionData());
            if (this.getIsMouseOver() || this.getSeries().getCore().getIsMouseOver()) {
                context.FillEllipse((Object)StiMouseOverHelper.GetMouseOverColor(), rect.x, rect.y, rect.width, rect.height, null);
            }
            context.PushSmoothingModeToAntiAlias();
            context.DrawEllipse(pen, rect);
            context.PopSmoothingMode();
        }
    }

    public StiBubbleSeriesElementGeom(StiAreaGeom areaGeom, double value, int index, StiBrush seriesBrush, StiColor seriesBorderColor, IStiSeries series, StiRectangle clientRectangle, Integer beginTime) {
        super(areaGeom, value, index, series, clientRectangle);
        this.seriesBrush = seriesBrush;
        this.seriesBorderColor = seriesBorderColor;
        this.beginTime = beginTime;
    }
}

