/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.series.clusteredBar;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.StiEnumSet;
import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiColumnAnimation;
import com.stimulsoft.base.context.chart.animation.StiOpacityAnimation;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.enums.StiShadowSides;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.StiMouseOverHelper;
import com.stimulsoft.report.chart.geoms.series.StiSeriesElementGeom;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;

public class StiClusteredBarSeriesElementGeom
extends StiSeriesElementGeom {
    private double valueStart;
    private StiRectangle columnRectStart;
    private Integer beginTime;
    private final StiBrush seriesBrush;
    private final StiColor seriesBorderColor;

    public double getValueStart() {
        return this.valueStart;
    }

    public StiRectangle getColumnRectStart() {
        return this.columnRectStart;
    }

    public Integer getBeginTime() {
        return this.beginTime;
    }

    public final StiBrush getSeriesBrush() {
        return this.seriesBrush;
    }

    public final StiColor getSeriesBorderColor() {
        return this.seriesBorderColor;
    }

    @Override
    public void Draw(StiContext context) {
        StiChart chart = (StiChart)this.getSeries().getChart();
        if (chart.isAnimation) {
            StiRectangle columnRect = this.getClientRectangle();
            StiPenGeom pen = new StiPenGeom((Object)this.getSeriesBorderColor(), 1.0f);
            Integer duration = StiChartHelper.GlobalDurationElement;
            if (this.getSeries().getShowShadow()) {
                StiOpacityAnimation animationOpacity = new StiOpacityAnimation(duration, Integer.valueOf(this.beginTime + duration));
                context.DrawShadowRect(columnRect, 5, (StiAnimation)animationOpacity);
            }
            StiColumnAnimation animationColumn = new StiColumnAnimation(Double.valueOf(this.getValueStart()), this.getColumnRectStart(), duration, this.beginTime);
            context.DrawAnimationBar((Object)this.seriesBrush, pen, (Object)columnRect, Double.valueOf(this.getValue()), this.GetToolTip(), (Object)this, (StiAnimation)animationColumn, this.getInteractionData());
        } else {
            StiRectangle rect = this.getClientRectangle();
            if (this.getSeries().getShowShadow() && rect.width > 4.0 && rect.height > 4.0) {
                StiRectangle shadowRect = rect.clone();
                StiEnumSet sides = new StiEnumSet((Enum)StiShadowSides.Bottom);
                if (this.getValue() > 0.0) {
                    shadowRect.y -= 1.0;
                    sides.add((IStiEnum)StiShadowSides.Left);
                    context.drawCachedShadow(shadowRect, sides, context.Options.isPrinting);
                } else if (this.getValue() < 0.0) {
                    sides.add((IStiEnum)StiShadowSides.Top);
                    sides.add((IStiEnum)StiShadowSides.Right);
                    sides.add((IStiEnum)StiShadowSides.Edge);
                    context.drawCachedShadow(new StiRectangle(shadowRect.x - 8.0, shadowRect.y, shadowRect.width + 8.0, shadowRect.height), sides, context.Options.isPrinting);
                }
            }
            StiPenGeom pen = new StiPenGeom((Object)this.getSeriesBorderColor(), 1.0f);
            this.getSeries().getChart().getStyle().getCore().FillColumn(context, rect, this.seriesBrush, this.getInteractionData());
            StiPoint[] points = null;
            if (this.getIsMouseOver() || this.getSeries().getCore().getIsMouseOver()) {
                context.FillRectangle((Object)StiMouseOverHelper.GetMouseOverColor(), rect.x, rect.y, rect.width, rect.height, null);
            }
            points = this.getValue() > 0.0 ? new StiPoint[]{new StiPoint(rect.getRight(), rect.y), new StiPoint(rect.x, rect.y), new StiPoint(rect.x, rect.getBottom()), new StiPoint(rect.getRight(), rect.getBottom())} : new StiPoint[]{new StiPoint(rect.x, rect.y), new StiPoint(rect.getRight(), rect.y), new StiPoint(rect.getRight(), rect.getBottom()), new StiPoint(rect.x, rect.getBottom())};
            context.DrawLines(pen, points);
        }
    }

    public StiClusteredBarSeriesElementGeom(StiAreaGeom areaGeom, double valueStart, double value, int index, StiBrush seriesBrush, StiColor seriesBorderColor, IStiSeries series, StiRectangle columnRectStart, StiRectangle columnRect, Integer beginTime) {
        super(areaGeom, value, index, series, columnRect);
        this.seriesBrush = seriesBrush;
        this.seriesBorderColor = seriesBorderColor;
        this.valueStart = valueStart;
        this.columnRectStart = columnRectStart;
        this.beginTime = beginTime;
    }
}

