/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.series.clusteredColumn;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiInteractionOptions;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.StiSeriesGeom;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.view.series.clusteredColumn.StiBaseLineSeries;

public class StiBaseLineSeriesGeom
extends StiSeriesGeom {
    private final StiPoint[] points;
    private StiPoint[] pointsFrom;

    @Override
    public void InvokeMouseEnter(StiInteractionOptions options) {
        if (!this.getAllowMouseOver()) {
            return;
        }
        if (!this.getIsMouseOver()) {
            this.setIsMouseOver(true);
            options.setUpdateContext(true);
        }
    }

    @Override
    public void InvokeMouseLeave(StiInteractionOptions options) {
        if (!this.getAllowMouseOver()) {
            return;
        }
        if (this.getIsMouseOver()) {
            this.setIsMouseOver(false);
            options.setUpdateContext(true);
        }
    }

    public boolean getAllowMouseOver() {
        return this.getSeries().getInteraction().getDrillDownEnabled() && this.getSeries().getInteraction().getAllowSeries();
    }

    public boolean getIsMouseOver() {
        if (this.getSeries() == null) {
            return false;
        }
        return this.getSeries().getCore().getIsMouseOver();
    }

    public void setIsMouseOver(boolean value) {
        if (this.getSeries() != null) {
            this.getSeries().getCore().setIsMouseOver(value);
        }
    }

    public final StiPoint[] getPoints() {
        return this.points;
    }

    public StiPoint[] getPointsFrom() {
        return this.pointsFrom;
    }

    public static StiRectangle GetClientRectangle(StiPoint[] points, double lineWidth) {
        if (points == null || points.length == 0) {
            return StiRectangle.getEmpty();
        }
        StiPoint minPoint = StiPoint.getEmpty();
        StiPoint maxPoint = StiPoint.getEmpty();
        for (StiPoint point : points) {
            if (point == null) continue;
            if (minPoint.equals((Object)StiPoint.getEmpty())) {
                minPoint = point.getValue();
                maxPoint = point.getValue();
                continue;
            }
            minPoint.x = Math.min(minPoint.x, point.getValue().x);
            minPoint.y = Math.min(minPoint.y, point.getValue().y);
            maxPoint.x = Math.max(maxPoint.x, point.getValue().x);
            maxPoint.y = Math.max(maxPoint.y, point.getValue().y);
        }
        return new StiRectangle(minPoint.x - lineWidth / 2.0, minPoint.y - lineWidth / 2.0, maxPoint.x - minPoint.x + lineWidth, maxPoint.y - minPoint.y + lineWidth);
    }

    @Override
    public void Draw(StiContext context) {
    }

    public StiBaseLineSeriesGeom(StiAreaGeom areaGeom, StiPoint[] pointsFrom, StiPoint[] points, IStiSeries series) {
        super(areaGeom, series, StiBaseLineSeriesGeom.GetClientRectangle(points, series instanceof StiBaseLineSeries ? (double)((StiBaseLineSeries)series).getLineWidth() : 0.0));
        this.points = points;
        this.pointsFrom = pointsFrom;
    }
}

