/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.series.financial;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiInteractionOptions;
import com.stimulsoft.report.chart.geoms.StiCellGeom;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.interfaces.areas.IStiAxisArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.view.series.StiSeriesInteractionData;

public class StiFinancialSeriesElementGeom
extends StiCellGeom {
    private final IStiSeries series;
    private StiSeriesInteractionData interaction;
    private final double open;
    private final double close;
    private final double high;
    private final double low;
    private final double positionX;
    private final StiAreaGeom areaGeom;
    private final int index;

    @Override
    public void InvokeMouseEnter(StiInteractionOptions options) {
        if (!this.getAllowMouseOver()) {
            return;
        }
        if (!this.getIsMouseOver()) {
            this.setIsMouseOver(true);
            options.setUpdateContext(this.series.getInteraction().getDrillDownEnabled());
        }
        int valueIndex = this.GetValueIndex();
        options.setInteractionToolTip(this.GetToolTip(valueIndex));
        options.setInteractionHyperlink(this.GetHyperlink(valueIndex));
    }

    @Override
    public void InvokeClick(StiInteractionOptions options) {
        int valueIndex = this.GetValueIndex();
        if (this.getSeries().getHyperlinks() != null && valueIndex < this.getSeries().getHyperlinks().length) {
            options.setInteractionHyperlink(this.series.getHyperlinks()[valueIndex]);
        }
        if (this.getSeries().getInteraction().getDrillDownEnabled()) {
            options.setSeriesInteractionData(this.getInteraction());
            this.setIsMouseOver(false);
            options.setUpdateContext(this.series.getInteraction().getDrillDownEnabled());
        }
    }

    private int GetValueIndex() {
        int valueIndex = this.getIndex();
        if (this.getSeries().getChart().getArea() instanceof IStiAxisArea && ((IStiAxisArea)this.series.getChart().getArea()).getReverseHor()) {
            valueIndex = this.getSeries().getArguments().length - valueIndex - 1;
        }
        return valueIndex;
    }

    private String GetHyperlink(int valueIndex) {
        if (this.getSeries().getHyperlinks() != null && valueIndex < this.getSeries().getHyperlinks().length) {
            return this.series.getHyperlinks()[valueIndex];
        }
        return null;
    }

    private String GetToolTip(int valueIndex) {
        if (this.getSeries().getToolTips() != null && valueIndex < this.getSeries().getToolTips().length) {
            return this.series.getToolTips()[valueIndex];
        }
        return null;
    }

    public boolean getAllowMouseOver() {
        int index = this.GetValueIndex();
        return this.getSeries().getHyperlinks() != null && index < this.getSeries().getHyperlinks().length || this.getSeries().getToolTips() != null && index < this.getSeries().getToolTips().length || this.getSeries().getInteraction().getDrillDownEnabled() && this.getSeries().getInteraction().getAllowSeriesElements();
    }

    public boolean getIsMouseOver() {
        return this.getSeries().getCore().GetIsMouseOverSeriesElement(this.getIndex());
    }

    public void setIsMouseOver(boolean value) {
        this.getSeries().getCore().SetIsMouseOverSeriesElement(this.getIndex(), value);
    }

    public final IStiSeries getSeries() {
        return this.series;
    }

    public final StiSeriesInteractionData getInteraction() {
        return this.interaction;
    }

    public final void setInteraction(StiSeriesInteractionData value) {
        this.interaction = value;
    }

    public final double getOpen() {
        return this.open;
    }

    public final double getClose() {
        return this.close;
    }

    public final double getHigh() {
        return this.high;
    }

    public final double getLow() {
        return this.low;
    }

    public final double getPositionX() {
        return this.positionX;
    }

    public final StiAreaGeom getAreaGeom() {
        return this.areaGeom;
    }

    public final int getIndex() {
        return this.index;
    }

    @Override
    public void Draw(StiContext context) {
    }

    public StiFinancialSeriesElementGeom(StiAreaGeom areaGeom, IStiSeries series, StiRectangle clientRectangle, double open, double close, double high, double low, double positionX, int index) {
        super(clientRectangle);
        this.areaGeom = areaGeom;
        this.series = series;
        this.open = open;
        this.close = close;
        this.high = high;
        this.low = low;
        this.positionX = positionX;
        this.index = index;
    }
}

