/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.series.range;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiOpacityAnimation;
import com.stimulsoft.base.context.chart.geoms.StiLinesSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiPathGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.geoms.StiNullableDrawing;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.StiMouseOverHelper;
import com.stimulsoft.report.chart.geoms.series.clusteredColumn.StiLineSeriesGeom;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.range.IStiRangeSeries;
import java.util.ArrayList;

public class StiRangeSeriesGeom
extends StiLineSeriesGeom {
    private StiPoint[] pointsEnd;

    public final StiPoint[] getPointsEnd() {
        return this.pointsEnd;
    }

    public final void setPointsEnd(StiPoint[] value) {
        this.pointsEnd = value;
    }

    @Override
    public void Draw(StiContext context) {
        StiRectangle rect = this.getClientRectangle();
        IStiSeries tempVar = this.getSeries();
        IStiRangeSeries areaSeries = (IStiRangeSeries)(tempVar instanceof IStiRangeSeries ? tempVar : null);
        ArrayList<StiPoint[]> list = StiNullableDrawing.GetPointsList(this.getPoints());
        ArrayList<StiPoint[]> listEnd = StiNullableDrawing.GetPointsList(this.getPointsEnd());
        if (list.size() < 1 || listEnd.size() < 1) {
            return;
        }
        StiPoint[] points = list.get(0);
        StiPoint[] pointsEnd = listEnd.get(0);
        int count = Math.min(points.length, pointsEnd.length);
        ArrayList<StiPoint> pointsLine = new ArrayList<StiPoint>();
        ArrayList<StiPoint> pointsLineEnd = new ArrayList<StiPoint>();
        for (int index = 0; index < count; ++index) {
            StiPoint point = points[index];
            StiPoint pointEnd = pointsEnd[index];
            StiPoint pointNext = null;
            StiPoint pointNextEnd = null;
            if (index != count - 1) {
                pointNext = points[index + 1];
                pointNextEnd = pointsEnd[index + 1];
            }
            StiPoint pointCross = null;
            if (pointNext != null || this.Intersection(point, pointEnd, pointNext, pointNextEnd)) {
                pointCross = this.GetPointCross(point, pointEnd, pointNext, pointNextEnd);
            }
            pointsLine.add(point);
            pointsLineEnd.add(pointEnd);
            if (pointCross != null) {
                pointsLine.add(pointCross);
                pointsLineEnd.add(pointCross);
                this.FillPath(context, this.GetBrush(areaSeries, point, pointEnd), pointsLine, pointsLineEnd);
                pointsLine.clear();
                pointsLineEnd.clear();
                pointsLine.add(pointCross);
                pointsLineEnd.add(pointCross);
                continue;
            }
            if (pointNext != null) continue;
            this.FillPath(context, this.GetBrush(areaSeries, point, pointEnd), pointsLine, pointsLineEnd);
        }
    }

    private StiBrush GetBrush(IStiRangeSeries areaSeries, StiPoint point, StiPoint pointEnd) {
        StiBrush brush = areaSeries.getBrush();
        if (areaSeries.getAllowApplyBrushNegative()) {
            brush = point.getValue().y < pointEnd.getValue().y ? areaSeries.getBrushNegative() : areaSeries.getBrush();
        }
        return brush;
    }

    private void FillPath(StiContext context, StiBrush brush, ArrayList<StiPoint> pointsLine, ArrayList<StiPoint> pointsLineEnd) {
        ArrayList<StiLinesSegmentGeom> path = new ArrayList<StiLinesSegmentGeom>();
        StiPoint[] newPointsAll = new StiPoint[pointsLine.size() + pointsLineEnd.size() + 2];
        path.add(new StiLinesSegmentGeom(newPointsAll));
        StiChart chart = (StiChart)this.getSeries().getChart();
        if (chart.isAnimation) {
            StiOpacityAnimation animation = new StiOpacityAnimation(StiChartHelper.GlobalDurationElement, StiChartHelper.GlobalBeginTimeElement);
            context.FillDrawAnimationPath((Object)brush, null, path, StiPathGeom.GetBoundsState, null, (StiAnimation)animation, null);
        } else {
            context.FillPath((Object)brush, path, StiPathGeom.GetBoundsState, null);
        }
        if (this.getIsMouseOver() || this.getSeries().getCore().getIsMouseOver()) {
            context.FillPath((Object)StiMouseOverHelper.GetMouseOverColor(), path, StiPathGeom.GetBoundsState, null);
        }
    }

    private boolean Intersection(StiPoint point, StiPoint pointEnd, StiPoint pointNext, StiPoint pointNextEnd) {
        if (pointNext == null) {
            return false;
        }
        return point.getValue().y > pointEnd.getValue().y && pointNext.getValue().y < pointNextEnd.getValue().y || point.getValue().y < pointEnd.getValue().y && pointNext.getValue().y > pointNextEnd.getValue().y || pointNext.getValue().y == pointNextEnd.getValue().y;
    }

    private StiPoint GetPointCross(StiPoint point, StiPoint pointEnd, StiPoint pointNext, StiPoint pointNextEnd) {
        if (pointNext == pointNextEnd) {
            return pointNext;
        }
        double x1 = point.x;
        double y1 = point.y;
        double x2 = pointNext.x;
        double y2 = pointNext.y;
        double x3 = pointEnd.x;
        double y3 = pointEnd.y;
        double x4 = pointNextEnd.x;
        double y4 = pointNextEnd.y;
        double x = -((x1 * y2 - x2 * y1) * (x4 - x3) - (x3 * y4 - x4 * y3) * (x2 - x1)) / ((y1 - y2) * (x4 - x3) - (y3 - y4) * (x2 - x1));
        double y = ((y3 - y4) * -x - (x3 * y4 - x4 * y3)) / (x4 - x3);
        if (x > x1 && x < x2) {
            return new StiPoint(x, y);
        }
        return null;
    }

    public StiRangeSeriesGeom(StiAreaGeom areaGeom, StiPoint[] points, StiPoint[] pointsEnd, IStiSeries series) {
        super(areaGeom, null, points, series);
        this.pointsEnd = pointsEnd;
    }
}

