/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.series.range;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiOpacityAnimation;
import com.stimulsoft.base.context.chart.geoms.StiLinesSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiPathGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.geoms.StiNullableDrawing;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.StiMouseOverHelper;
import com.stimulsoft.report.chart.geoms.series.clusteredColumn.StiSteppedLineSeriesGeom;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.range.IStiSteppedRangeSeries;
import java.util.ArrayList;
import java.util.List;

public class StiSteppedRangeSeriesGeom
extends StiSteppedLineSeriesGeom {
    private StiPoint[] pointsEnd;

    public final StiPoint[] getPointsEnd() {
        return this.pointsEnd;
    }

    public final void setPointsEnd(StiPoint[] value) {
        this.pointsEnd = value;
    }

    @Override
    public void Draw(StiContext context) {
        IStiSteppedRangeSeries areaSeries = this.getSeries() instanceof IStiSteppedRangeSeries ? (IStiSteppedRangeSeries)this.getSeries() : null;
        List<StiPoint[]> list = StiNullableDrawing.GetPointsList(this.GetConvertedPoints(this.getPoints()));
        List<StiPoint[]> listEnd = StiNullableDrawing.GetPointsList(this.GetConvertedPoints(this.getPointsEnd()));
        if (list.size() < 1 || listEnd.size() < 1) {
            return;
        }
        StiPoint[] points = list.get(0);
        StiPoint[] pointsEnd = listEnd.get(0);
        int count = Math.min(points.length, pointsEnd.length);
        ArrayList<StiPoint> pointsLine = new ArrayList<StiPoint>();
        ArrayList<StiPoint> pointsLineEnd = new ArrayList<StiPoint>();
        for (int index = 0; index < count; ++index) {
            StiPoint point = points[index];
            StiPoint pointEnd = pointsEnd[index];
            StiPoint pointNext = null;
            StiPoint pointNextEnd = null;
            if (index != count - 1) {
                pointNext = points[index + 1];
                pointNextEnd = pointsEnd[index + 1];
            }
            pointsLine.add(point);
            pointsLineEnd.add(pointEnd);
            if (this.Intersection(point, pointEnd, pointNext, pointNextEnd)) {
                pointsLine.add(pointNext != null ? pointNext : StiPoint.getEmpty());
                pointsLineEnd.add(pointNextEnd != null ? pointNextEnd : StiPoint.getEmpty());
                this.FillPath(context, this.GetBrush(areaSeries, point, pointEnd), pointsLine, pointsLineEnd);
                pointsLine.clear();
                pointsLineEnd.clear();
                pointsLine.add(pointNext != null ? pointNext : StiPoint.getEmpty());
                pointsLineEnd.add(pointNextEnd != null ? pointNextEnd : StiPoint.getEmpty());
                continue;
            }
            if (pointNext != null) continue;
            this.FillPath(context, this.GetBrush(areaSeries, point, pointEnd), pointsLine, pointsLineEnd);
        }
    }

    private StiBrush GetBrush(IStiSteppedRangeSeries areaSeries, StiPoint point, StiPoint pointEnd) {
        StiBrush brush = areaSeries.getBrush();
        if (areaSeries.getAllowApplyBrushNegative()) {
            brush = point.getValue().y < pointEnd.getValue().y ? areaSeries.getBrushNegative() : areaSeries.getBrush();
        }
        return brush;
    }

    private void FillPath(StiContext context, StiBrush brush, ArrayList<StiPoint> pointsLine, ArrayList<StiPoint> pointsLineEnd) {
        ArrayList<StiLinesSegmentGeom> path = new ArrayList<StiLinesSegmentGeom>();
        StiPoint[] newPointsAll = new StiPoint[pointsLine.size() + pointsLineEnd.size() + 2];
        newPointsAll[0] = pointsLineEnd.get(0);
        System.arraycopy(pointsLine.toArray(new StiPoint[pointsLine.size()]), 0, newPointsAll, 1, pointsLine.size());
        newPointsAll[pointsLine.size() + 1] = pointsLineEnd.get(pointsLineEnd.size() - 1);
        System.arraycopy(pointsLineEnd, 0, pointsLine, pointsLine.size() + 2, pointsLineEnd.size());
        path.add(new StiLinesSegmentGeom(newPointsAll));
        StiChart chart = (StiChart)this.getSeries().getChart();
        if (chart.isAnimation) {
            StiOpacityAnimation animation = new StiOpacityAnimation(StiChartHelper.GlobalDurationElement, StiChartHelper.GlobalBeginTimeElement);
            context.FillDrawAnimationPath((Object)brush, null, path, StiPathGeom.GetBoundsState, null, (StiAnimation)animation, null);
        } else {
            context.FillPath((Object)brush, path, StiPathGeom.GetBoundsState, null);
        }
        if (this.getIsMouseOver() || this.getSeries().getCore().getIsMouseOver()) {
            context.FillPath((Object)StiMouseOverHelper.GetMouseOverColor(), path, StiPathGeom.GetBoundsState, null);
        }
    }

    private boolean Intersection(StiPoint point, StiPoint pointEnd, StiPoint pointNext, StiPoint pointNextEnd) {
        if (pointNext == null) {
            return false;
        }
        return point.getValue().y > pointEnd.getValue().y && pointNext.getValue().y < pointNextEnd.getValue().y || point.getValue().y < pointEnd.getValue().y && pointNext.getValue().y > pointNextEnd.getValue().y || pointNext.getValue().y == pointNextEnd.getValue().y;
    }

    public StiSteppedRangeSeriesGeom(StiAreaGeom areaGeom, StiPoint[] points, StiPoint[] pointsEnd, IStiSeries series) {
        super(areaGeom, null, points, series);
        this.pointsEnd = pointsEnd;
    }
}

