/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.series.stackedColumn;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiOpacityAnimation;
import com.stimulsoft.base.context.chart.geoms.StiCurveSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiLineSegmentGeom;
import com.stimulsoft.base.context.chart.geoms.StiPathGeom;
import com.stimulsoft.base.system.StiRefObject;
import com.stimulsoft.base.system.geometry.StiPoint;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.StiChartHelper;
import com.stimulsoft.report.chart.StiInteractionOptions;
import com.stimulsoft.report.chart.StiPointHelper;
import com.stimulsoft.report.chart.geoms.StiNullableDrawing;
import com.stimulsoft.report.chart.geoms.areas.StiAreaGeom;
import com.stimulsoft.report.chart.geoms.series.StiMouseOverHelper;
import com.stimulsoft.report.chart.geoms.series.StiSeriesGeom;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.areas.IStiAxisArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.stackedColumn.IStiStackedSplineAreaSeries;
import java.util.ArrayList;

public class StiStackedSplineAreaSeriesGeom
extends StiSeriesGeom {
    private final StiPoint[] startPoints;
    private final StiPoint[] endPoints;

    @Override
    public void InvokeMouseEnter(StiInteractionOptions options) {
        if (!this.getAllowMouseOver()) {
            return;
        }
        if (!this.getIsMouseOver()) {
            this.setIsMouseOver(true);
            options.setUpdateContext(true);
        }
    }

    @Override
    public void InvokeMouseLeave(StiInteractionOptions options) {
        if (!this.getAllowMouseOver()) {
            return;
        }
        if (this.getIsMouseOver()) {
            this.setIsMouseOver(false);
            options.setUpdateContext(true);
        }
    }

    public boolean getAllowMouseOver() {
        return this.getSeries().getInteraction().getDrillDownEnabled() && this.getSeries().getInteraction().getAllowSeries();
    }

    public boolean getIsMouseOver() {
        if (this.getSeries() == null) {
            return false;
        }
        return this.getSeries().getCore().getIsMouseOver();
    }

    public void setIsMouseOver(boolean value) {
        if (this.getSeries() != null) {
            this.getSeries().getCore().setIsMouseOver(value);
        }
    }

    public final StiPoint[] getStartPoints() {
        return this.startPoints;
    }

    public final StiPoint[] getEndPoints() {
        return this.endPoints;
    }

    @Override
    public boolean Contains(double x, double y) {
        IStiArea tempVar = this.getSeries().getChart().getArea();
        IStiAxisArea axisArea = (IStiAxisArea)(tempVar instanceof IStiAxisArea ? tempVar : null);
        double posY = axisArea.getAxisCore().GetDividerY();
        if (this.getInvisible()) {
            return false;
        }
        for (int pointIndex = 0; pointIndex < this.getStartPoints().length - 1; ++pointIndex) {
            boolean result;
            StiPoint point1 = this.getStartPoints()[pointIndex];
            StiPoint point4 = this.getStartPoints()[pointIndex + 1];
            StiPoint point2 = this.getEndPoints()[pointIndex];
            StiPoint point3 = this.getEndPoints()[pointIndex + 1];
            if (point1 == null || point2 == null || point3 == null || point4 == null || !(result = StiPointHelper.IsPointInPolygon(new StiPoint(x, y), new StiPoint[]{point1.getValue(), point4.getValue(), point3.getValue(), point2.getValue()}))) continue;
            return true;
        }
        return false;
    }

    public static StiRectangle GetClientRectangle(StiPoint[] startPoints, StiPoint[] endPoints) {
        if (startPoints == null || startPoints.length == 0 || endPoints == null || endPoints.length == 0) {
            return StiRectangle.getEmpty();
        }
        StiPoint minPoint = StiPoint.getEmpty();
        StiPoint maxPoint = StiPoint.getEmpty();
        for (StiPoint point : startPoints) {
            if (point == null) continue;
            if (minPoint.equals((Object)StiPoint.getEmpty())) {
                minPoint = point.getValue();
                maxPoint = point.getValue();
                continue;
            }
            minPoint.x = Math.min(minPoint.x, point.getValue().x);
            minPoint.y = Math.min(minPoint.y, point.getValue().y);
            maxPoint.x = Math.max(maxPoint.x, point.getValue().x);
            maxPoint.y = Math.max(maxPoint.y, point.getValue().y);
        }
        for (StiPoint point : endPoints) {
            if (point == null) continue;
            if (minPoint.equals((Object)StiPoint.getEmpty())) {
                minPoint = point.getValue();
                maxPoint = point.getValue();
                continue;
            }
            minPoint.x = Math.min(minPoint.x, point.getValue().x);
            minPoint.y = Math.min(minPoint.y, point.getValue().y);
            maxPoint.x = Math.max(maxPoint.x, point.getValue().x);
            maxPoint.y = Math.max(maxPoint.y, point.getValue().y);
        }
        return new StiRectangle(minPoint.x, minPoint.y, maxPoint.x - minPoint.x, maxPoint.y - minPoint.y);
    }

    @Override
    public void Draw(StiContext context) {
        IStiSeries tempVar = this.getSeries();
        IStiStackedSplineAreaSeries areaSeries = (IStiStackedSplineAreaSeries)(tempVar instanceof IStiStackedSplineAreaSeries ? tempVar : null);
        IStiArea tempVar2 = this.getSeries().getChart().getArea();
        IStiAxisArea axisArea = (IStiAxisArea)(tempVar2 instanceof IStiAxisArea ? tempVar2 : null);
        ArrayList startList = null;
        ArrayList endList = null;
        StiRefObject tempRef_startList = new StiRefObject(startList);
        StiRefObject tempRef_endList = new StiRefObject(endList);
        StiNullableDrawing.GetPointsList(this.getStartPoints(), this.getEndPoints(), (StiRefObject<ArrayList<StiPoint[]>>)tempRef_startList, (StiRefObject<ArrayList<StiPoint[]>>)tempRef_endList);
        startList = (ArrayList)tempRef_startList.argvalue;
        endList = (ArrayList)tempRef_endList.argvalue;
        StiChart chart = (StiChart)this.getSeries().getChart();
        int listIndex = 0;
        for (StiPoint[] newStartPoints : startList) {
            StiPoint[] newEndPoints = (StiPoint[])endList.get(listIndex);
            ArrayList<Object> path = new ArrayList<Object>();
            path.add(new StiLineSegmentGeom(newStartPoints[0], newEndPoints[0]));
            path.add(new StiCurveSegmentGeom(newEndPoints, areaSeries.getTension()));
            path.add(new StiLineSegmentGeom(newEndPoints[newEndPoints.length - 1], newStartPoints[newStartPoints.length - 1]));
            StiPoint[] revertStartPoints = new StiPoint[newStartPoints.length];
            int index = 0;
            int index1 = newStartPoints.length - 1;
            while (index < newStartPoints.length) {
                revertStartPoints[index] = newStartPoints[index1];
                ++index;
                --index1;
            }
            path.add(new StiCurveSegmentGeom(revertStartPoints, areaSeries.getTension()));
            if (areaSeries.getBrush() != null) {
                if (chart.isAnimation) {
                    StiOpacityAnimation animation = new StiOpacityAnimation(StiChartHelper.GlobalDurationElement, StiChartHelper.GlobalBeginTimeElement);
                    context.FillDrawAnimationPath((Object)areaSeries.getBrush(), null, path, StiPathGeom.GetBoundsState, null, (StiAnimation)animation, null);
                } else {
                    context.FillPath((Object)areaSeries.getBrush(), path, StiPathGeom.GetBoundsState, null);
                }
            }
            if (areaSeries.getAllowApplyBrushNegative() && areaSeries.getBrushNegative() != null) {
                double posY = axisArea.getAxisCore().GetDividerY();
                double width = axisArea.getAxisCore().getScrollRangeX() * axisArea.getAxisCore().getScrollDpiX();
                double height = axisArea.getAxisCore().getScrollRangeY() * axisArea.getAxisCore().getScrollDpiY() - posY;
                StiRectangle clipRect = new StiRectangle(0.0, posY, width, height);
                context.PushClip(clipRect);
                if (chart.isAnimation) {
                    StiOpacityAnimation animation = new StiOpacityAnimation(StiChartHelper.GlobalDurationElement, StiChartHelper.GlobalBeginTimeElement);
                    context.FillDrawAnimationPath((Object)areaSeries.getBrushNegative(), null, path, StiPathGeom.GetBoundsState, null, (StiAnimation)animation, null);
                } else {
                    context.FillPath((Object)areaSeries.getBrushNegative(), path, StiPathGeom.GetBoundsState, null);
                }
                context.PopClip();
            }
            if (this.getIsMouseOver() || this.getSeries().getCore().getIsMouseOver()) {
                context.FillPath((Object)StiMouseOverHelper.GetMouseOverColor(), path, StiPathGeom.GetBoundsState, null);
            }
            ++listIndex;
        }
    }

    public StiStackedSplineAreaSeriesGeom(StiAreaGeom areaGeom, StiPoint[] startPoints, StiPoint[] endPoints, IStiSeries series) {
        super(areaGeom, series, StiStackedSplineAreaSeriesGeom.GetClientRectangle(startPoints, endPoints));
        this.startPoints = startPoints;
        this.endPoints = endPoints;
    }
}

