/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.seriesLabels.axis;

import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiOpacityAnimation;
import com.stimulsoft.base.context.chart.geoms.StiFontGeom;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.context.chart.geoms.StiStringFormatGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.drawing.enums.StiRotationMode;
import com.stimulsoft.base.drawing.enums.StiStringAlignment;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.geoms.series.StiMouseOverHelper;
import com.stimulsoft.report.chart.geoms.seriesLabels.StiSeriesLabelsGeom;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.seriesLabels.IStiSeriesLabels;
import com.stimulsoft.report.chart.interfaces.seriesLabels.axis.IStiInsideBaseAxisLabels;

public class StiCenterAxisLabelsGeom
extends StiSeriesLabelsGeom {
    private final StiColor labelColor;
    private final StiColor labelBorderColor;
    private final StiBrush seriesBrush;
    private final StiBrush seriesLabelsBrush;
    private final StiColor seriesBorderColor;
    private final StiFontGeom font;
    private final String text;
    private StiAnimation animation;

    public final StiColor getLabelColor() {
        return this.labelColor;
    }

    public final StiColor getLabelBorderColor() {
        return this.labelBorderColor;
    }

    public final StiBrush getSeriesBrush() {
        return this.seriesBrush;
    }

    public final StiBrush getSeriesLabelsBrush() {
        return this.seriesLabelsBrush;
    }

    public final StiColor getSeriesBorderColor() {
        return this.seriesBorderColor;
    }

    public final StiFontGeom getFont() {
        return this.font;
    }

    public final String getText() {
        return this.text;
    }

    public StiAnimation getAnimation() {
        return this.animation;
    }

    @Override
    public void Draw(StiContext context) {
        StiRectangle labelRect = StiRectangle.round((StiRectangle)this.getClientRectangle());
        StiPenGeom borderPen = new StiPenGeom((Object)this.getLabelBorderColor(), 1.0f);
        StiSolidBrush labelBrush = new StiSolidBrush(this.getLabelColor());
        StiStringFormatGeom sf = context.GetDefaultStringFormat();
        sf.setAlignment(StiStringAlignment.Center);
        sf.setLineAlignment(StiStringAlignment.Center);
        StiChart chart = (StiChart)this.getSeries().getChart();
        if (chart.isAnimation) {
            this.DrawMarker(context, labelRect, this.getSeriesBorderColor(), this.getSeriesBrush());
            if (this.animation == null) {
                this.animation = new StiOpacityAnimation(this.getDuration(), this.getBeginTime());
            }
            context.DrawAnimationLabel(this.getText(), this.font, (Object)labelBrush, (Object)this.seriesLabelsBrush, borderPen, labelRect, sf, StiRotationMode.CenterCenter, this.getSeriesLabels().getAngle(), Boolean.valueOf(this.getSeriesLabels().getDrawBorder()), this.animation);
        } else {
            this.DrawMarker(context, labelRect, this.getSeriesBorderColor(), this.getSeriesBrush());
            if (this.getSeriesLabels() instanceof IStiInsideBaseAxisLabels) {
                int offsetY = (int)(labelRect.width / 2.0 * Math.sin((double)this.getSeriesLabels().getAngle() * Math.PI / 180.0));
                labelRect.y = this.getSeriesLabels().getAngle() % 360.0f < 180.0f ? (labelRect.y -= (double)offsetY) : (labelRect.y += (double)offsetY);
            }
            int distX = (int)(labelRect.x + labelRect.width / 2.0);
            int distY = (int)(labelRect.y + labelRect.height / 2.0);
            context.PushTranslateTransform((double)distX, (double)distY);
            context.PushRotateTransform(this.getSeriesLabels().getAngle());
            StiRectangle rect = labelRect.clone();
            rect.x = -rect.width / 2.0;
            rect.y = -rect.height / 2.0;
            context.FillRectangle((Object)this.seriesLabelsBrush, rect, null);
            if (this.getSeriesLabels().getDrawBorder()) {
                context.DrawRectangle(borderPen, rect.x, rect.y, rect.width, rect.height);
            }
            context.PopTransform();
            context.PopTransform();
            context.DrawRotatedString(this.getText(), this.font, (Object)labelBrush, labelRect, sf, StiRotationMode.CenterCenter, this.getSeriesLabels().getAngle(), this.getSeriesLabels().getAntialiasing());
            if (this.getIsMouseOver()) {
                context.FillRectangle((Object)StiMouseOverHelper.GetLineMouseOverColor(), labelRect, null);
            }
        }
    }

    public StiCenterAxisLabelsGeom(IStiSeriesLabels seriesLabels, IStiSeries series, int index, double value, StiRectangle clientRectangle, String text, StiColor labelColor, StiColor labelBorderColor, StiBrush seriesBrush, StiBrush seriesLabelsBrush, StiColor seriesBorderColor, StiFontGeom font, StiAnimation animation) {
        super(seriesLabels, series, index, value, clientRectangle);
        this.text = text;
        this.labelColor = labelColor;
        this.labelBorderColor = labelBorderColor;
        this.seriesBrush = seriesBrush;
        this.seriesLabelsBrush = seriesLabelsBrush;
        this.seriesBorderColor = seriesBorderColor;
        this.font = font;
        this.animation = animation;
    }
}

