/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.geoms.seriesLabels.pie;

import com.stimulsoft.base.IStiEnum;
import com.stimulsoft.base.context.chart.StiContext;
import com.stimulsoft.base.context.chart.animation.StiAnimation;
import com.stimulsoft.base.context.chart.animation.StiOpacityAnimation;
import com.stimulsoft.base.context.chart.geoms.StiFontGeom;
import com.stimulsoft.base.context.chart.geoms.StiPenGeom;
import com.stimulsoft.base.context.chart.geoms.StiStringFormatGeom;
import com.stimulsoft.base.context.chart.geoms.StiTextGeom;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.enums.StiRotationMode;
import com.stimulsoft.base.drawing.enums.StiStringFormatFlags;
import com.stimulsoft.base.drawing.enums.StiStringTrimming;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.geoms.series.StiMouseOverHelper;
import com.stimulsoft.report.chart.geoms.seriesLabels.StiSeriesLabelsGeom;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.seriesLabels.IStiSeriesLabels;
import com.stimulsoft.report.chart.interfaces.seriesLabels.pie.IStiCenterPieLabels;

public class StiCenterPieLabelsGeom
extends StiSeriesLabelsGeom {
    private final StiBrush seriesBrush;
    private final StiColor borderColor;
    private final StiColor seriesBorderColor;
    private final StiBrush labelBrush;
    private final String text;
    private final StiRotationMode rotationMode;
    private final StiRectangle labelRect;
    private final double angleToUse;
    private StiAnimation animation;
    private StiBrush seriesLabelsBrush;

    public final StiBrush getSeriesBrush() {
        return this.seriesBrush;
    }

    public final StiColor getBorderColor() {
        return this.borderColor;
    }

    public final StiColor getSeriesBorderColor() {
        return this.seriesBorderColor;
    }

    public final StiBrush getLabelBrush() {
        return this.labelBrush;
    }

    public final String getText() {
        return this.text;
    }

    public final StiRotationMode getRotationMode() {
        return this.rotationMode;
    }

    public final StiRectangle getLabelRect() {
        return this.labelRect;
    }

    public final double getAngleToUse() {
        return this.angleToUse;
    }

    public StiAnimation getAnimation() {
        return this.animation;
    }

    public void setAnimation(StiAnimation animation) {
        this.animation = animation;
    }

    public StiBrush getSeriesLabelsBrush() {
        return this.seriesLabelsBrush;
    }

    @Override
    public void Draw(StiContext context) {
        StiRectangle rect = StiRectangle.round((StiRectangle)this.getClientRectangle());
        IStiSeriesLabels tempVar = this.getSeriesLabels();
        IStiCenterPieLabels centerPieLabels = (IStiCenterPieLabels)(tempVar instanceof IStiCenterPieLabels ? tempVar : null);
        StiPenGeom borderPen = new StiPenGeom((Object)this.getBorderColor());
        StiFontGeom font = StiFontGeom.ChangeFontSize((StiFont)this.getSeriesLabels().getFont(), (float)((float)(this.getSeriesLabels().getFont().size * (double)context.Options.zoom)));
        StiStringFormatGeom sf = context.GetGenericStringFormat();
        sf.setTrimming(StiStringTrimming.None);
        sf.getFormatFlags().OR((IStiEnum)StiStringFormatFlags.MeasureTrailingSpaces);
        sf.getFormatFlags().OR((IStiEnum)StiStringFormatFlags.NoWrap);
        StiChart chart = (StiChart)this.getSeries().getChart();
        if (chart.isAnimation) {
            if (this.animation == null) {
                this.animation = new StiOpacityAnimation(this.getDuration(), this.getBeginTime());
            }
            context.DrawAnimationLabel(this.text, font, (Object)this.labelBrush, (Object)this.seriesLabelsBrush, borderPen, StiRectangle.round((StiRectangle)this.labelRect), sf, this.rotationMode, this.getSeriesLabels().getAngle(), Boolean.valueOf(this.getSeriesLabels().getDrawBorder()), this.animation);
        } else {
            this.DrawMarker(context, StiRectangle.round((StiRectangle)this.labelRect), this.getSeriesBorderColor(), this.getSeriesBrush());
            int distX = (int)((double)((int)Math.round((this.labelRect.x + this.labelRect.width / 2.0) * Math.pow(10.0, 0.0))) / Math.pow(10.0, 0.0));
            int distY = (int)((double)((int)Math.round((this.labelRect.y + this.labelRect.height / 2.0) * Math.pow(10.0, 0.0))) / Math.pow(10.0, 0.0));
            context.PushTranslateTransform((double)distX, (double)distY);
            context.PushRotateTransform((float)this.getAngleToUse());
            if (!rect.isEmpty().booleanValue()) {
                context.FillRectangle((Object)this.getSeriesLabelsBrush(), rect, null);
                if (this.getSeriesLabels().getDrawBorder()) {
                    context.DrawRectangle(borderPen, rect.x, rect.y, rect.width, rect.height);
                }
                if (this.getIsMouseOver()) {
                    context.FillRectangle((Object)StiMouseOverHelper.GetLineMouseOverColor(), rect.x, rect.y, rect.width, rect.height, null);
                }
            }
            context.PopTransform();
            context.PopTransform();
            StiTextGeom textGeom = context.DrawRotatedString(this.getText(), font, (Object)this.labelBrush, StiRectangle.round((StiRectangle)this.labelRect), sf, this.rotationMode, (float)this.angleToUse, this.getSeriesLabels().getAntialiasing());
            textGeom.setRounded(true);
        }
    }

    public StiCenterPieLabelsGeom(IStiSeriesLabels seriesLabels, IStiSeries series, int index, double value, StiRectangle clientRectangle, String text, StiBrush seriesBrush, StiBrush labelBrush, StiBrush seriesLabelBrush, StiColor borderColor, StiColor seriesBorderColor, StiRotationMode rotationMode, StiRectangle labelRect, double angleToUse, StiAnimation animation) {
        super(seriesLabels, series, index, value, clientRectangle);
        this.text = text;
        this.labelBrush = labelBrush;
        this.borderColor = borderColor;
        this.seriesBorderColor = seriesBorderColor;
        this.seriesBrush = seriesBrush;
        this.rotationMode = rotationMode;
        this.labelRect = labelRect;
        this.angleToUse = angleToUse;
        this.seriesLabelsBrush = seriesLabelBrush;
        this.animation = animation;
    }
}

