/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.view.series;

import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.localization.StiLocalization;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.interfaces.IStiApplyStyle;
import com.stimulsoft.report.chart.interfaces.areas.IStiArea;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.seriesLabels.IStiSeriesLabels;
import com.stimulsoft.report.chart.interfaces.styles.IStiChartStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StiSeriesCollection
extends ArrayList<IStiSeries>
implements IStiApplyStyle,
IStiJsonReportObject {
    private static final long serialVersionUID = -2156486349250480560L;
    private StiChart chart = null;

    public IStiSeries getItem(int seriesIndex) {
        return (IStiSeries)this.get(seriesIndex);
    }

    @Override
    public void applyStyle(IStiChartStyle style) {
        if (style == null) {
            return;
        }
        StiColor[] colors = style.getCore().GetColors(this.size());
        int index = 0;
        for (IStiSeries series : this) {
            series.getCore().ApplyStyle(style, colors[index++]);
        }
    }

    private String GetSeriesTitle() {
        String baseTitle;
        String title = baseTitle = StiLocalization.getValue((String)"Chart", (String)"Series");
        int index = 1;
        boolean finded = true;
        while (finded) {
            title = baseTitle + " " + new Integer(index).toString();
            finded = false;
            for (IStiSeries series : this) {
                if (!series.getCoreTitle().equals(title)) continue;
                finded = true;
                break;
            }
            ++index;
        }
        return title;
    }

    @Override
    public boolean add(IStiSeries element) {
        return this.add(element, true);
    }

    public boolean add(IStiSeries element, boolean allowApplyStyle) {
        this.setChart(element);
        boolean res = super.add(element);
        StiChart chart = this.getChart();
        if (chart.getArea() == null || !chart.getArea().getCore().IsAcceptableSeries(element.getClass())) {
            try {
                chart.setArea((IStiArea)element.GetDefaultAreaType().newInstance());
                if (chart.getSeriesLabels() == null || !chart.getArea().getCore().IsAcceptableSeriesLabels(chart.getSeriesLabels().getClass())) {
                    chart.setSeriesLabels((IStiSeriesLabels)chart.getArea().GetDefaultSeriesLabelsType().newInstance());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (chart.getAllowApplyStyle() && allowApplyStyle) {
            chart.getCore().applyStyle(chart.getStyle());
        }
        return res;
    }

    @Override
    public void add(int index, IStiSeries element) {
        this.setChart(element);
        super.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends IStiSeries> c) {
        for (IStiSeries iStiSeries : c) {
            this.setChart(iStiSeries);
        }
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends IStiSeries> c) {
        for (IStiSeries iStiSeries : c) {
            this.setChart(iStiSeries);
        }
        return super.addAll(index, c);
    }

    @Override
    public IStiSeries set(int index, IStiSeries element) {
        this.setChart(element);
        return super.set(index, element);
    }

    private void setChart(IStiSeries value) {
        if (this.getChart() != null) {
            if (StiValidationUtil.isNullOrEmpty((String)value.getCoreTitle())) {
                value.setCoreTitle(this.GetSeriesTitle());
            }
            value.setChart(this.getChart());
        }
    }

    public final StiChart getChart() {
        return this.chart;
    }

    public final void setChart(StiChart value) {
        this.chart = value;
    }

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        if (this.size() == 0) {
            return null;
        }
        JSONObject jObject = new JSONObject();
        Integer index = 0;
        for (IStiSeries component : this) {
            jObject.AddPropertyJObject(index.toString(), component.SaveToJsonObject(mode));
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            JSONObject propJSONObject = (JSONObject)property.Value;
            String ident = (String)propJSONObject.Properties().FirstOrDefault((String)"Ident").Value;
            List<Class<?>> classes = StiOptions.Services.getChartSeries();
            Class<?> clazz = null;
            for (Class<?> claz : classes) {
                String name = claz.getName();
                if (!name.substring(name.lastIndexOf(46) + 1).equals(ident)) continue;
                clazz = claz;
            }
            IStiSeries seriesClone = null;
            if (clazz == null) continue;
            try {
                seriesClone = (IStiSeries)clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            seriesClone.setChart(this.chart);
            this.add(seriesClone);
            seriesClone.LoadFromJsonObject((JSONObject)property.Value);
        }
    }
}

