/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.view.series.bubble;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.annotations.StiSerializeTypesEnum;
import com.stimulsoft.report.chart.StiChart;
import com.stimulsoft.report.chart.core.series.bubble.StiBubbleSeriesCoreXF;
import com.stimulsoft.report.chart.interfaces.marker.IStiLineMarker;
import com.stimulsoft.report.chart.interfaces.marker.IStiMarker;
import com.stimulsoft.report.chart.interfaces.series.bubble.IStiBubbleSeries;
import com.stimulsoft.report.chart.interfaces.series.scatter.IStiScatterSeries;
import com.stimulsoft.report.chart.view.areas.bubble.StiBubbleArea;
import com.stimulsoft.report.chart.view.events.StiGetListOfWeightsEvent;
import com.stimulsoft.report.chart.view.expressions.StiListOfWeightsExpression;
import com.stimulsoft.report.chart.view.series.StiSeries;
import com.stimulsoft.report.chart.view.series.scatter.StiScatterSeries;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.events.StiGetValueEvent;
import com.stimulsoft.report.events.StiGetValueEventArgs;
import com.stimulsoft.report.expressions.StiExpression;
import java.util.ArrayList;
import java.util.Arrays;

public class StiBubbleSeries
extends StiScatterSeries
implements IStiBubbleSeries {
    private StiColor borderColor = StiColor.Gray;
    private StiBrush brush = new StiSolidBrush(StiColor.Gainsboro);
    private ArrayList<Double> weights = new ArrayList<Double>(Arrays.asList(1.0, 3.0, 2.0));
    private String weightDataColumn = "";
    private StiGetValueEvent getWeightEvent = new StiGetValueEvent();
    private StiGetListOfWeightsEvent getListOfWeightsEvent = new StiGetListOfWeightsEvent();
    private StiExpression weight = new StiExpression();
    private StiListOfWeightsExpression listOfWeights = new StiListOfWeightsExpression();

    @Override
    public IStiBubbleSeries clone() {
        IStiScatterSeries tempVar = super.clone();
        IStiBubbleSeries series = (IStiBubbleSeries)(tempVar instanceof IStiBubbleSeries ? tempVar : null);
        return series;
    }

    @Override
    public Class GetDefaultAreaType() {
        return StiBubbleArea.class;
    }

    @Override
    @StiSerializable(need=false)
    public IStiLineMarker getLineMarker() {
        return super.getLineMarker();
    }

    @Override
    public void setLineMarker(IStiLineMarker value) {
        super.setLineMarker(value);
    }

    @Override
    @StiSerializable(need=false)
    public IStiMarker getMarker() {
        return super.getMarker();
    }

    @Override
    public void setMarker(IStiMarker value) {
        super.setMarker(value);
    }

    @Override
    public StiColor getLineColor() {
        return super.getLineColor();
    }

    @Override
    public void setLineColor(StiColor value) {
        super.setLineColor(value);
    }

    @Override
    public StiColor getLineColorNegative() {
        return super.getLineColorNegative();
    }

    @Override
    public void setLineColorNegative(StiColor value) {
        super.setLineColorNegative(value);
    }

    @Override
    public boolean getAllowApplyColorNegative() {
        return super.getAllowApplyColorNegative();
    }

    @Override
    public void setAllowApplyColorNegative(boolean value) {
        super.setAllowApplyColorNegative(value);
    }

    @Override
    @StiSerializable
    public final StiColor getBorderColor() {
        return this.borderColor;
    }

    @Override
    public final void setBorderColor(StiColor value) {
        this.borderColor = value;
    }

    @Override
    @StiSerializable
    public final StiBrush getBrush() {
        return this.brush;
    }

    @Override
    public final void setBrush(StiBrush value) {
        this.brush = value;
    }

    @Override
    public final ArrayList<Double> getWeights() {
        if (this.getChart() != null && ((StiChart)this.getChart()).getReport() != null && this.getChart().getIsDesigning()) {
            if (this.getListOfWeights().getValue() != null && this.getListOfWeights().getValue().length() > 0) {
                return StiSeries.GetValuesFromString(this.getListOfWeights().getValue());
            }
            int serIndex = this.getChart().getSeries().indexOf(this);
            if (serIndex == 0) {
                return this.weights;
            }
            return new ArrayList<Integer>(Arrays.asList(3 + serIndex * 3, 5 + serIndex * 4, 9 + serIndex * 3));
        }
        return this.weights;
    }

    @Override
    public final void setWeights(ArrayList<Double> value) {
        this.weights = value;
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToDocument)
    public final String getWeightsString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (double value : this.weights) {
            if (first) {
                sb.append(String.format("%1$s", value));
            } else {
                sb.append(String.format(";%1$s", value));
            }
            first = false;
        }
        return sb.toString();
    }

    public final void setWeightsString(String value) {
        if (value == null || value.trim().length() == 0) {
            this.weights = new ArrayList();
        } else {
            String[] strs = value.split("[;]", -1);
            this.weights = new ArrayList();
            for (String str : strs) {
                this.weights.add(Double.parseDouble(str));
            }
        }
    }

    @StiDefaulValue(value="")
    @StiSerializable
    public final String getWeightDataColumn() {
        return this.weightDataColumn;
    }

    public final void setWeightDataColumn(String value) {
        this.weightDataColumn = value;
    }

    protected void OnGetWeight(StiGetValueEventArgs e) {
    }

    public void InvokeGetWeight(StiComponent sender, StiGetValueEventArgs e) {
        this.OnGetWeight(e);
    }

    @StiSerializable
    public final StiGetValueEvent getGetWeightEvent() {
        return this.getWeightEvent;
    }

    public final void setGetWeightEvent(StiGetValueEvent value) {
        this.getWeightEvent = value;
    }

    protected void OnGetListOfWeights(StiGetValueEventArgs e) {
    }

    public final void InvokeGetListOfWeights(StiComponent sender, StiGetValueEventArgs e) {
        this.OnGetListOfWeights(e);
    }

    @StiSerializable
    public final StiGetListOfWeightsEvent getGetListOfWeightsEvent() {
        return this.getListOfWeightsEvent;
    }

    public final void setGetListOfWeightsEvent(StiGetListOfWeightsEvent value) {
        this.getListOfWeightsEvent = value;
    }

    @StiSerializable
    public StiExpression getWeight() {
        return this.weight;
    }

    public void setWeight(StiExpression value) {
        this.weight = value;
    }

    @StiSerializable(type=StiSerializeTypesEnum.SerializeToSaveLoad)
    public StiListOfWeightsExpression getListOfWeights() {
        return this.listOfWeights;
    }

    public void setListOfWeights(StiListOfWeightsExpression value) {
        this.listOfWeights = value;
    }

    public StiBubbleSeries() {
        this.setCore(new StiBubbleSeriesCoreXF(this));
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.RemoveProperty("LineMarker");
        jObject.RemoveProperty("Marker");
        jObject.AddPropertyString("BorderColor", StiJsonReportObjectHelper.Serialize.JColor((StiColor)this.borderColor, (StiColorEnum)StiColorEnum.Gray));
        jObject.AddPropertyStringNullOfEmpty("Brush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.brush));
        jObject.AddPropertyStringNullOfEmpty("WeightDataColumn", this.getWeightDataColumn());
        jObject.AddPropertyJObject("GetWeightEvent", this.getGetWeightEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("GetListOfWeightsEvent", this.getGetListOfWeightsEvent().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("Weight", this.getWeight().SaveToJsonObject(mode));
        jObject.AddPropertyJObject("ListOfWeights", this.getListOfWeights().SaveToJsonObject(mode));
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("BorderColor")) {
                this.borderColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("Brush")) {
                this.brush = StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property);
                continue;
            }
            if (property.Name.equals("WeightDataColumn")) {
                this.weightDataColumn = (String)property.Value;
                continue;
            }
            if (property.Name.equals("GetWeightEvent")) {
                this.getWeightEvent.LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("GetListOfWeightsEvent")) {
                this.getListOfWeightsEvent.LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (property.Name.equals("Weight")) {
                this.getWeight().LoadFromJsonObject((JSONObject)property.Value);
                continue;
            }
            if (!property.Name.equals("ListOfWeights")) continue;
            this.getListOfWeights().LoadFromJsonObject((JSONObject)property.Value);
        }
    }
}

