/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.chart.view.series.stackedBar;

import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.report.chart.core.series.stackedBar.StiStackedBarSeriesCoreXF;
import com.stimulsoft.report.chart.interfaces.series.IStiSeries;
import com.stimulsoft.report.chart.interfaces.series.stackedBar.IStiStackedBarSeries;
import com.stimulsoft.report.chart.interfaces.trendLines.IStiTrendLine;
import com.stimulsoft.report.chart.view.areas.stackedBar.StiStackedBarArea;
import com.stimulsoft.report.chart.view.series.StiSeries;

public class StiStackedBarSeries
extends StiSeries
implements IStiStackedBarSeries {
    private boolean showZeros = false;
    private float width = 0.8f;
    private StiColor borderColor = StiColor.Black;
    private StiBrush brush = new StiSolidBrush(StiColor.Gainsboro);
    private StiBrush brushNegative = new StiSolidBrush(StiColor.Firebrick);
    private boolean allowApplyBrushNegative = false;

    @Override
    public IStiStackedBarSeries clone() {
        IStiSeries tempVar = super.clone();
        IStiStackedBarSeries series = (IStiStackedBarSeries)(tempVar instanceof IStiStackedBarSeries ? tempVar : null);
        Object tempVar2 = this.getBrush().clone();
        series.setBrush((StiBrush)(tempVar2 instanceof StiBrush ? tempVar2 : null));
        return series;
    }

    @Override
    public Class GetDefaultAreaType() {
        return StiStackedBarArea.class;
    }

    @Override
    @StiSerializable(need=false)
    public IStiTrendLine getTrendLine() {
        return super.getTrendLine();
    }

    @Override
    public void setTrendLine(IStiTrendLine value) {
        super.setTrendLine(value);
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="false")
    public boolean getShowZeros() {
        return this.showZeros;
    }

    @Override
    public void setShowZeros(boolean value) {
        this.showZeros = value;
    }

    @Override
    @StiDefaulValue(value="0.8")
    @StiSerializable
    public final float getWidth() {
        return this.width;
    }

    @Override
    public final void setWidth(float value) {
        if (value >= 0.01f && value <= 1.0f) {
            this.width = value;
        }
    }

    @Override
    @StiSerializable
    public final StiColor getBorderColor() {
        return this.borderColor;
    }

    @Override
    public final void setBorderColor(StiColor value) {
        this.borderColor = value;
    }

    @Override
    @StiSerializable(shortName="bh")
    public final StiBrush getBrush() {
        return this.brush;
    }

    @Override
    public final void setBrush(StiBrush value) {
        this.brush = value;
    }

    @Override
    @StiSerializable
    public final StiBrush getBrushNegative() {
        return this.brushNegative;
    }

    @Override
    public final void setBrushNegative(StiBrush value) {
        this.brushNegative = value;
    }

    @Override
    @StiSerializable
    @StiDefaulValue(value="false")
    public final boolean getAllowApplyBrushNegative() {
        return this.allowApplyBrushNegative;
    }

    @Override
    public final void setAllowApplyBrushNegative(boolean value) {
        this.allowApplyBrushNegative = value;
    }

    public StiStackedBarSeries() {
        this.setCore(new StiStackedBarSeriesCoreXF(this));
    }

    @Override
    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = super.SaveToJsonObject(mode);
        jObject.RemoveProperty("TrendLine");
        jObject.AddPropertyBool("ShowZeros", this.getShowZeros());
        jObject.AddPropertyFloat("Width", (double)this.width, (double)0.8f);
        jObject.AddPropertyStringNullOfEmpty("BorderColor", StiJsonReportObjectHelper.Serialize.JColor((StiColor)this.borderColor, (StiColorEnum)StiColorEnum.Black));
        jObject.AddPropertyStringNullOfEmpty("Brush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.brush));
        jObject.AddPropertyStringNullOfEmpty("BrushNegative", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.brushNegative));
        jObject.AddPropertyBool("AllowApplyBrushNegative", this.allowApplyBrushNegative);
        return jObject;
    }

    @Override
    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        super.LoadFromJsonObject(jObject);
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("ShowZeros")) {
                this.setShowZeros((Boolean)property.Value);
                continue;
            }
            if (property.Name.equals("Width")) {
                this.width = property.floatValue().floatValue();
                continue;
            }
            if (property.Name.equals("BorderColor")) {
                this.borderColor = StiJsonReportObjectHelper.Deserialize.Color((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("Brush")) {
                this.brush = StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property);
                continue;
            }
            if (property.Name.equals("BrushNegative")) {
                this.brushNegative = StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property);
                continue;
            }
            if (!property.Name.equals("AllowApplyBrushNegative")) continue;
            this.allowApplyBrushNegative = (Boolean)property.Value;
        }
    }
}

