/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.check.datarelation;

import com.stimulsoft.base.localization.StiLocalizationExt;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.check.StiCheckStatus;
import com.stimulsoft.report.check.datarelation.StiDataRelationCheck;
import com.stimulsoft.report.dictionary.StiDataRelation;

public class StiKeysNotFoundRelationCheck
extends StiDataRelationCheck {
    private String columns;

    @Override
    public boolean getPreviewVisible() {
        return true;
    }

    public String getColumns() {
        return this.columns;
    }

    public void setColumns(String columns) {
        this.columns = columns;
    }

    @Override
    public String getShortMessage() {
        return StiLocalizationExt.format((String)"CheckDataRelation", (String)"StiKeysNotFoundRelationCheckShort", (Object[])new Object[]{this.getElementName(), this.getColumns()});
    }

    @Override
    public String getLongMessage() {
        return StiLocalizationExt.format((String)"CheckDataRelation", (String)"StiKeysNotFoundRelationCheckLong", (Object[])new Object[]{this.getElementName(), this.getColumns()});
    }

    @Override
    public StiCheckStatus getStatus() {
        return StiCheckStatus.Error;
    }

    private boolean isColumnsExist(StiDataRelation relation) {
        for (String column : relation.getParentColumns()) {
            if (relation.getParentSource().getColumns().contains(column)) continue;
            return false;
        }
        for (String column : relation.getChildColumns()) {
            if (relation.getChildSource().getColumns().contains(column)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object processCheck(StiReport report, Object obj) {
        StiDataRelation relation;
        this.setElement(obj);
        StiDataRelation stiDataRelation = relation = obj instanceof StiDataRelation ? (StiDataRelation)obj : null;
        if (relation != null && relation.getParentSource() != null && relation.getChildSource() != null && !this.isColumnsExist(relation)) {
            boolean finded = false;
            String columns = "";
            for (String column : relation.getParentColumns()) {
                if (relation.getParentSource().getColumns().contains(column)) continue;
                columns = columns.length() == 0 ? columns + column : columns + "; " + column;
                finded = true;
            }
            for (String column : relation.getChildColumns()) {
                if (relation.getChildSource().getColumns().contains(column)) continue;
                columns = columns.length() == 0 ? columns + column : columns + "; " + column;
                finded = true;
            }
            if (finded) {
                StiKeysNotFoundRelationCheck check = new StiKeysNotFoundRelationCheck();
                check.columns = columns;
                check.setElement(obj);
                return check;
            }
        }
        return null;
    }
}

