/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.check.page;

import com.stimulsoft.base.localization.StiLocalizationExt;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.check.StiCheckStatus;
import com.stimulsoft.report.check.actions.page.StiLargeHeightAtPageAction;
import com.stimulsoft.report.check.page.StiPageCheck;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.bands.StiBand;
import com.stimulsoft.report.dialogs.IStiForm;

public class StiLargeHeightAtPageCheck
extends StiPageCheck {
    @Override
    public String getShortMessage() {
        return StiLocalizationExt.Get((String)"CheckComponent", (String)"StiLargeHeightAtPageCheckShort");
    }

    @Override
    public String getLongMessage() {
        return StiLocalizationExt.format((String)"CheckComponent", (String)"StiLargeHeightAtPageCheckLong", (Object[])new Object[]{this.getElement()});
    }

    @Override
    public StiCheckStatus getStatus() {
        return StiCheckStatus.Information;
    }

    private boolean check() {
        StiPage page;
        StiPage stiPage = page = this.getElement() instanceof StiPage ? (StiPage)this.getElement() : null;
        if (!(page instanceof IStiForm)) {
            double sumHeight = 0.0;
            int count = 0;
            for (StiComponent comp : page.getComponents()) {
                if (!(comp instanceof StiBand) || ((StiBand)comp).getIsCross()) continue;
                sumHeight += comp.getHeight();
                ++count;
            }
            if (page.getReport().getInfo().getShowHeaders() && count > 0) {
                sumHeight += page.getGridSize() * (double)count * 2.0;
            }
            sumHeight += count > 1 ? page.getGridSize() * (double)count - 1.0 : page.getGridSize();
            double pageHeight = page.getHeight();
            if ((pageHeight *= page.getLargeHeight() ? (double)page.getLargeHeightFactor() : 1.0) - sumHeight <= pageHeight * 0.1) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object processCheck(StiReport report, Object obj) {
        this.setElement(obj);
        boolean failed = this.check();
        if (failed) {
            StiLargeHeightAtPageCheck check = new StiLargeHeightAtPageCheck();
            check.setElement(obj);
            check.getActions().add(new StiLargeHeightAtPageAction());
            return check;
        }
        return null;
    }
}

