/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.check.page;

import com.stimulsoft.base.localization.StiLocalizationExt;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.check.StiCheckStatus;
import com.stimulsoft.report.check.actions.page.StiDeleteLostPointsAction;
import com.stimulsoft.report.check.page.StiPageCheck;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.components.StiPage;
import com.stimulsoft.report.components.simplecomponents.StiCrossLinePrimitive;
import com.stimulsoft.report.components.simplecomponents.StiEndPointPrimitive;
import com.stimulsoft.report.components.simplecomponents.StiPointPrimitive;
import com.stimulsoft.report.components.simplecomponents.StiStartPointPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class StiLostPointsOnPageCheck
extends StiPageCheck {
    private String lostPointsNames = "";

    @Override
    public boolean getPreviewVisible() {
        return false;
    }

    private StiPage getPage() {
        return this.getElement() instanceof StiPage ? (StiPage)this.getElement() : null;
    }

    @Override
    public String getShortMessage() {
        return StiLocalizationExt.format((String)"CheckPage", (String)"StiLostPointsOnPageCheckShort", (Object[])new Object[]{this.getElementName(), this.getLostPointsNames()});
    }

    @Override
    public String getLongMessage() {
        return StiLocalizationExt.format((String)"CheckPage", (String)"StiLostPointsOnPageCheckLong", (Object[])new Object[]{this.getElementName(), this.getLostPointsNames()});
    }

    public String getLostPointsNames() {
        return this.lostPointsNames;
    }

    public void setLostPointsNames(String lostPointsNames) {
        this.lostPointsNames = lostPointsNames;
    }

    @Override
    public StiCheckStatus getStatus() {
        return StiCheckStatus.Warning;
    }

    public static List<StiPointPrimitive> getLostPointsOnPage(StiPage page) {
        StiComponentsCollection comps = page.getComponents();
        HashMap<StiPointPrimitive, StiPointPrimitive> points = new HashMap<StiPointPrimitive, StiPointPrimitive>();
        ArrayList<StiCrossLinePrimitive> lines = new ArrayList<StiCrossLinePrimitive>();
        for (StiComponent comp : comps) {
            if (comp instanceof StiPointPrimitive) {
                points.put((StiPointPrimitive)comp, (StiPointPrimitive)comp);
                continue;
            }
            if (!(comp instanceof StiCrossLinePrimitive)) continue;
            lines.add((StiCrossLinePrimitive)comp);
        }
        for (StiCrossLinePrimitive line : lines) {
            StiStartPointPrimitive startPoint = line.getStartPoint(line.getPage());
            StiEndPointPrimitive endPoint = line.getEndPoint(line.getPage());
            if (startPoint != null && points.containsKey(startPoint)) {
                points.remove(startPoint);
            }
            if (endPoint == null || !points.containsKey(endPoint)) continue;
            points.remove(endPoint);
        }
        ArrayList<StiPointPrimitive> lostPoints = new ArrayList<StiPointPrimitive>();
        for (StiPointPrimitive point : points.values()) {
            lostPoints.add(point);
        }
        return lostPoints;
    }

    @Override
    public Object processCheck(StiReport report, Object obj) {
        StiPage page = obj instanceof StiPage ? (StiPage)obj : null;
        List<StiPointPrimitive> points = StiLostPointsOnPageCheck.getLostPointsOnPage(page);
        if (points != null && points.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (StiPointPrimitive point : points) {
                if (sb.length() > 0) {
                    sb = sb.append(", ");
                }
                sb = sb.append(point.getName());
            }
            StiLostPointsOnPageCheck check = new StiLostPointsOnPageCheck();
            check.setElement(obj);
            check.lostPointsNames = sb.toString();
            check.getActions().add(new StiDeleteLostPointsAction());
            return check;
        }
        return null;
    }
}

