/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.check.report;

import com.stimulsoft.base.localization.StiLocalizationExt;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.check.StiCheckStatus;
import com.stimulsoft.report.check.actions.component.StiGenerateNewNameComponentAction;
import com.stimulsoft.report.check.actions.datasource.StiDeleteDataSourceAction;
import com.stimulsoft.report.check.actions.datasource.StiGenerateNewNameDataSourceAction;
import com.stimulsoft.report.check.actions.report.StiEditNameAction;
import com.stimulsoft.report.check.report.StiReportCheck;
import com.stimulsoft.report.components.StiComponent;
import com.stimulsoft.report.components.StiComponentsCollection;
import com.stimulsoft.report.dictionary.StiDataBuilder;
import com.stimulsoft.report.dictionary.StiDataRelation;
import com.stimulsoft.report.dictionary.dataSources.StiDataSource;
import com.stimulsoft.report.enums.StiCalculationMode;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class StiDuplicatedNameCheck
extends StiReportCheck {
    private boolean dataSource = false;
    private StiDataBuilder dataBuilder = new StiDataBuilder();

    public boolean isDataSource() {
        return this.dataSource;
    }

    public void setDataSource(boolean dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getElementName() {
        if (this.getElement() == null) {
            return null;
        }
        if (this.getElement() instanceof StiDataSource) {
            return ((StiDataSource)this.getElement()).getName();
        }
        if (this.getElement() instanceof StiDataRelation) {
            return ((StiDataRelation)this.getElement()).getName();
        }
        if (this.getElement() instanceof StiComponent) {
            return ((StiComponent)this.getElement()).getName();
        }
        return null;
    }

    @Override
    public boolean getPreviewVisible() {
        return this.getElement() instanceof StiComponent || this.getElement() instanceof StiDataSource;
    }

    @Override
    public String getShortMessage() {
        return StiLocalizationExt.format((String)"CheckReport", (String)"StiDuplicatedNameCheckShort", (Object[])new Object[0]);
    }

    @Override
    public String getLongMessage() {
        return StiLocalizationExt.format((String)"CheckReport", (String)(this.isDataSource() ? "StiDuplicatedName2CheckLong" : "StiDuplicatedNameCheckLong"), (Object[])new Object[]{this.getElementName()});
    }

    @Override
    public StiCheckStatus getStatus() {
        return StiCheckStatus.Error;
    }

    @Override
    public Object processCheck(StiReport report, Object obj) {
        this.setElement(obj);
        ArrayList<StiDuplicatedNameCheck> checks = null;
        Hashtable<String, String> hash = new Hashtable<String, String>();
        Iterator i$ = report.getDictionary().getDataSources().iterator();
        while (i$.hasNext()) {
            StiDataSource dataSource = (StiDataSource)i$.next();
            if (hash.containsKey(dataSource.getName())) {
                StiDuplicatedNameCheck check = new StiDuplicatedNameCheck();
                check.setElement(dataSource);
                check.setDataSource(true);
                check.getActions().add(new StiEditNameAction());
                check.getActions().add(new StiGenerateNewNameDataSourceAction());
                check.getActions().add(new StiDeleteDataSourceAction());
                if (checks == null) {
                    checks = new ArrayList<StiDuplicatedNameCheck>();
                }
                checks.add(check);
                continue;
            }
            hash.put(dataSource.getName(), dataSource.getName());
        }
        if (report.getCalculationMode() == StiCalculationMode.Interpretation) {
            return null;
        }
        StiComponentsCollection comps = report.getComponents();
        for (StiComponent comp : comps) {
            if (hash.containsKey(comp.getName())) {
                StiDuplicatedNameCheck check = new StiDuplicatedNameCheck();
                check.setElement(comp);
                check.getActions().add(new StiEditNameAction());
                check.getActions().add(new StiGenerateNewNameComponentAction());
                if (checks == null) {
                    checks = new ArrayList();
                }
                checks.add(check);
                continue;
            }
            hash.put(comp.getName(), comp.getName());
        }
        return checks;
    }
}

