/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.codedom;

import com.stimulsoft.report.components.simplecomponents.StiRichText;
import java.util.ArrayList;
import java.util.List;

public class StiCodeDomExpressionHelper {
    public static List<String> getLexem(String script) {
        return StiCodeDomExpressionHelper.getLexemSimple(null, script, null);
    }

    public static List<String> getLexemSimple(Object codeGenerator, String script, StiRichText richText) {
        ArrayList<String> al = new ArrayList<String>();
        StringBuilder lexem = new StringBuilder();
        boolean code = false;
        for (int pos = 0; pos < script.length(); ++pos) {
            if (!code) {
                if (script.charAt(pos) == '{') {
                    code = true;
                    lexem = new StringBuilder();
                    continue;
                }
                lexem = lexem.append(script.charAt(pos));
                continue;
            }
            if (script.charAt(pos) == '\"') {
                pos = StiCodeDomExpressionHelper.readString(codeGenerator, pos, lexem, script, al, richText != null, false);
                continue;
            }
            if (script.charAt(pos) == '\'') {
                pos = StiCodeDomExpressionHelper.readChar(pos, lexem, script);
                continue;
            }
            if (script.charAt(pos) == '}') {
                code = false;
                if (codeGenerator == null) {
                    String str = lexem.toString();
                    lexem = new StringBuilder();
                    lexem = lexem.append("{");
                    lexem = lexem.append(str);
                    lexem = lexem.append("}");
                }
                if (lexem.length() > 0) {
                    al.add(lexem.toString());
                }
                lexem = new StringBuilder();
                continue;
            }
            lexem = lexem.append(script.charAt(pos));
        }
        if (code) {
            al.clear();
        }
        return al;
    }

    public static int readString(Object codeGenerator, int pos, StringBuilder lexem, String script, List<String> al, boolean isRichText, boolean fullRtf) {
        lexem = lexem.append(script.charAt(pos++));
        StringBuilder sb = new StringBuilder();
        while (pos != script.length() && script.charAt(pos) != '\"') {
            if (script.charAt(pos) == '\\' && pos + 1 != script.length()) {
                if (script.charAt(pos + 1) == '\\') {
                    sb.append("\\\\");
                    pos += 2;
                    continue;
                }
                if (script.charAt(pos + 1) == '\"') {
                    // empty if block
                }
            }
            int n = ++pos;
            ++pos;
            sb.append(script.charAt(n));
        }
        String str = sb.toString();
        lexem = str.startsWith("\"") && str.endsWith("\"") && str.length() > 1 ? lexem.append(str.substring(1, str.length() - 1)) : lexem.append(str);
        if (pos != script.length()) {
            lexem = lexem.append(script.charAt(pos));
            ++pos;
        }
        if (pos == script.length()) {
            if (lexem.length() > 0) {
                al.add(lexem.toString());
            }
            lexem = new StringBuilder();
        }
        return --pos;
    }

    private static int readChar(int pos, StringBuilder lexem, String script) {
        lexem.append(script.charAt(pos++));
        if (pos != script.length()) {
            lexem.append(script.charAt(pos++));
        }
        if (pos != script.length()) {
            lexem.append(script.charAt(pos));
        }
        return pos;
    }
}

