/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components;

import com.stimulsoft.base.drawing.StiColorEnum;
import com.stimulsoft.base.drawing.StiGlyph;
import com.stimulsoft.base.drawing.StiHtmlState;
import com.stimulsoft.base.drawing.StiHtmlTagsState;
import com.stimulsoft.base.drawing.StiTextRendererParseHtml;
import com.stimulsoft.base.drawing.StiTextUtil;
import com.stimulsoft.base.drawing.enums.StiTextHorAlignment;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.StiSize;
import com.stimulsoft.report.components.simplecomponents.StiText;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.List;

public class StiStandardTextRenderer {
    private static final double MEASURE_QUALITY = 5.0;

    private StiStandardTextRenderer() {
    }

    public static StiSize MeasureString(double maxWidth, StiFont font, StiText textBox) {
        return StiStandardTextRenderer.MeasureString((int)maxWidth, font, textBox);
    }

    public static StiSize MeasureString(int maxWidth, StiFont stiFont, StiText textBox) {
        if (textBox.getAllowHtmlTags()) {
            return StiStandardTextRenderer.MeasureHTMLString(maxWidth, stiFont, textBox);
        }
        return StiStandardTextRenderer.MeasureString(maxWidth, stiFont, textBox.getAngle(), textBox.getText().getValue(), textBox.getWordWrap());
    }

    public static StiSize MeasureHTMLString(double maxWidth, StiFont font, StiText textBox) {
        StiHtmlTagsState baseTagsState = new StiHtmlTagsState(font.bold(), font.italic(), font.underline(), font.strikeout(), (float)font.size, font.getName(), StiColorEnum.Black.color(), StiColorEnum.Transparent.color(), false, false, 0.0, 0.0, 1.0, textBox.getHorAlignment());
        StiHtmlState baseState = new StiHtmlState(baseTagsState, 0);
        List htmlStates = StiTextRendererParseHtml.parseHtmlToStates((String)textBox.getText().getValue(), (StiHtmlState)baseState);
        Graphics2D g = new BufferedImage(1, 1, 2).createGraphics();
        List glyphs = StiTextRendererParseHtml.getGlyphs((List)htmlStates, (Graphics2D)g);
        double paneWidth = textBox.getWordWrap() || textBox.getHorAlignment().equals((Object)StiTextHorAlignment.Width) ? maxWidth : 1.0E9;
        int pos = 0;
        double height = 0.0;
        double width = 0.0;
        while (pos < glyphs.size()) {
            StiTextRendererParseHtml.StiRenderLine line = new StiTextRendererParseHtml.StiRenderLine();
            height = (pos = StiTextRendererParseHtml.getNextLine((List)glyphs, (int)pos, (double)paneWidth, (Graphics2D)g, (StiTextRendererParseHtml.StiRenderLine)line)) < glyphs.size() ? (height += line.height) : (height += line.height / ((StiGlyph)line.glyphs.get((int)0)).ts.lineHeight);
            width = Math.max(width, line.width);
        }
        return new StiSize(width, height);
    }

    public static StiSize MeasureString(double maxWidth, StiFont stiFont, float angle, String text, boolean wordWrap) {
        stiFont.size *= 5.0;
        StiSize size = StiTextUtil.measureString((double)(maxWidth *= 5.0), (StiFont)stiFont, (String)text, (float)angle, (boolean)wordWrap);
        stiFont.size /= 5.0;
        size.width /= 5.0;
        size.height /= 5.0;
        return size.getStiSize();
    }

    public static StiSize measureString(StiFont font, String text, float angle) {
        return StiTextUtil.measureString((StiFont)font, (String)text, (float)angle);
    }
}

