/*
 * Decompiled with CFR 0.152.
 */
package com.stimulsoft.report.components;

import com.stimulsoft.base.IStiJsonReportObject;
import com.stimulsoft.base.StiJsonReportObjectHelper;
import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.drawing.StiBrush;
import com.stimulsoft.base.drawing.StiColor;
import com.stimulsoft.base.drawing.StiSolidBrush;
import com.stimulsoft.base.enums.StiContentAlignment;
import com.stimulsoft.base.json.JProperty;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import com.stimulsoft.base.serializing.StiSerializedObject;
import com.stimulsoft.base.serializing.annotations.StiDefaulValue;
import com.stimulsoft.base.serializing.annotations.StiSerializable;
import com.stimulsoft.base.serializing.annotations.StiSerializeTypesEnum;
import com.stimulsoft.base.system.StiFont;
import com.stimulsoft.base.system.geometry.StiRectangle;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.components.simplecomponents.StiImage;
import com.stimulsoft.report.components.simplecomponents.StiImageHelper;
import com.stimulsoft.report.helpers.StiHyperlinkProcessor;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class StiWatermark
extends StiSerializedObject
implements Cloneable,
IStiJsonReportObject {
    static String def = StiSerializeTypesEnum.SerializeToAll.name();
    private double angle = 45.0;
    private boolean aspectRatio;
    private StiImage cachedImage;
    private boolean enabled = true;
    private StiFont font = new StiFont("Arial", 100.0);
    private double imageMultipleFactor = 1.0;
    private boolean imageStretch;
    private boolean imageTiling;
    private int imageTransparency;
    private boolean rightToLeft;
    private boolean showBehind;
    private boolean showImageBehind = true;
    private String text = "";
    private StiBrush textBrush = new StiSolidBrush(StiColor.fromArgb((int)50, (int)0, (int)0, (int)0));
    private String imageBytes;
    private StiContentAlignment imageAlignment = StiContentAlignment.MiddleCenter;
    private BufferedImage bufferedImage = null;
    private String enabledExpression = "";
    private String imageHyperlink = "";

    public StiWatermark() {
    }

    public StiWatermark(StiBrush textBrush, String text, double angle, StiFont font, boolean showBehind) {
        this(textBrush, text, angle, font, showBehind, true, false);
    }

    public StiWatermark(StiBrush textBrush, String text, double angle, StiFont font, boolean showBehind, boolean enabled, boolean aspectRatio) {
        this(textBrush, text, angle, font, showBehind, enabled, aspectRatio, false);
    }

    public StiWatermark(StiBrush textBrush, String text, double angle, StiFont font, boolean showBehind, boolean enabled, boolean aspectRatio, boolean rightToLeft) {
        this.textBrush = textBrush;
        this.text = text;
        this.angle = angle;
        this.font = font;
        this.showBehind = showBehind;
        this.enabled = enabled;
        this.aspectRatio = aspectRatio;
        this.rightToLeft = rightToLeft;
    }

    public JSONObject SaveToJsonObject(StiJsonSaveMode mode) throws JSONException {
        JSONObject jObject = new JSONObject();
        jObject.AddPropertyStringNullOfEmpty("Font", StiJsonReportObjectHelper.Serialize.font((StiFont)this.getFont(), (String)"Arial", (float)100.0f));
        jObject.AddPropertyStringNullOfEmpty("TextBrush", StiJsonReportObjectHelper.Serialize.JBrush((StiBrush)this.getTextBrush()));
        jObject.AddPropertyStringNullOfEmpty("Text", this.getText());
        jObject.AddPropertyStringNullOfEmpty("ImageHyperlink", this.imageHyperlink);
        jObject.AddPropertyDouble("Angle", this.getAngle(), 45.0);
        jObject.AddPropertyBool("Enabled", this.getEnabled(), true);
        jObject.AddPropertyBool("ShowImageBehind", this.getShowImageBehind(), true);
        jObject.AddPropertyBool("ShowBehind", this.getShowBehind());
        jObject.AddPropertyBool("RightToLeft", this.getRightToLeft());
        jObject.AddPropertyDouble("ImageMultipleFactor", this.getImageMultipleFactor(), 1.0);
        jObject.AddPropertyInt("ImageTransparency", this.getImageTransparency(), 0);
        jObject.AddPropertyStringNullOfEmpty("ImageBytes", this.getImageBytes());
        jObject.AddPropertyEnum("ImageAlignment", (Enum)this.getImageAlignment(), (Enum)StiContentAlignment.MiddleCenter);
        jObject.AddPropertyBool("ImageTiling", this.getImageTiling());
        jObject.AddPropertyBool("ImageStretch", this.getImageStretch());
        jObject.AddPropertyBool("AspectRatio", this.getAspectRatio());
        jObject.AddPropertyStringNullOfEmpty("EnabledExpression", this.getEnabledExpression());
        if (jObject.length() == 0) {
            return null;
        }
        return jObject;
    }

    public void LoadFromJsonObject(JSONObject jObject) throws JSONException {
        for (JProperty property : jObject.Properties()) {
            if (property.Name.equals("Font")) {
                this.font = StiJsonReportObjectHelper.Deserialize.Font((JProperty)property, (StiFont)this.font);
                continue;
            }
            if (property.Name.equals("TextBrush")) {
                this.textBrush = StiJsonReportObjectHelper.Deserialize.Brush((JProperty)property);
                continue;
            }
            if (property.Name.equals("ImageHyperlink")) {
                this.imageHyperlink = (String)property.Value;
                continue;
            }
            if (property.Name.equals("Text")) {
                this.text = (String)property.Value;
                continue;
            }
            if (property.Name.equals("EnabledExpression")) {
                this.enabledExpression = (String)property.Value;
                continue;
            }
            if (property.Name.equals("Angle")) {
                this.angle = property.floatValue().floatValue();
                continue;
            }
            if (property.Name.equals("Enabled")) {
                this.enabled = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("ShowImageBehind")) {
                this.showImageBehind = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("ShowBehind")) {
                this.showBehind = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("RightToLeft")) {
                this.rightToLeft = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("ImageMultipleFactor")) {
                this.imageMultipleFactor = property.doubleValue();
                continue;
            }
            if (property.Name.equals("ImageTransparency")) {
                this.imageTransparency = (Integer)property.Value;
                continue;
            }
            if (property.Name.equals("Image")) {
                this.imageBytes = (String)property.Value;
                continue;
            }
            if (property.Name.equals("ImageBytes")) {
                this.imageBytes = (String)property.Value;
                continue;
            }
            if (property.Name.equals("ImageAlignment")) {
                this.imageAlignment = StiContentAlignment.valueOf((String)((String)property.Value));
                continue;
            }
            if (property.Name.equals("ImageTiling")) {
                this.imageTiling = (Boolean)property.Value;
                continue;
            }
            if (property.Name.equals("ImageStretch")) {
                this.imageStretch = (Boolean)property.Value;
                continue;
            }
            if (!property.Name.equals("AspectRatio")) continue;
            this.aspectRatio = (Boolean)property.Value;
        }
    }

    public BufferedImage getBufferedImage(StiReport report, StiRectangle rect) {
        if (!(this.bufferedImage != null || this.imageBytes == null && StiValidationUtil.isNullOrWhiteSpace((String)this.imageHyperlink))) {
            try {
                if (StiValidationUtil.isNullOrWhiteSpace((String)this.imageHyperlink)) {
                    this.bufferedImage = StiImageHelper.decodeImage(this.imageBytes, rect);
                } else {
                    byte[] bytes = StiHyperlinkProcessor.getBytes(report, this.imageHyperlink);
                    this.bufferedImage = StiImageHelper.decodeImage(bytes, rect);
                }
            }
            catch (IOException e) {
                System.out.println("Can't decode image: " + e.getMessage());
                e.printStackTrace();
            }
        }
        return this.bufferedImage;
    }

    @StiSerializable
    public String getImageBytes() {
        return this.imageBytes;
    }

    public void setImageBytes(String value) {
        this.imageBytes = value;
    }

    public void putImage(byte[] image) throws UnsupportedEncodingException {
        this.setImageBytes(new String(image, "UTF-8"));
    }

    public void putImage(String image) {
        this.setImageBytes(image);
    }

    public void resetImage() {
        this.setImageBytes(null);
    }

    @StiSerializable
    public String getBytes() {
        return null;
    }

    public void setBytes(String value) {
        this.setImageBytes(value);
    }

    public void setImage(String value) {
        this.setImageBytes(value);
    }

    @StiSerializable
    @StiDefaulValue(value="MiddleCenter")
    public StiContentAlignment getImageAlignment() {
        return this.imageAlignment;
    }

    public void setImageAlignment(StiContentAlignment value) {
        this.imageAlignment = value;
    }

    @StiSerializable
    @StiDefaulValue(value="45.0")
    public double getAngle() {
        return this.angle;
    }

    @StiSerializable
    @StiDefaulValue(value="false")
    public final boolean getAspectRatio() {
        return this.aspectRatio;
    }

    @StiSerializable(shortName="enabled")
    @StiDefaulValue(value="true")
    public boolean getEnabled() {
        return this.enabled;
    }

    @StiSerializable(shortName="fn")
    public final StiFont getFont() {
        return this.font;
    }

    @StiSerializable
    @StiDefaulValue(value="1.0")
    public double getImageMultipleFactor() {
        return this.imageMultipleFactor;
    }

    @StiSerializable
    @StiDefaulValue(value="false")
    public boolean getImageStretch() {
        return this.imageStretch;
    }

    @StiSerializable
    @StiDefaulValue(value="false")
    public boolean getImageTiling() {
        return this.imageTiling;
    }

    @StiSerializable
    @StiDefaulValue(value="0")
    public int getImageTransparency() {
        return this.imageTransparency;
    }

    public void setImageTransparency(int imageTransparency) {
        this.imageTransparency = Math.min(Math.max(imageTransparency, 0), 255);
    }

    @StiSerializable
    @StiDefaulValue(value="false")
    public final boolean getRightToLeft() {
        return this.rightToLeft;
    }

    @StiSerializable
    @StiDefaulValue(value="false")
    public boolean getShowBehind() {
        return this.showBehind;
    }

    @StiSerializable
    @StiDefaulValue(value="true")
    public boolean getShowImageBehind() {
        return this.showImageBehind;
    }

    @StiSerializable(shortName="text")
    @StiDefaulValue(value="")
    public String getText() {
        return this.text;
    }

    @StiSerializable(shortName="tb")
    public final StiBrush getTextBrush() {
        return this.textBrush;
    }

    public void setAngle(double value) {
        this.angle = value;
    }

    public final void setAspectRatio(boolean value) {
        this.aspectRatio = value;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public final void setFont(StiFont value) {
        this.font = value;
    }

    public void setImageMultipleFactor(double value) {
        this.imageMultipleFactor = value;
    }

    public void setImageStretch(boolean value) {
        this.imageStretch = value;
    }

    public void setImageTiling(boolean value) {
        this.imageTiling = value;
    }

    public final void setRightToLeft(boolean value) {
        this.rightToLeft = value;
    }

    public void setShowBehind(boolean value) {
        this.showBehind = value;
    }

    public void setShowImageBehind(boolean value) {
        this.showImageBehind = value;
    }

    public void setText(String value) {
        this.text = value;
    }

    public final void setTextBrush(StiBrush value) {
        this.textBrush = value;
    }

    public final boolean ShouldSerializeTextBrush() {
        return !(this.textBrush instanceof StiSolidBrush) || ((StiSolidBrush)this.textBrush).getColor() != StiColor.fromArgb((int)50, (int)0, (int)0, (int)0);
    }

    public final Object clone() {
        try {
            StiWatermark watermark = (StiWatermark)super.clone();
            watermark.font = (StiFont)this.font.clone();
            watermark.textBrush = (StiBrush)this.textBrush.clone();
            return watermark;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @StiSerializable
    public String getEnabledExpression() {
        return this.enabledExpression;
    }

    public void setEnabledExpression(String enabledExpression) {
        this.enabledExpression = enabledExpression;
    }

    @StiSerializable
    public String getImageHyperlink() {
        return this.imageHyperlink;
    }

    public void setImageHyperlink(String imageHyperlink) {
        this.imageHyperlink = imageHyperlink;
    }
}

